% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modSearch.R
\name{modSearch}
\alias{modSearch}
\title{Search MODIS images}
\usage{
modSearch(product, startDate, endDate, collection = 6, resType = "url",
  verbose = FALSE, ...)
}
\arguments{
\item{product}{the short name of the MODIS product.}

\item{startDate}{a \code{Date} class object with the starting date of the 
study period.}

\item{endDate}{a \code{Date} class object with the ending date of the 
study period.}

\item{collection}{MODIS collection. By default, 6.}

\item{resType}{response type of the query (\code{browseurl} or \code{url}).}

\item{verbose}{logical argument. If \code{TRUE}, the function prints the 
running steps and warnings.}

\item{...}{arguments for nested functions:
\itemize{
  \item \code{lonlat} a vector with the longitude/latitude
  coordinates of the point of interest. This argument is mandatory if 
  \code{polygon} or \code{extent} are not defined.
  \item \code{extent}  an \code{extent}, \code{Raster*}, or 
  \code{Spatial*} object representing the region of interest with 
  longitude/latitude coordinates. This argument is mandatory if 
  \code{polygon} or \code{lonlat} are not defined.
  \item \code{polygon} a list of vectors defining the points of a polygon
  with longitude/latitude coordinates. This argument is mandatory if
  \code{lonlat} or \code{extent} are not defined.
}}
}
\description{
\code{modSearch} searches MODIS images in the 
\href{https://lpdaacsvc.cr.usgs.gov/services/inventory}{NASA Common Metadata Repository}
(CMR) concerning a particular location and date interval. The function returns an 
\code{character} vector with the names of the images and their uniform resource
locators (URLs)
}
\details{
\code{modSearch} uses the
\href{https://lpdaacsvc.cr.usgs.gov/services/inventory}{NASA Common Metadata
Repository} (CMR) powered API. The catalogue of MODIS products can be found
\href{https://modis.gsfc.nasa.gov/data/dataprod/}{here}.
The catalogue shows the product short names and provides detailed information
about the product. By the time `RGISTools' is released, NASA carries out the
maintenance of its website on Wednesdays, which may cause an error when
connecting to their server. You can get your `EarthData' credentials
\href{https://urs.earthdata.nasa.gov/users/new}{here}.

The function can be used to retrieve the web address of the preview 
(\code{resType = "browseurl"}) or the actual image (\code{resType = "url"}).
By default, the URL points towards the actual image.
}
\examples{
\dontrun{
# load a spatial polygon object of Navarre with longitude/latitude coordinates
data(ex.navarre)
# searching MODIS MYD13A2 images between 2011 and 2013 by longitude/latitude
# using a polygon class variable
img.list <- modSearch(product = "MYD13A2",
                      startDate = as.Date("01-01-2011", "\%d-\%m-\%Y"),
                      endDate = as.Date("31-12-2013", "\%d-\%m-\%Y"),
                      collection = 6,
                      extent = ex.navarre)
# region of interest: defined based on longitude/latitude extent
# searching MODIS MYD13A2 images in 2010 by longitude/latitude
# using a extent class variable defined by the user
aoi = extent(c(-2.49, -0.72, 41.91, 43.31))
my.imgs <- modSearch(product = "MYD13A2",
                     startDate = as.Date("01-01-2010", "\%d-\%m-\%Y"),
                     endDate = as.Date("31-12-2010", "\%d-\%m-\%Y"),
                     collection = 6,
                     extent = aoi)
head(my.imgs)
}
}
