\alias{GtkIMContext}
\name{GtkIMContext}
\title{GtkIMContext}
\description{Base class for input method contexts}
\section{Methods and Functions}{
\code{\link{gtkIMContextSetClientWindow}(object, window)}\cr
\code{\link{gtkIMContextGetPreeditString}(object)}\cr
\code{\link{gtkIMContextFilterKeypress}(object, event)}\cr
\code{\link{gtkIMContextFocusIn}(object)}\cr
\code{\link{gtkIMContextFocusOut}(object)}\cr
\code{\link{gtkIMContextReset}(object)}\cr
\code{\link{gtkIMContextSetCursorLocation}(object, area)}\cr
\code{\link{gtkIMContextSetUsePreedit}(object, use.preedit)}\cr
\code{\link{gtkIMContextSetSurrounding}(object, text, cursor.index)}\cr
\code{\link{gtkIMContextGetSurrounding}(object)}\cr
\code{\link{gtkIMContextDeleteSurrounding}(object, offset, n.chars)}\cr

}
\section{Hierarchy}{\preformatted{GObject
   +----GtkIMContext
         +----GtkIMContextSimple
         +----GtkIMMulticontext}}
\section{Detailed Description}{\code{\link{GtkIMContext}} defines the interface for GTK+ input methods. An input method
is used by GTK+ text input widgets like \code{\link{GtkEntry}} to map from key events to
Unicode character strings.
  
The user may change the current input method via a context menu, unless the   
\verb{"gtk-show-input-method-menu"} GtkSettings property is set to FALSE. 
The default input method can be set programmatically via the 
\verb{"gtk-im-module"} GtkSettings property. Alternatively, you may set 
the GTK_IM_MODULE environment variable as documented in \verb{gtk-running}.
  
The \code{\link{GtkEntry}} \verb{"im-module"} and \code{\link{GtkTextView}} \verb{"im-module"} 
properties may also be used to set input methods for specific widget 
instances. For instance, a certain entry widget might be expected to contain 
certain characters which would be easier to input with a certain input 
method.
  
An input method may consume multiple key events in sequence and finally
output the composed result. This is called preediting, and an input method
may provide feedback about this process by displaying the intermediate
composition states as preedit text. For instance, the default GTK+ input
method implements the input of arbitrary Unicode code points by holding down
the Control and Shift keys and then typing "U" followed by the hexadecimal
digits of the code point.  When releasing the Control and Shift keys,
preediting ends and the character is inserted as text. Ctrl+Shift+u20AC for
example results in the € sign.
  
Additional input methods can be made available for use by GTK+ widgets as
loadable modules. An input method module is a small shared library which
implements a subclass of \code{\link{GtkIMContext}} or \code{\link{GtkIMContextSimple}} and exports
these four functions:
  \preformatted{void im_module_init(  GTypeModule   *module);
}
This function should register the \code{\link{GType}} of the \code{\link{GtkIMContext}} subclass which
implements the input method by means of \code{gTypeModuleRegisterType()}. Note
that \code{gTypeRegisterStatic()} cannot be used as the type needs to be
registered dynamically.
  \preformatted{void im_module_exit(void);
}
Here goes any cleanup code your input method might require on module unload.
  \preformatted{void im_module_list(const   GtkIMContextInfo   ***contexts, int *n_contexts)
{
  *contexts = info_list;
  *n_contexts = G_N_ELEMENTS (info_list);
}
}
This function returns the list of input methods provided by the module. The
example implementation above shows a common solution and simply returns a
pointer to statically defined list of \verb{GtkIMContextInfo} items for each
provided input method.
  \preformatted{GtkIMContext   * im_module_create(const   gchar   *context_id);
}
This function should return a pointer to a newly created instance of the
\code{\link{GtkIMContext}} subclass identified by \code{context.id}. The context ID is the same
as specified in the \verb{GtkIMContextInfo} list returned by \code{imModuleList()}.
  
After a new loadable input method module has been installed on the system,
the configuration file \file{gtk.immodules} needs to be
regenerated by gtk-query-immodules-2.0,
in order for the new input method to become available to GTK+ applications.}
\section{Structures}{\describe{\item{\verb{GtkIMContext}}{
\emph{undocumented
}

}}}
\section{Signals}{\describe{
\item{\code{commit(context, str, user.data)}}{
The ::commit signal is emitted when a complete input sequence
has been entered by the user. This can be a single character
immediately after a key press or the final result of preediting.

\describe{
\item{\code{context}}{the object on which the signal is emitted}
\item{\code{str}}{the completed character(s) entered by the user}
\item{\code{user.data}}{user data set when the signal handler was connected.}
}


}
\item{\code{delete-surrounding(context, offset, n.chars, user.data)}}{
The ::delete-surrounding signal is emitted when the input method
needs to delete all or part of the context surrounding the cursor.

\describe{
\item{\code{context}}{the object on which the signal is emitted}
\item{\code{offset}}{the character offset from the cursor position of the text
          to be deleted. A negative value indicates a position before
          the cursor.}
\item{\code{n.chars}}{the number of characters to be deleted}
\item{\code{user.data}}{user data set when the signal handler was connected.}
}

\emph{Returns:} [logical] \code{TRUE} if the signal was handled.

}
\item{\code{preedit-changed(context, user.data)}}{
The ::preedit-changed signal is emitted whenever the preedit sequence
currently being entered has changed.  It is also emitted at the end of
a preedit sequence, in which case
\code{\link{gtkIMContextGetPreeditString}} returns the empty string.

\describe{
\item{\code{context}}{the object on which the signal is emitted}
\item{\code{user.data}}{user data set when the signal handler was connected.}
}


}
\item{\code{preedit-end(context, user.data)}}{
The ::preedit-end signal is emitted when a preediting sequence
has been completed or canceled.

\describe{
\item{\code{context}}{the object on which the signal is emitted}
\item{\code{user.data}}{user data set when the signal handler was connected.}
}


}
\item{\code{preedit-start(context, user.data)}}{
The ::preedit-start signal is emitted when a new preediting sequence
starts.

\describe{
\item{\code{context}}{the object on which the signal is emitted}
\item{\code{user.data}}{user data set when the signal handler was connected.}
}


}
\item{\code{retrieve-surrounding(context, user.data)}}{
The ::retrieve-surrounding signal is emitted when the input method
requires the context surrounding the cursor.  The callback should set
the input method surrounding context by calling the
\code{\link{gtkIMContextSetSurrounding}} method.

\describe{
\item{\code{context}}{the object on which the signal is emitted}
\item{\code{user.data}}{user data set when the signal handler was connected.}
}

\emph{Returns:} [logical] \code{TRUE} if the signal was handled.

}
}}
\references{\url{http://library.gnome.org/devel//gtk/GtkIMContext.html}}
\author{Derived by RGtkGen from GTK+ documentation}
\keyword{internal}
