/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.store.fs.FileObject;
import org.h2.store.fs.FileSystemDisk;
import org.h2.store.fs.FileSystemMemory;
import org.h2.util.ClassUtils;
import org.h2.util.New;

public abstract class FileSystem {
    private static boolean defaultServicesRegistered;
    private static final ArrayList<FileSystem> SERVICES;

    public static FileSystem getInstance(String string) {
        if (string.indexOf(58) >= 0) {
            if (FileSystemMemory.getInstance().accepts(string)) {
                return FileSystemMemory.getInstance();
            }
            FileSystem.registerDefaultServices();
            for (FileSystem fileSystem : SERVICES) {
                if (!fileSystem.accepts(string)) continue;
                return fileSystem;
            }
        }
        return FileSystemDisk.getInstance();
    }

    private static synchronized void registerDefaultServices() {
        if (!defaultServicesRegistered) {
            defaultServicesRegistered = true;
            for (String string : new String[]{"org.h2.store.fs.FileSystemZip", "org.h2.store.fs.FileSystemSplit", "org.h2.store.fs.FileSystemDiskNio", "org.h2.store.fs.FileSystemDiskNioMapped"}) {
                try {
                    ClassUtils.loadSystemClass(string);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
    }

    public static synchronized void register(FileSystem fileSystem) {
        FileSystem.registerDefaultServices();
        SERVICES.add(fileSystem);
    }

    public static synchronized void unregister(FileSystem fileSystem) {
        SERVICES.remove(fileSystem);
    }

    protected abstract boolean accepts(String var1);

    public abstract long length(String var1);

    public abstract void rename(String var1, String var2) throws SQLException;

    public abstract boolean createNewFile(String var1) throws SQLException;

    public abstract boolean exists(String var1);

    public abstract void delete(String var1) throws SQLException;

    public abstract boolean tryDelete(String var1);

    public abstract String createTempFile(String var1, String var2, boolean var3, boolean var4) throws IOException;

    public abstract String[] listFiles(String var1) throws SQLException;

    public abstract void deleteRecursive(String var1, boolean var2) throws SQLException;

    public abstract boolean isReadOnly(String var1);

    public abstract String normalize(String var1) throws SQLException;

    public abstract String getParent(String var1);

    public abstract boolean isDirectory(String var1);

    public abstract boolean isAbsolute(String var1);

    public abstract String getAbsolutePath(String var1);

    public abstract long getLastModified(String var1);

    public abstract boolean canWrite(String var1);

    public abstract void copy(String var1, String var2) throws SQLException;

    public void mkdirs(String string) throws SQLException {
        this.createDirs(string + "/x");
    }

    public abstract void createDirs(String var1) throws SQLException;

    public abstract String getFileName(String var1);

    public abstract boolean fileStartsWith(String var1, String var2);

    public abstract OutputStream openFileOutputStream(String var1, boolean var2) throws SQLException;

    public abstract FileObject openFileObject(String var1, String var2) throws IOException;

    public abstract InputStream openFileInputStream(String var1) throws IOException;

    static {
        SERVICES = New.arrayList();
    }
}

