% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HRT.R
\name{plot,HRT-method}
\alias{plot,HRT-method}
\title{Plot an HRT object}
\usage{
\S4method{plot}{HRT}(
  x,
  cropped = TRUE,
  TT = FALSE,
  pch = 20,
  xlab = "# of RR interval",
  ylab = "length of RR interval (ms)",
  paramsLegend = TRUE,
  colTO = "#ec2023",
  colTS = "#006AFF",
  colTT = "#6800DE",
  add = FALSE,
  ...
)
}
\arguments{
\item{x}{(HRT) A HRT object}

\item{cropped}{(Boolean) Should the plot be cut to focus on the HRT parameters?
To show all points use FALSE.}

\item{TT}{(Boolean) Should Turbulence timing be marked?}

\item{pch}{(Numeric) Plotting character, for other options see graphics::var}

\item{xlab}{(Character) Label for the x axis}

\item{ylab}{(Character) Label for the y axis}

\item{paramsLegend}{(Boolean) Should the parameter values of the HRT be plotted?}

\item{colTO}{(Character) Colour used to highlight TO}

\item{colTS}{(Character) Colour used to highlight TS}

\item{colTT}{(Character) Colour used to highlight TT}

\item{add}{(Boolean) Should the given HRT be added to a plot?}

\item{...}{Other arguments in tag = value form. See graphics::par for more information.}
}
\value{
No return value
}
\description{
Plots RR-intervals saved in the HRT object and marks
turbulence onset and turbulence slope.
}
\note{
Please note that some graphics parameters (par) cannot be modified,
 since they are needed to be set inside the function.
}
\examples{
# You need an HRT object
hrt <- vectorToHRT(testdataLong, testdataLong_Ann)@HRTs[[1]]

# Plot your HRT and zoom out
plot(hrt, cropped = FALSE)

# Include TT and customise it
plot(hrt, TT = TRUE, colTT = "green", pch = 7)

# Use standard graphics parameters
## Note: Some parameters are used inside the function and cannot be set
plot(hrt, TT = TRUE, main = "Example plot", bty = "n", cex.lab = 1.2)

}
