/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.gui.ImageCanvas;
import ij.gui.ScrollbarWithLabel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Scrollbar;

public class ImageLayout
implements LayoutManager {
    int hgap;
    int vgap;
    ImageCanvas ic;

    public ImageLayout(ImageCanvas imageCanvas) {
        this.ic = imageCanvas;
        this.hgap = 5;
        this.vgap = 5;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            Dimension dimension2 = component.getPreferredSize();
            dimension.width = Math.max(dimension.width, dimension2.width);
            if (i > 0) {
                dimension.height += this.vgap;
            }
            dimension.height += dimension2.height;
        }
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right + this.hgap * 2;
        dimension.height += insets.top + insets.bottom + this.vgap * 2;
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    private void moveComponents(Container container, int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        n2 += n4 / 2;
        for (int i = 0; i < n5; ++i) {
            Component component = container.getComponent(i);
            Dimension dimension = component.getSize();
            if (i == 0 || dimension.height > 60) {
                n6 = n + (n3 - dimension.width) / 2;
            }
            component.setLocation(n6, n2);
            n2 += this.vgap + dimension.height;
        }
    }

    public void layoutContainer(Container container) {
        Dimension dimension;
        int n;
        Insets insets = container.getInsets();
        int n2 = container.getComponentCount();
        int n3 = 0;
        for (n = 1; n < n2; ++n) {
            Component component = container.getComponent(n);
            dimension = component.getPreferredSize();
            n3 += dimension.height;
        }
        dimension = container.getSize();
        n = dimension.width - (insets.left + insets.right + this.hgap * 2);
        int n4 = dimension.height - (insets.top + insets.bottom + this.vgap * 2 + n3);
        this.ic.resizeCanvas(n, n4);
        int n5 = dimension.width - (insets.left + insets.right + this.hgap * 2);
        int n6 = dimension.height - (insets.top + insets.bottom + this.vgap * 2);
        Dimension dimension2 = this.preferredLayoutSize(container);
        int n7 = insets.left + this.hgap + (dimension.width - dimension2.width) / 2;
        int n8 = 0;
        int n9 = 0;
        for (int i = 0; i < n2; ++i) {
            Component component = container.getComponent(i);
            dimension = component.getPreferredSize();
            if (component instanceof ScrollbarWithLabel || component instanceof Scrollbar) {
                int n10 = container.getComponent((int)0).getPreferredSize().width;
                Dimension dimension3 = component.getMinimumSize();
                if (n10 < dimension3.width) {
                    n10 = dimension3.width;
                }
                component.setSize(n10, dimension.height);
            } else {
                component.setSize(dimension.width, dimension.height);
            }
            if (n8 > 0) {
                n8 += this.vgap;
            }
            n8 += dimension.height;
            n9 = Math.max(n9, dimension.width);
        }
        this.moveComponents(container, n7, insets.top + this.vgap, n9, n6 - n8, n2);
    }
}

