/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.Line;
import ij.gui.PointRoi;
import ij.gui.ShapeRoi;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.plugin.frame.Recorder;
import ij.process.FloatPolygon;
import ij.process.ImageProcessor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.io.Serializable;

public class Roi
implements Cloneable,
Serializable {
    public static final int CONSTRUCTING = 0;
    public static final int MOVING = 1;
    public static final int RESIZING = 2;
    public static final int NORMAL = 3;
    public static final int MOVING_HANDLE = 4;
    public static final int RECTANGLE = 0;
    public static final int OVAL = 1;
    public static final int POLYGON = 2;
    public static final int FREEROI = 3;
    public static final int TRACED_ROI = 4;
    public static final int LINE = 5;
    public static final int POLYLINE = 6;
    public static final int FREELINE = 7;
    public static final int ANGLE = 8;
    public static final int COMPOSITE = 9;
    public static final int POINT = 10;
    public static final int HANDLE_SIZE = 5;
    public static final int NOT_PASTING = -1;
    static final int NO_MODS = 0;
    static final int ADD_TO_ROI = 1;
    static final int SUBTRACT_FROM_ROI = 2;
    int startX;
    int startY;
    int x;
    int y;
    int width;
    int height;
    int activeHandle;
    int state;
    int modState = 0;
    int arcSize;
    public static Roi previousRoi;
    public static final BasicStroke onePixelWide;
    protected static Color ROIColor;
    protected static int pasteMode;
    protected static int lineWidth;
    protected static Color defaultFillColor;
    protected int type;
    protected int xMax;
    protected int yMax;
    protected ImagePlus imp;
    private int imageID;
    protected ImageCanvas ic;
    protected int oldX;
    protected int oldY;
    protected int oldWidth;
    protected int oldHeight;
    protected int clipX;
    protected int clipY;
    protected int clipWidth;
    protected int clipHeight;
    protected ImagePlus clipboard;
    protected boolean constrain;
    protected boolean center;
    protected boolean aspect;
    protected boolean updateFullWindow;
    protected double mag = 1.0;
    protected double asp_bk;
    protected String name;
    protected ImageProcessor cachedMask;
    protected Color handleColor = Color.white;
    protected Color strokeColor;
    protected Color instanceColor;
    protected Color fillColor;
    protected BasicStroke stroke;
    protected boolean nonScalable;
    protected boolean overlay;
    protected boolean wideLine;
    protected boolean hide;

    public Roi(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, 0);
    }

    public Roi(int n, int n2, int n3, int n4, int n5) {
        this.setImage(null);
        if (n3 < 1) {
            n3 = 1;
        }
        if (n4 < 1) {
            n4 = 1;
        }
        if (n3 > this.xMax) {
            n3 = this.xMax;
        }
        if (n4 > this.yMax) {
            n4 = this.yMax;
        }
        this.arcSize = n5;
        this.x = n;
        this.y = n2;
        this.startX = n;
        this.startY = n2;
        this.oldX = n;
        this.oldY = n2;
        this.oldWidth = 0;
        this.oldHeight = 0;
        this.width = n3;
        this.height = n4;
        this.oldWidth = n3;
        this.oldHeight = n4;
        this.clipX = n;
        this.clipY = n2;
        this.clipWidth = n3;
        this.clipHeight = n4;
        this.state = 3;
        this.type = 0;
        if (this.ic != null) {
            Graphics graphics = this.ic.getGraphics();
            this.draw(graphics);
            graphics.dispose();
        }
        this.fillColor = defaultFillColor;
    }

    public Roi(Rectangle rectangle) {
        this(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Roi(int n, int n2, ImagePlus imagePlus) {
        this(n, n2, imagePlus, 0);
    }

    public Roi(int n, int n2, ImagePlus imagePlus, int n3) {
        this.setImage(imagePlus);
        int n4 = n;
        int n5 = n2;
        if (this.ic != null) {
            n4 = this.ic.offScreenX(n);
            n5 = this.ic.offScreenY(n2);
        }
        this.setLocation(n4, n5);
        this.arcSize = n3;
        this.width = 0;
        this.height = 0;
        this.state = 0;
        this.type = 0;
        if (this.isDrawingTool()) {
            this.setStrokeColor(Toolbar.getForegroundColor());
            if (!(this instanceof TextRoi)) {
                double d;
                double d2 = d = imagePlus != null && imagePlus.getCanvas() != null ? imagePlus.getCanvas().getMagnification() : 1.0;
                if (d > 1.0) {
                    d = 1.0;
                }
                if (Line.getWidth() == 1 && !Line.widthChanged) {
                    Line.setWidth((int)(2.0 / d));
                }
                if (d < 1.0 && (double)Line.getWidth() * d < 1.0) {
                    Line.setWidth((int)(1.0 / d));
                }
                this.setStrokeWidth(Line.getWidth());
            }
        }
        this.fillColor = defaultFillColor;
    }

    public Roi(int n, int n2, int n3, int n4, ImagePlus imagePlus) {
        this(n, n2, n3, n4);
        this.setImage(imagePlus);
    }

    public void setLocation(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.startX = n;
        this.startY = n2;
        this.oldX = n;
        this.oldY = n2;
        this.oldWidth = 0;
        this.oldHeight = 0;
    }

    public void setImage(ImagePlus imagePlus) {
        this.imp = imagePlus;
        this.cachedMask = null;
        if (imagePlus == null) {
            this.ic = null;
            this.clipboard = null;
            this.xMax = 99999;
            this.yMax = 99999;
        } else {
            this.ic = imagePlus.getCanvas();
            this.xMax = imagePlus.getWidth();
            this.yMax = imagePlus.getHeight();
        }
    }

    ImagePlus getImage() {
        return this.imp;
    }

    public int getImageID() {
        return this.imp != null ? this.imp.getID() : this.imageID;
    }

    public int getType() {
        return this.type;
    }

    public int getState() {
        return this.state;
    }

    public double getLength() {
        double d = 1.0;
        double d2 = 1.0;
        if (this.imp != null) {
            Calibration calibration = this.imp.getCalibration();
            d = calibration.pixelWidth;
            d2 = calibration.pixelHeight;
        }
        return 2.0 * (double)this.width * d + 2.0 * (double)this.height * d2;
    }

    public double getFeretsDiameter() {
        double[] dArray = this.getFeretValues();
        return dArray != null ? dArray[0] : 0.0;
    }

    public double[] getFeretValues() {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        Object object;
        double d9 = Double.MAX_VALUE;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        int n = 0;
        int n2 = 0;
        double d14 = 1.0;
        double d15 = 1.0;
        if (this.imp != null) {
            object = this.imp.getCalibration();
            d14 = ((Calibration)object).pixelWidth;
            d15 = ((Calibration)object).pixelHeight;
        }
        if ((object = this.getConvexHull()) == null && (object = this.getPolygon()) == null) {
            return null;
        }
        double d16 = d14 * d14;
        double d17 = d15 * d15;
        for (int i = 0; i < ((Polygon)object).npoints; ++i) {
            for (int j = i; j < ((Polygon)object).npoints; ++j) {
                d8 = ((Polygon)object).xpoints[i] - ((Polygon)object).xpoints[j];
                d7 = ((Polygon)object).ypoints[i] - ((Polygon)object).ypoints[j];
                double d18 = Math.sqrt(d8 * d8 * d16 + d7 * d7 * d17);
                if (!(d18 > d10)) continue;
                d10 = d18;
                n = i;
                n2 = j;
            }
        }
        Rectangle rectangle = this.getBounds();
        double d19 = (double)rectangle.x + (double)rectangle.width / 2.0;
        double d20 = (double)rectangle.y + (double)rectangle.height / 2.0;
        int n3 = ((Polygon)object).npoints;
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        for (int i = 0; i < n3; ++i) {
            dArray[i] = ((double)((Polygon)object).xpoints[i] - d19) * d14;
            dArray2[i] = ((double)((Polygon)object).ypoints[i] - d20) * d15;
        }
        for (d6 = 0.0; d6 <= 90.0; d6 += 0.5) {
            d5 = Math.cos(d6 * Math.PI / 180.0);
            d4 = Math.sin(d6 * Math.PI / 180.0);
            d3 = Double.MAX_VALUE;
            d2 = Double.MAX_VALUE;
            d = -1.7976931348623157E308;
            double d21 = -1.7976931348623157E308;
            for (int i = 0; i < n3; ++i) {
                double d22 = d5 * dArray[i] - d4 * dArray2[i];
                double d23 = d4 * dArray[i] + d5 * dArray2[i];
                if (d22 < d3) {
                    d3 = d22;
                }
                if (d22 > d) {
                    d = d22;
                }
                if (d23 < d2) {
                    d2 = d23;
                }
                if (!(d23 > d21)) continue;
                d21 = d23;
            }
            double d24 = d - d3;
            double d25 = d21 - d2;
            double d26 = Math.min(d24, d25);
            d9 = Math.min(d9, d26);
        }
        d6 = ((Polygon)object).xpoints[n];
        d5 = ((Polygon)object).ypoints[n];
        d4 = ((Polygon)object).xpoints[n2];
        d3 = ((Polygon)object).ypoints[n2];
        if (d6 > d4) {
            d2 = d6;
            d = d5;
            d6 = d4;
            d5 = d3;
            d4 = d2;
            d3 = d;
        }
        d12 = d6 * d14;
        d13 = d5 * d15;
        d7 = d5 - d3;
        d8 = d4 - d6;
        d11 = 57.29577951308232 * Math.atan2(d7 * d15, d8 * d14);
        if (d11 < 0.0) {
            d11 = 180.0 + d11;
        }
        double[] dArray3 = new double[]{d10, d11, d9, d12, d13};
        return dArray3;
    }

    public Polygon getConvexHull() {
        return this.getPolygon();
    }

    double getFeretBreadth(Shape shape, double d, double d2, double d3, double d4, double d5) {
        double d6 = d2 + (d4 - d2) / 2.0;
        double d7 = d3 + (d5 - d3) / 2.0;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(d * Math.PI / 180.0, d6, d7);
        Shape shape2 = affineTransform.createTransformedShape(shape);
        Rectangle2D rectangle2D = shape2.getBounds2D();
        return Math.min(rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Rectangle getBoundingRect() {
        return this.getBounds();
    }

    public Polygon getPolygon() {
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        nArray[0] = this.x;
        nArray2[0] = this.y;
        nArray[1] = this.x + this.width;
        nArray2[1] = this.y;
        nArray[2] = this.x + this.width;
        nArray2[2] = this.y + this.height;
        nArray[3] = this.x;
        nArray2[3] = this.y + this.height;
        return new Polygon(nArray, nArray2, 4);
    }

    public FloatPolygon getFloatPolygon() {
        return null;
    }

    public synchronized Object clone() {
        try {
            Roi roi = (Roi)super.clone();
            roi.setImage(null);
            roi.setStroke(this.getStroke());
            roi.setFillColor(this.getFillColor());
            roi.imageID = this.getImageID();
            return roi;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected void grow(int n, int n2) {
        if (this.clipboard != null) {
            return;
        }
        int n3 = this.ic.offScreenX(n);
        int n4 = this.ic.offScreenY(n2);
        if (this.type == 0) {
            if (n3 < 0) {
                n3 = 0;
            }
            if (n4 < 0) {
                n4 = 0;
            }
        }
        if (this.constrain) {
            if (!this.center) {
                this.growConstrained(n3, n4);
                return;
            }
            int n5 = n3 - this.x;
            int n6 = n4 - this.y;
            int n7 = n5 < n6 ? n5 : n6;
            n3 = this.x + n7;
            n4 = this.y + n7;
        }
        if (this.center) {
            this.width = Math.abs(n3 - this.startX) * 2;
            this.height = Math.abs(n4 - this.startY) * 2;
            this.x = this.startX - this.width / 2;
            this.y = this.startY - this.height / 2;
        } else {
            this.width = Math.abs(n3 - this.startX);
            this.height = Math.abs(n4 - this.startY);
            this.x = n3 >= this.startX ? this.startX : this.startX - this.width;
            int n8 = this.y = n4 >= this.startY ? this.startY : this.startY - this.height;
            if (this.type == 0) {
                if (this.x + this.width > this.xMax) {
                    this.width = this.xMax - this.x;
                }
                if (this.y + this.height > this.yMax) {
                    this.height = this.yMax - this.y;
                }
            }
        }
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    private void growConstrained(int n, int n2) {
        int n3 = n - this.startX;
        int n4 = n2 - this.startY;
        this.width = this.height = (int)Math.round(Math.sqrt(n3 * n3 + n4 * n4));
        if (this.type == 0) {
            this.x = n >= this.startX ? this.startX : this.startX - this.width;
            int n5 = this.y = n2 >= this.startY ? this.startY : this.startY - this.height;
            if (this.x < 0) {
                this.x = 0;
            }
            if (this.y < 0) {
                this.y = 0;
            }
            if (this.x + this.width > this.xMax) {
                this.width = this.xMax - this.x;
            }
            if (this.y + this.height > this.yMax) {
                this.height = this.yMax - this.y;
            }
        } else {
            this.x = this.startX + n3 / 2 - this.width / 2;
            this.y = this.startY + n4 / 2 - this.height / 2;
        }
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    protected void moveHandle(int n, int n2) {
        double d;
        if (this.clipboard != null) {
            return;
        }
        int n3 = this.ic.offScreenX(n);
        int n4 = this.ic.offScreenY(n2);
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n3 > this.xMax) {
            n3 = this.xMax;
        }
        if (n4 > this.yMax) {
            n4 = this.yMax;
        }
        int n5 = this.x;
        int n6 = this.y;
        int n7 = n5 + this.width;
        int n8 = this.y + this.height;
        int n9 = this.x + this.width / 2;
        int n10 = this.y + this.height / 2;
        if (this.width > 7 && this.height > 7) {
            this.asp_bk = d = (double)this.width / (double)this.height;
        } else {
            d = this.asp_bk;
        }
        switch (this.activeHandle) {
            case 0: {
                this.x = n3;
                this.y = n4;
                break;
            }
            case 1: {
                this.y = n4;
                break;
            }
            case 2: {
                n7 = n3;
                this.y = n4;
                break;
            }
            case 3: {
                n7 = n3;
                break;
            }
            case 4: {
                n7 = n3;
                n8 = n4;
                break;
            }
            case 5: {
                n8 = n4;
                break;
            }
            case 6: {
                this.x = n3;
                n8 = n4;
                break;
            }
            case 7: {
                this.x = n3;
            }
        }
        if (this.x < n7) {
            this.width = n7 - this.x;
        } else {
            this.width = 1;
            this.x = n7;
        }
        if (this.y < n8) {
            this.height = n8 - this.y;
        } else {
            this.height = 1;
            this.y = n8;
        }
        if (this.center) {
            switch (this.activeHandle) {
                case 0: {
                    this.width = (n9 - this.x) * 2;
                    this.height = (n10 - this.y) * 2;
                    break;
                }
                case 1: {
                    this.height = (n10 - this.y) * 2;
                    break;
                }
                case 2: {
                    this.width = (n7 - n9) * 2;
                    this.x = n7 - this.width;
                    this.height = (n10 - this.y) * 2;
                    break;
                }
                case 3: {
                    this.width = (n7 - n9) * 2;
                    this.x = n7 - this.width;
                    break;
                }
                case 4: {
                    this.width = (n7 - n9) * 2;
                    this.x = n7 - this.width;
                    this.height = (n8 - n10) * 2;
                    this.y = n8 - this.height;
                    break;
                }
                case 5: {
                    this.height = (n8 - n10) * 2;
                    this.y = n8 - this.height;
                    break;
                }
                case 6: {
                    this.width = (n9 - this.x) * 2;
                    this.height = (n8 - n10) * 2;
                    this.y = n8 - this.height;
                    break;
                }
                case 7: {
                    this.width = (n9 - this.x) * 2;
                }
            }
            if (this.x >= n7) {
                this.width = 1;
                this.x = n7 = n9;
            }
            if (this.y >= n8) {
                this.height = 1;
                this.y = n8 = n10;
            }
        }
        if (this.constrain) {
            if (this.activeHandle == 1 || this.activeHandle == 5) {
                this.width = this.height;
            } else {
                this.height = this.width;
            }
            if (this.x >= n7) {
                this.width = 1;
                this.x = n7 = n9;
            }
            if (this.y >= n8) {
                this.height = 1;
                this.y = n8 = n10;
            }
            switch (this.activeHandle) {
                case 0: {
                    this.x = n7 - this.width;
                    this.y = n8 - this.height;
                    break;
                }
                case 1: {
                    this.x = n9 - this.width / 2;
                    this.y = n8 - this.height;
                    break;
                }
                case 2: {
                    this.y = n8 - this.height;
                    break;
                }
                case 3: {
                    this.y = n10 - this.height / 2;
                    break;
                }
                case 5: {
                    this.x = n9 - this.width / 2;
                    break;
                }
                case 6: {
                    this.x = n7 - this.width;
                    break;
                }
                case 7: {
                    this.y = n10 - this.height / 2;
                    this.x = n7 - this.width;
                }
            }
            if (this.center) {
                this.x = n9 - this.width / 2;
                this.y = n10 - this.height / 2;
            }
        }
        if (this.aspect && !this.constrain) {
            if (this.activeHandle == 1 || this.activeHandle == 5) {
                this.width = (int)Math.rint((double)this.height * d);
            } else {
                this.height = (int)Math.rint((double)this.width / d);
            }
            switch (this.activeHandle) {
                case 0: {
                    this.x = n7 - this.width;
                    this.y = n8 - this.height;
                    break;
                }
                case 1: {
                    this.x = n9 - this.width / 2;
                    this.y = n8 - this.height;
                    break;
                }
                case 2: {
                    this.y = n8 - this.height;
                    break;
                }
                case 3: {
                    this.y = n10 - this.height / 2;
                    break;
                }
                case 5: {
                    this.x = n9 - this.width / 2;
                    break;
                }
                case 6: {
                    this.x = n7 - this.width;
                    break;
                }
                case 7: {
                    this.y = n10 - this.height / 2;
                    this.x = n7 - this.width;
                }
            }
            if (this.center) {
                this.x = n9 - this.width / 2;
                this.y = n10 - this.height / 2;
            }
            if (this.width < 8) {
                if (this.width < 1) {
                    this.width = 1;
                }
                this.height = (int)Math.rint((double)this.width / this.asp_bk);
            }
            if (this.height < 8) {
                if (this.height < 1) {
                    this.height = 1;
                }
                this.width = (int)Math.rint((double)this.height * this.asp_bk);
            }
        }
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    void move(int n, int n2) {
        int n3 = this.ic.offScreenX(n);
        int n4 = this.ic.offScreenY(n2);
        this.x += n3 - this.startX;
        this.y += n4 - this.startY;
        if (this.clipboard == null && this.type == 0) {
            if (this.x < 0) {
                this.x = 0;
            }
            if (this.y < 0) {
                this.y = 0;
            }
            if (this.x + this.width > this.xMax) {
                this.x = this.xMax - this.width;
            }
            if (this.y + this.height > this.yMax) {
                this.y = this.yMax - this.height;
            }
        }
        this.startX = n3;
        this.startY = n4;
        this.updateClipRect();
        if (lineWidth > 1 && this.isLine()) {
            this.imp.draw();
        } else {
            this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        }
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    public void nudge(int n) {
        switch (n) {
            case 38: {
                --this.y;
                if (this.y >= 0 || this.type == 0 && this.clipboard != null) break;
                this.y = 0;
                break;
            }
            case 40: {
                ++this.y;
                if (this.y + this.height < this.yMax || this.type == 0 && this.clipboard != null) break;
                this.y = this.yMax - this.height;
                break;
            }
            case 37: {
                --this.x;
                if (this.x >= 0 || this.type == 0 && this.clipboard != null) break;
                this.x = 0;
                break;
            }
            case 39: {
                ++this.x;
                if (this.x + this.width < this.xMax || this.type == 0 && this.clipboard != null) break;
                this.x = this.xMax - this.width;
            }
        }
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
        this.showStatus();
    }

    public void nudgeCorner(int n) {
        if (this.type > 1 || this.clipboard != null) {
            return;
        }
        switch (n) {
            case 38: {
                --this.height;
                if (this.height >= 1) break;
                this.height = 1;
                break;
            }
            case 40: {
                ++this.height;
                if (this.y + this.height <= this.yMax) break;
                this.height = this.yMax - this.y;
                break;
            }
            case 37: {
                --this.width;
                if (this.width >= 1) break;
                this.width = 1;
                break;
            }
            case 39: {
                ++this.width;
                if (this.x + this.width <= this.xMax) break;
                this.width = this.xMax - this.x;
            }
        }
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
        this.cachedMask = null;
        this.showStatus();
    }

    protected void updateClipRect() {
        double d;
        this.clipX = this.x <= this.oldX ? this.x : this.oldX;
        this.clipY = this.y <= this.oldY ? this.y : this.oldY;
        this.clipWidth = (this.x + this.width >= this.oldX + this.oldWidth ? this.x + this.width : this.oldX + this.oldWidth) - this.clipX + 1;
        this.clipHeight = (this.y + this.height >= this.oldY + this.oldHeight ? this.y + this.height : this.oldY + this.oldHeight) - this.clipY + 1;
        int n = 3;
        if (this.ic != null && (d = this.ic.getMagnification()) < 1.0) {
            n = (int)(4.0 / d);
        }
        n += this.clipRectMargin();
        n = (int)((float)n + this.getStrokeWidth() * 2.0f);
        this.clipX -= n;
        this.clipY -= n;
        this.clipWidth += n * 2;
        this.clipHeight += n * 2;
    }

    protected int clipRectMargin() {
        return 0;
    }

    protected void handleMouseDrag(int n, int n2, int n3) {
        if (this.ic == null) {
            return;
        }
        this.constrain = (n3 & 1) != 0;
        this.center = (n3 & 2) != 0 || IJ.isMacintosh() && (n3 & 4) != 0;
        this.aspect = (n3 & 8) != 0;
        switch (this.state) {
            case 0: {
                this.grow(n, n2);
                break;
            }
            case 1: {
                this.move(n, n2);
                break;
            }
            case 4: {
                this.moveHandle(n, n2);
                break;
            }
        }
    }

    int getHandleSize() {
        double d = this.ic != null ? this.ic.getMagnification() : 1.0;
        double d2 = 5.0 / d;
        return (int)(d2 * d);
    }

    public void draw(Graphics graphics) {
        int n;
        Color color;
        if (this.ic == null) {
            return;
        }
        Color color2 = color = this.strokeColor != null ? this.strokeColor : ROIColor;
        if (this.fillColor != null) {
            color = this.fillColor;
        }
        if (Interpreter.isBatchMode() && this.ic.getDisplayList() != null && this.strokeColor == null && this.fillColor == null) {
            return;
        }
        graphics.setColor(color);
        this.mag = this.ic.getMagnification();
        int n2 = (int)((double)this.width * this.mag);
        int n3 = (int)((double)this.height * this.mag);
        int n4 = this.ic.screenX(this.x);
        int n5 = this.ic.screenY(this.y);
        int n6 = n4 + n2 / 2;
        int n7 = n5 + n3 / 2;
        int n8 = n4 + n2;
        int n9 = n5 + n3;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.stroke != null) {
            graphics2D.setStroke(this.getScaledStroke());
        }
        if (this.arcSize > 0) {
            n = (int)Math.round((double)this.arcSize * this.mag);
            if (this.fillColor != null) {
                graphics.fillRoundRect(n4, n5, n2, n3, n, n);
            } else {
                graphics.drawRoundRect(n4, n5, n2, n3, n, n);
            }
        } else if (this.fillColor != null) {
            graphics.fillRect(n4, n5, n2, n3);
        } else {
            graphics.drawRect(n4, n5, n2, n3);
        }
        if (this.state != 0 && this.clipboard == null && !this.overlay) {
            n = 2;
            this.drawHandle(graphics, n4 - n, n5 - n);
            this.drawHandle(graphics, n6 - n, n5 - n);
            this.drawHandle(graphics, n8 - n, n5 - n);
            this.drawHandle(graphics, n8 - n, n7 - n);
            this.drawHandle(graphics, n8 - n, n9 - n);
            this.drawHandle(graphics, n6 - n, n9 - n);
            this.drawHandle(graphics, n4 - n, n9 - n);
            this.drawHandle(graphics, n4 - n, n7 - n);
        }
        this.drawPreviousRoi(graphics);
        if (this.state != 3) {
            this.showStatus();
        }
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
    }

    public void drawOverlay(Graphics graphics) {
        this.overlay = true;
        this.draw(graphics);
        this.overlay = false;
    }

    void drawPreviousRoi(Graphics graphics) {
        if (previousRoi != null && previousRoi != this && Roi.previousRoi.modState != 0) {
            if (this.type != 10 && previousRoi.getType() == 10 && Roi.previousRoi.modState != 2) {
                return;
            }
            previousRoi.setImage(this.imp);
            previousRoi.draw(graphics);
        }
    }

    void drawHandle(Graphics graphics, int n, int n2) {
        double d = (double)(this.width * this.height) * this.mag;
        if (this.type == 5) {
            d = Math.sqrt(this.width * this.width + this.height * this.height);
            d *= d * this.mag;
        }
        if (d > 6000.0) {
            graphics.setColor(Color.black);
            graphics.fillRect(n, n2, 5, 5);
            graphics.setColor(this.handleColor);
            graphics.fillRect(n + 1, n2 + 1, 3, 3);
        } else if (d > 1500.0) {
            graphics.setColor(Color.black);
            graphics.fillRect(n + 1, n2 + 1, 4, 4);
            graphics.setColor(this.handleColor);
            graphics.fillRect(n + 2, n2 + 2, 2, 2);
        } else {
            graphics.setColor(Color.black);
            graphics.fillRect(n + 1, n2 + 1, 3, 3);
            graphics.setColor(this.handleColor);
            graphics.fillRect(n + 2, n2 + 2, 1, 1);
        }
    }

    public void drawPixels() {
        if (this.imp != null) {
            this.drawPixels(this.imp.getProcessor());
        }
    }

    public void drawPixels(ImageProcessor imageProcessor) {
        this.endPaste();
        if (this.arcSize > 0) {
            new ShapeRoi(new RoundRectangle2D.Float(this.x, this.y, this.width, this.height, this.arcSize, this.arcSize)).drawPixels(imageProcessor);
        } else {
            int n = imageProcessor.getLineWidth();
            if (this.getStrokeWidth() > 1.0f) {
                imageProcessor.setLineWidth(Math.round(this.getStrokeWidth()));
            }
            if (imageProcessor.getLineWidth() == 1) {
                imageProcessor.drawRect(this.x, this.y, this.width + 1, this.height + 1);
            } else {
                imageProcessor.drawRect(this.x, this.y, this.width, this.height);
            }
            imageProcessor.setLineWidth(n);
        }
        if (Line.getWidth() > 1 || this.getStrokeWidth() > 1.0f) {
            this.updateFullWindow = true;
        }
    }

    public boolean contains(int n, int n2) {
        Rectangle rectangle = new Rectangle(this.x, this.y, this.width, this.height);
        boolean bl = rectangle.contains(n, n2);
        if (this.arcSize == 0 || !bl) {
            return bl;
        }
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(this.x, this.y, this.width, this.height, this.arcSize, this.arcSize);
        return float_.contains(n, n2);
    }

    public int isHandle(int n, int n2) {
        if (this.clipboard != null || this.ic == null) {
            return -1;
        }
        double d = this.ic.getMagnification();
        int n3 = 8;
        int n4 = n3 / 2;
        int n5 = this.ic.screenX(this.x) - n4;
        int n6 = this.ic.screenY(this.y) - n4;
        int n7 = this.ic.screenX(this.x + this.width) - n4;
        int n8 = this.ic.screenY(this.y + this.height) - n4;
        int n9 = n5 + (n7 - n5) / 2;
        int n10 = n6 + (n8 - n6) / 2;
        if (n >= n5 && n <= n5 + n3 && n2 >= n6 && n2 <= n6 + n3) {
            return 0;
        }
        if (n >= n9 && n <= n9 + n3 && n2 >= n6 && n2 <= n6 + n3) {
            return 1;
        }
        if (n >= n7 && n <= n7 + n3 && n2 >= n6 && n2 <= n6 + n3) {
            return 2;
        }
        if (n >= n7 && n <= n7 + n3 && n2 >= n10 && n2 <= n10 + n3) {
            return 3;
        }
        if (n >= n7 && n <= n7 + n3 && n2 >= n8 && n2 <= n8 + n3) {
            return 4;
        }
        if (n >= n9 && n <= n9 + n3 && n2 >= n8 && n2 <= n8 + n3) {
            return 5;
        }
        if (n >= n5 && n <= n5 + n3 && n2 >= n8 && n2 <= n8 + n3) {
            return 6;
        }
        if (n >= n5 && n <= n5 + n3 && n2 >= n10 && n2 <= n10 + n3) {
            return 7;
        }
        return -1;
    }

    protected void mouseDownInHandle(int n, int n2, int n3) {
        this.state = 4;
        this.activeHandle = n;
    }

    protected void handleMouseDown(int n, int n2) {
        if (this.state == 3 && this.ic != null) {
            this.state = 1;
            this.startX = this.ic.offScreenX(n);
            this.startY = this.ic.offScreenY(n2);
            this.showStatus();
        }
    }

    protected void handleMouseUp(int n, int n2) {
        this.state = 3;
        if (this.imp == null) {
            return;
        }
        this.imp.draw(this.clipX - 5, this.clipY - 5, this.clipWidth + 10, this.clipHeight + 10);
        if (Recorder.record) {
            if (this.type == 5) {
                Line line = (Line)this.imp.getRoi();
                Recorder.record("makeLine", line.x1, line.y1, line.x2, line.y2);
            } else if (this.type == 1) {
                Recorder.record("makeOval", this.x, this.y, this.width, this.height);
            } else if (!(this instanceof TextRoi)) {
                if (this.arcSize == 0) {
                    Recorder.record("makeRectangle", this.x, this.y, this.width, this.height);
                } else if (Recorder.scriptMode()) {
                    Recorder.recordCall("imp.setRoi(new Roi(" + this.x + ", " + this.y + ", " + this.width + ", " + this.height + ", " + this.arcSize + "));");
                } else {
                    Recorder.record("makeRectangle", this.x, this.y, this.width, this.height, this.arcSize);
                }
            }
        }
        if (Toolbar.getToolId() == 1 && Toolbar.getBrushSize() > 0) {
            int n3;
            int n4 = n3 = this.ic != null ? this.ic.getModifiers() : 16;
            if ((n3 & 0x10) == 0) {
                this.imp.draw();
                return;
            }
        }
        this.modifyRoi();
    }

    void modifyRoi() {
        if (previousRoi == null || Roi.previousRoi.modState == 0 || this.imp == null) {
            return;
        }
        if (this.type == 10 || previousRoi.getType() == 10) {
            if (this.type == 10 && previousRoi.getType() == 10) {
                this.addPoint();
            } else if (this.isArea() && previousRoi.getType() == 10 && Roi.previousRoi.modState == 2) {
                this.subtractPoints();
            }
            return;
        }
        Roi roi = (Roi)previousRoi.clone();
        roi.modState = 0;
        ShapeRoi shapeRoi = null;
        ShapeRoi shapeRoi2 = null;
        shapeRoi = previousRoi instanceof ShapeRoi ? (ShapeRoi)previousRoi : new ShapeRoi(previousRoi);
        shapeRoi2 = this instanceof ShapeRoi ? (ShapeRoi)this : new ShapeRoi(this);
        if (Roi.previousRoi.modState == 1) {
            shapeRoi.or(shapeRoi2);
        } else {
            shapeRoi.not(shapeRoi2);
        }
        Roi.previousRoi.modState = 0;
        Roi[] roiArray = shapeRoi.getRois();
        if (roiArray.length == 0) {
            return;
        }
        int n = roiArray[0].getType();
        Roi roi2 = null;
        roi2 = roiArray.length == 1 && (n == 2 || n == 3) ? roiArray[0] : shapeRoi;
        if (roi2 != null) {
            roi2.copyAttributes(previousRoi);
        }
        this.imp.setRoi(roi2);
        previousRoi = roi;
    }

    void addPoint() {
        if (this.type != 10 || previousRoi.getType() != 10) {
            this.modState = 0;
            this.imp.draw();
            return;
        }
        Roi.previousRoi.modState = 0;
        PointRoi pointRoi = (PointRoi)previousRoi;
        Rectangle rectangle = this.getBounds();
        this.imp.setRoi(pointRoi.addPoint(rectangle.x, rectangle.y));
    }

    void subtractPoints() {
        Roi.previousRoi.modState = 0;
        PointRoi pointRoi = (PointRoi)previousRoi;
        PointRoi pointRoi2 = pointRoi.subtractPoints(this);
        if (pointRoi2 != null) {
            this.imp.setRoi(pointRoi.subtractPoints(this));
        } else {
            this.imp.killRoi();
        }
    }

    public void update(boolean bl, boolean bl2) {
        if (previousRoi == null) {
            return;
        }
        if (bl) {
            Roi.previousRoi.modState = 1;
            this.modifyRoi();
        } else if (bl2) {
            Roi.previousRoi.modState = 2;
            this.modifyRoi();
        } else {
            Roi.previousRoi.modState = 0;
        }
    }

    protected void showStatus() {
        String string;
        Object object;
        if (this.state != 0 && (this.type == 0 || this.type == 10) && this.width <= 25 && this.height <= 25) {
            object = this.imp.getProcessor();
            double d = ((ImageProcessor)object).getPixelValue(this.x, this.y);
            int n = this.imp.getType() == 0 || this.imp.getType() == 1 ? 0 : 2;
            string = ", value=" + IJ.d2s(d, n);
        } else {
            string = "";
        }
        object = this.imp.getCalibration();
        String string2 = ((Calibration)object).scaled() && !IJ.altKeyDown() ? ", w=" + IJ.d2s((double)this.width * ((Calibration)object).pixelWidth) + ", h=" + IJ.d2s((double)this.height * ((Calibration)object).pixelHeight) : ", w=" + this.width + ", h=" + this.height;
        string2 = string2 + ", ar=" + IJ.d2s((double)this.width / (double)this.height, 2);
        IJ.showStatus(this.imp.getLocationAsString(this.x, this.y) + string2 + string);
    }

    public ImageProcessor getMask() {
        if (this.arcSize > 0) {
            return new ShapeRoi(new RoundRectangle2D.Float(this.x, this.y, this.width, this.height, this.arcSize, this.arcSize)).getMask();
        }
        return null;
    }

    public void startPaste(ImagePlus imagePlus) {
        IJ.showStatus("Pasting...");
        this.clipboard = imagePlus;
        this.imp.getProcessor().snapshot();
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
    }

    void updatePaste() {
        if (this.clipboard != null) {
            this.imp.getMask();
            ImageProcessor imageProcessor = this.imp.getProcessor();
            imageProcessor.reset();
            imageProcessor.copyBits(this.clipboard.getProcessor(), this.x, this.y, pasteMode);
            if (this.type != 0) {
                imageProcessor.reset(imageProcessor.getMask());
            }
            this.ic.setImageUpdated();
        }
    }

    public void endPaste() {
        this.clipboard = null;
    }

    public void abortPaste() {
        this.clipboard = null;
        this.imp.getProcessor().reset();
        this.imp.updateAndDraw();
    }

    public double getAngle(int n, int n2, int n3, int n4) {
        double d = n3 - n;
        double d2 = n2 - n4;
        if (this.imp != null && !IJ.altKeyDown()) {
            Calibration calibration = this.imp.getCalibration();
            d *= calibration.pixelWidth;
            d2 *= calibration.pixelHeight;
        }
        return 57.29577951308232 * Math.atan2(d2, d);
    }

    public static void setColor(Color color) {
        ROIColor = color;
    }

    public static Color getColor() {
        return ROIColor;
    }

    public void setStrokeColor(Color color) {
        this.strokeColor = color;
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public static void setDefaultFillColor(Color color) {
        defaultFillColor = color;
    }

    public static Color getDefaultFillColor() {
        return defaultFillColor;
    }

    public void copyAttributes(Roi roi) {
        this.strokeColor = roi.strokeColor;
        this.fillColor = roi.fillColor;
        this.stroke = roi.stroke;
    }

    public void setInstanceColor(Color color) {
        this.strokeColor = color;
    }

    public void setLineWidth(int n) {
        this.setStrokeWidth(n);
    }

    public void updateWideLine(float f) {
        if (this.isLine()) {
            this.wideLine = true;
            this.setStrokeWidth(f);
            if (this.getStrokeColor() == null) {
                Color color = Roi.getColor();
                this.setStrokeColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 77));
            }
        }
    }

    public void setNonScalable(boolean bl) {
        this.nonScalable = bl;
    }

    public void setStrokeWidth(float f) {
        this.stroke = this.wideLine ? new BasicStroke(f, 0, 2) : new BasicStroke(f);
        if (f > 1.0f) {
            this.fillColor = null;
        }
    }

    public float getStrokeWidth() {
        return this.stroke != null ? this.stroke.getLineWidth() : 1.0f;
    }

    public void setStroke(BasicStroke basicStroke) {
        this.stroke = basicStroke;
    }

    public BasicStroke getStroke() {
        return this.stroke;
    }

    protected BasicStroke getScaledStroke() {
        if (this.ic == null) {
            return this.stroke;
        }
        float f = this.stroke.getLineWidth();
        double d = this.ic.getMagnification();
        if (f > 1.0f && d != 1.0) {
            return new BasicStroke((float)((double)f * d), 0, 2);
        }
        return this.stroke;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public static void setPasteMode(int n) {
        if (n == pasteMode) {
            return;
        }
        pasteMode = n;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus != null) {
            imagePlus.updateAndDraw();
        }
    }

    public void setRoundRectArcSize(int n) {
        ImagePlus imagePlus;
        this.arcSize = n;
        if (this.arcSize < 0) {
            this.arcSize = 0;
        }
        if ((imagePlus = WindowManager.getCurrentImage()) != null && this == imagePlus.getRoi()) {
            imagePlus.updateAndDraw();
        }
    }

    public int getRoundRectArcSize() {
        return this.arcSize;
    }

    public int getPasteMode() {
        if (this.clipboard == null) {
            return -1;
        }
        return pasteMode;
    }

    public static int getCurrentPasteMode() {
        return pasteMode;
    }

    public boolean isArea() {
        return this.type >= 0 && this.type <= 4 || this.type == 9;
    }

    public boolean isLine() {
        return this.type >= 5 && this.type <= 7;
    }

    public boolean isDrawingTool() {
        return this.arcSize > 0;
    }

    public String getTypeAsString() {
        String string = "";
        switch (this.type) {
            case 2: {
                string = "Polygon";
                break;
            }
            case 3: {
                string = "Freehand";
                break;
            }
            case 4: {
                string = "Traced";
                break;
            }
            case 6: {
                string = "Polyline";
                break;
            }
            case 7: {
                string = "Freeline";
                break;
            }
            case 8: {
                string = "Angle";
                break;
            }
            case 5: {
                string = "Straight Line";
                break;
            }
            case 1: {
                string = "Oval";
                break;
            }
            case 9: {
                string = "Composite";
                break;
            }
            case 10: {
                string = "Point";
                break;
            }
            default: {
                string = "Rectangle";
            }
        }
        return string;
    }

    public boolean isVisible() {
        return this.ic != null;
    }

    public boolean equals(Object object) {
        if (object instanceof Roi) {
            Roi roi = (Roi)object;
            if (this.type != roi.getType()) {
                return false;
            }
            if (!this.getBounds().equals(roi.getBounds())) {
                return false;
            }
            return this.getLength() == roi.getLength();
        }
        return false;
    }

    public String toString() {
        return "Roi[" + this.getTypeAsString() + ", x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + "]";
    }

    public void temporarilyHide() {
        this.hide = true;
    }

    static {
        onePixelWide = new BasicStroke(1.0f);
        ROIColor = Prefs.getColor("roicolor", Color.yellow);
        pasteMode = 0;
        lineWidth = 1;
    }
}

