/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.io.FileSaver;
import ij.io.SaveDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.process.LUT;
import java.util.Locale;
import java.util.Properties;

public class StackWriter
implements PlugIn {
    private static String[] choices = new String[]{"BMP", "FITS", "GIF", "JPEG", "PGM", "PNG", "Raw", "Text", "TIFF", "ZIP"};
    private static String fileType = "TIFF";
    private static int ndigits = 4;
    private static boolean useLabels;
    private static boolean firstTime;
    private int startAt;
    private boolean hyperstack;
    private int[] dim;

    public void run(String string) {
        boolean bl;
        int n;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null || imagePlus != null && imagePlus.getStackSize() < 2) {
            IJ.error("Stack Writer", "This command requires a stack.");
            return;
        }
        int n2 = imagePlus.getStackSize();
        String string2 = imagePlus.getTitle();
        int n3 = string2.lastIndexOf(".");
        if (n3 >= 0) {
            string2 = string2.substring(0, n3);
        }
        this.hyperstack = imagePlus.isHyperStack();
        LUT[] lUTArray = null;
        int n4 = 0;
        int n5 = imagePlus.getNChannels();
        if (this.hyperstack) {
            this.dim = imagePlus.getDimensions();
            if (imagePlus.isComposite()) {
                lUTArray = ((CompositeImage)imagePlus).getLuts();
            }
            if (firstTime && ndigits == 4) {
                ndigits = 3;
                firstTime = false;
            }
        }
        GenericDialog genericDialog = new GenericDialog("Save Image Sequence");
        genericDialog.addChoice("Format:", choices, fileType);
        genericDialog.addStringField("Name:", string2, 12);
        if (!this.hyperstack) {
            genericDialog.addNumericField("Start At:", this.startAt, 0);
        }
        genericDialog.addNumericField("Digits (1-8):", ndigits, 0);
        if (!this.hyperstack) {
            genericDialog.addCheckbox("Use slice labels as file names", useLabels);
        }
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        fileType = genericDialog.getNextChoice();
        string2 = genericDialog.getNextString();
        if (!this.hyperstack) {
            this.startAt = (int)genericDialog.getNextNumber();
        }
        if (this.startAt < 0) {
            this.startAt = 0;
        }
        ndigits = (int)genericDialog.getNextNumber();
        useLabels = !this.hyperstack ? genericDialog.getNextBoolean() : false;
        int n6 = 0;
        if (ndigits < 1) {
            ndigits = 1;
        }
        if (ndigits > 8) {
            ndigits = 8;
        }
        if (n2 > (n = (int)Math.pow(10.0, ndigits)) && !useLabels && !this.hyperstack) {
            IJ.error("Stack Writer", "More than " + ndigits + " digits are required to generate \nunique file names for " + n2 + " images.");
            return;
        }
        String string3 = fileType.toLowerCase(Locale.US);
        if (string3.equals("gif") && !FileSaver.okForGif(imagePlus)) {
            return;
        }
        if (string3.equals("fits") && !FileSaver.okForFits(imagePlus)) {
            return;
        }
        if (string3.equals("text")) {
            string3 = "text image";
        }
        String string4 = "." + string3;
        if (string3.equals("tiff")) {
            string4 = ".tif";
        } else if (string3.equals("text image")) {
            string4 = ".txt";
        }
        String string5 = this.getDigits(n6);
        SaveDialog saveDialog = new SaveDialog("Save Image Sequence", string2 + string5 + string4, string4);
        String string6 = saveDialog.getFileName();
        if (string6 == null) {
            return;
        }
        String string7 = saveDialog.getDirectory();
        boolean bl2 = bl = imagePlus.getOverlay() != null && !imagePlus.getHideOverlay();
        if (!string3.equals("jpeg") && !string3.equals("png")) {
            bl = false;
        }
        ImageStack imageStack = imagePlus.getStack();
        ImagePlus imagePlus2 = new ImagePlus();
        imagePlus2.setTitle(imagePlus.getTitle());
        Calibration calibration = imagePlus.getCalibration();
        int n7 = imageStack.getSize();
        String string8 = null;
        imagePlus.lock();
        for (int i = 1; i <= n7; ++i) {
            IJ.showStatus("writing: " + i + "/" + n7);
            IJ.showProgress(i, n7);
            ImageProcessor imageProcessor = imageStack.getProcessor(i);
            if (bl) {
                imagePlus.setSliceWithoutUpdate(i);
                imageProcessor = imagePlus.flatten().getProcessor();
            } else if (lUTArray != null && n5 > 1 && this.hyperstack) {
                imageProcessor.setColorModel(lUTArray[n4++]);
                if (n4 >= lUTArray.length) {
                    n4 = 0;
                }
            }
            imagePlus2.setProcessor(null, imageProcessor);
            String string9 = imageStack.getSliceLabel(i);
            if (string9 != null && string9.indexOf("\n") != -1) {
                imagePlus2.setProperty("Info", string9);
            } else {
                Properties properties = imagePlus2.getProperties();
                if (properties != null) {
                    properties.remove("Info");
                }
            }
            imagePlus2.setCalibration(calibration);
            string5 = this.getDigits(n6++);
            if (useLabels) {
                string8 = imageStack.getShortSliceLabel(i);
                if (string8 != null && string8.equals("")) {
                    string8 = null;
                }
                if (string8 != null) {
                    string8 = string8.replaceAll("/", "-");
                }
            }
            String string10 = string8 == null ? string7 + string2 + string5 + string4 : string7 + string8 + string4;
            IJ.saveAs(imagePlus2, string3, string10);
        }
        imagePlus.unlock();
        if (bl) {
            imagePlus.setSlice(1);
        }
        IJ.showStatus("");
    }

    String getDigits(int n) {
        if (this.hyperstack) {
            int n2 = n % this.dim[2] + 1;
            int n3 = n / this.dim[2] % this.dim[3] + 1;
            int n4 = n / (this.dim[2] * this.dim[3]) % this.dim[4] + 1;
            String string = "";
            String string2 = "";
            String string3 = "";
            if (this.dim[2] > 1) {
                string = "00000000" + n2;
                string = "_c" + string.substring(string.length() - ndigits);
            }
            if (this.dim[3] > 1) {
                string2 = "00000000" + n3;
                string2 = "_z" + string2.substring(string2.length() - ndigits);
            }
            if (this.dim[4] > 1) {
                string3 = "00000000" + n4;
                string3 = "_t" + string3.substring(string3.length() - ndigits);
            }
            return string3 + string2 + string;
        }
        String string = "00000000" + (this.startAt + n);
        return string.substring(string.length() - ndigits);
    }

    static {
        firstTime = true;
    }
}

