% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_Rtools.R
\name{get_Rtools}
\alias{get_Rtools}
\title{Downloads Rtools}
\usage{
get_Rtools(app_dir, Rtools_version, R_version)
}
\arguments{
\item{app_dir}{Development app's directory, defaults to \code{getwd()}.}

\item{Rtools_version}{Rtools version to include. For more information, see \href{https://cran.r-project.org/bin/windows/Rtools/}{Building R for Windows}.}

\item{R_version}{R version to use. Supports inequalities similar to \code{pkgs}. Defaults to: \code{paste0(">=", R.version$major, '.', R.version$minor)}.}
}
\value{
\code{sprintf('Rtools\%s.exe', gsub("\\.", "", Rtools_version))} in \code{app_dir}.
}
\description{
Downloads Rtools in \code{app_dir}. If it has already been downloaded, \code{get_Rtools} will use that file. If the download fails it will stop.
}
\details{
If \code{\link{create_app}(include_Rtools = TRUE)}, then \code{get_Rtools}.
}
\seealso{
\code{\link{get_R}}, \code{\link{copy_installation}}, \code{\link{create_config}}, \code{\link{create_bat}}, \code{\link{directives_section}}, \code{\link{setup_section}}, \code{\link{languages_section}}, \code{\link{tasks_section}}, \code{\link{files_section}}, \code{\link{icons_section}}, \code{\link{run_section}}, and \code{\link{code_section}}.
}
\author{
Jonathan M. Hill
}
