/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.regression.IOutlierFactory;
import ec.tstoolkit.timeseries.regression.OutlierType;
import ec.tstoolkit.timeseries.regression.SeasonalOutlier;
import ec.tstoolkit.timeseries.simplets.TsDomain;

public class SeasonalOutlierFactory
implements IOutlierFactory {
    public static final int DEF_MINREPEAT = 1;
    private boolean zeroEnded;
    private int repeatCount = 1;

    @Override
    public SeasonalOutlier create(Day position) {
        SeasonalOutlier so = new SeasonalOutlier(position);
        so.zeroEnded = this.zeroEnded;
        return so;
    }

    @Override
    public TsDomain definitionDomain(TsDomain tsdomain) {
        int freq = tsdomain.getFrequency().intValue();
        if (freq <= 1) {
            return null;
        }
        return tsdomain.drop(this.repeatCount * freq, this.repeatCount * freq);
    }

    @Override
    public OutlierType getOutlierType() {
        return OutlierType.SO;
    }

    @Override
    public String getOutlierCode() {
        return "SO";
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public boolean isZeroEnded() {
        return this.zeroEnded;
    }

    public void setRepeatCount(int value) {
        this.repeatCount = value;
    }

    public void setZeroEnded(boolean value) {
        this.zeroEnded = value;
    }
}

