% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{deprecated-RJDemetra}
\alias{deprecated-RJDemetra}
\alias{x13_spec_def}
\alias{x13_def}
\alias{tramoseats_spec_def}
\alias{tramoseats_def}
\alias{regarima_spec_def_tramoseats}
\alias{regarima_def_tramoseats}
\alias{regarima_def_x13}
\alias{regarima_spec_def_x13}
\title{Deprecated functions}
\usage{
x13_spec_def(spec = c("RSA5c", "RSA0", "RSA1", "RSA2c", "RSA3", "RSA4c",
  "X11"), estimate.from = NA_character_, estimate.to = NA_character_,
  estimate.first = NA_integer_, estimate.last = NA_integer_,
  estimate.exclFirst = NA_integer_, estimate.exclLast = NA_integer_,
  estimate.tol = NA_integer_, transform.function = c(NA, "Auto",
  "None", "Log"), transform.adjust = c(NA, "None", "LeapYear",
  "LengthOfPeriod"), transform.aicdiff = NA_integer_,
  usrdef.outliersEnabled = NA, usrdef.outliersType = NA,
  usrdef.outliersDate = NA, usrdef.outliersCoef = NA,
  usrdef.varEnabled = NA, usrdef.var = NA, usrdef.varType = NA,
  usrdef.varCoef = NA, tradingdays.option = c(NA, "TradingDays",
  "WorkingDays", "UserDefined", "None"), tradingdays.autoadjust = NA,
  tradingdays.leapyear = c(NA, "LeapYear", "LengthOfPeriod", "None"),
  tradingdays.stocktd = NA_integer_, tradingdays.test = c(NA, "Remove",
  "Add", "None"), easter.enabled = NA, easter.julian = NA,
  easter.duration = NA_integer_, easter.test = c(NA, "Add", "Remove",
  "None"), outlier.enabled = NA, outlier.from = NA_character_,
  outlier.to = NA_character_, outlier.first = NA_integer_,
  outlier.last = NA_integer_, outlier.exclFirst = NA_integer_,
  outlier.exclLast = NA_integer_, outlier.ao = NA, outlier.tc = NA,
  outlier.ls = NA, outlier.so = NA, outlier.usedefcv = NA,
  outlier.cv = NA_integer_, outlier.method = c(NA, "AddOne", "AddAll"),
  outlier.tcrate = NA_integer_, automdl.enabled = NA,
  automdl.acceptdefault = NA, automdl.cancel = NA_integer_,
  automdl.ub1 = NA_integer_, automdl.ub2 = NA_integer_,
  automdl.mixed = NA, automdl.balanced = NA,
  automdl.armalimit = NA_integer_, automdl.reducecv = NA_integer_,
  automdl.ljungboxlimit = NA_integer_, automdl.ubfinal = NA_integer_,
  arima.mu = NA, arima.p = NA_integer_, arima.d = NA_integer_,
  arima.q = NA_integer_, arima.bp = NA_integer_,
  arima.bd = NA_integer_, arima.bq = NA_integer_,
  arima.coefEnabled = NA, arima.coef = NA, arima.coefType = NA,
  fcst.horizon = NA_integer_, x11.mode = c(NA, "Undefined", "Additive",
  "Multiplicative", "LogAdditive", "PseudoAdditive"),
  x11.seasonalComp = NA, x11.lsigma = NA_integer_,
  x11.usigma = NA_integer_, x11.trendAuto = NA,
  x11.trendma = NA_integer_, x11.seasonalma = NA_character_,
  x11.fcasts = NA_integer_, x11.bcasts = NA_integer_,
  x11.excludeFcasts = NA)

x13_def(series, spec = c("RSA5c", "RSA0", "RSA1", "RSA2c", "RSA3",
  "RSA4c"), userdefined = NULL)

tramoseats_spec_def(spec = c("RSAfull", "RSA0", "RSA1", "RSA2", "RSA3",
  "RSA4", "RSA5"), estimate.from = NA_character_,
  estimate.to = NA_character_, estimate.first = NA_integer_,
  estimate.last = NA_integer_, estimate.exclFirst = NA_integer_,
  estimate.exclLast = NA_integer_, estimate.tol = NA_integer_,
  estimate.eml = NA, estimate.urfinal = NA_integer_,
  transform.function = c(NA, "Auto", "None", "Log"),
  transform.fct = NA_integer_, usrdef.outliersEnabled = NA,
  usrdef.outliersType = NA, usrdef.outliersDate = NA,
  usrdef.outliersCoef = NA, usrdef.varEnabled = NA, usrdef.var = NA,
  usrdef.varType = NA, usrdef.varCoef = NA, tradingdays.mauto = c(NA,
  "Unused", "FTest", "WaldTest"), tradingdays.pftd = NA_integer_,
  tradingdays.option = c(NA, "TradingDays", "WorkingDays", "UserDefined",
  "None"), tradingdays.leapyear = NA,
  tradingdays.stocktd = NA_integer_, tradingdays.test = c(NA,
  "Separate_T", "Joint_F", "None"), easter.type = c(NA, "Unused",
  "Standard", "IncludeEaster", "IncludeEasterMonday"),
  easter.julian = NA, easter.duration = NA_integer_,
  easter.test = NA, outlier.enabled = NA,
  outlier.from = NA_character_, outlier.to = NA_character_,
  outlier.first = NA_integer_, outlier.last = NA_integer_,
  outlier.exclFirst = NA_integer_, outlier.exclLast = NA_integer_,
  outlier.ao = NA, outlier.tc = NA, outlier.ls = NA,
  outlier.so = NA, outlier.usedefcv = NA, outlier.cv = NA_integer_,
  outlier.eml = NA, outlier.tcrate = NA_integer_,
  automdl.enabled = NA, automdl.acceptdefault = NA,
  automdl.cancel = NA_integer_, automdl.ub1 = NA_integer_,
  automdl.ub2 = NA_integer_, automdl.armalimit = NA_integer_,
  automdl.reducecv = NA_integer_, automdl.ljungboxlimit = NA_integer_,
  automdl.compare = NA, arima.mu = NA, arima.p = NA_integer_,
  arima.d = NA_integer_, arima.q = NA_integer_,
  arima.bp = NA_integer_, arima.bd = NA_integer_,
  arima.bq = NA_integer_, arima.coefEnabled = NA, arima.coef = NA,
  arima.coefType = NA, fcst.horizon = NA_integer_,
  seats.approx = c(NA, "None", "Legacy", "Noisy"),
  seats.trendBoundary = NA_integer_, seats.seasdBoundary = NA_integer_,
  seats.seasdBoundary1 = NA_integer_, seats.seasTol = NA_integer_,
  seats.maBoundary = NA_integer_, seats.method = c(NA, "Burman",
  "KalmanSmoother", "McElroyMatrix"))

tramoseats_def(series, spec = c("RSAfull", "RSA0", "RSA1", "RSA2",
  "RSA3", "RSA4", "RSA5"), userdefined = NULL)

regarima_spec_def_tramoseats(spec = c("TRfull", "TR0", "TR1", "TR2",
  "TR3", "TR4", "TR5"), estimate.from = NA_character_,
  estimate.to = NA_character_, estimate.first = NA_integer_,
  estimate.last = NA_integer_, estimate.exclFirst = NA_integer_,
  estimate.exclLast = NA_integer_, estimate.tol = NA_integer_,
  estimate.eml = NA, estimate.urfinal = NA_integer_,
  transform.function = c(NA, "Auto", "None", "Log"),
  transform.fct = NA_integer_, usrdef.outliersEnabled = NA,
  usrdef.outliersType = NA, usrdef.outliersDate = NA,
  usrdef.outliersCoef = NA, usrdef.varEnabled = NA, usrdef.var = NA,
  usrdef.varType = NA, usrdef.varCoef = NA, tradingdays.mauto = c(NA,
  "Unused", "FTest", "WaldTest"), tradingdays.pftd = NA_integer_,
  tradingdays.option = c(NA, "TradingDays", "WorkingDays", "UserDefined",
  "None"), tradingdays.leapyear = NA,
  tradingdays.stocktd = NA_integer_, tradingdays.test = c(NA,
  "Separate_T", "Joint_F", "None"), easter.type = c(NA, "Unused",
  "Standard", "IncludeEaster", "IncludeEasterMonday"),
  easter.julian = NA, easter.duration = NA_integer_,
  easter.test = NA, outlier.enabled = NA,
  outlier.from = NA_character_, outlier.to = NA_character_,
  outlier.first = NA_integer_, outlier.last = NA_integer_,
  outlier.exclFirst = NA_integer_, outlier.exclLast = NA_integer_,
  outlier.ao = NA, outlier.tc = NA, outlier.ls = NA,
  outlier.so = NA, outlier.usedefcv = NA, outlier.cv = NA_integer_,
  outlier.eml = NA, outlier.tcrate = NA_integer_,
  automdl.enabled = NA, automdl.acceptdefault = NA,
  automdl.cancel = NA_integer_, automdl.ub1 = NA_integer_,
  automdl.ub2 = NA_integer_, automdl.armalimit = NA_integer_,
  automdl.reducecv = NA_integer_, automdl.ljungboxlimit = NA_integer_,
  automdl.compare = NA, arima.mu = NA, arima.p = NA_integer_,
  arima.d = NA_integer_, arima.q = NA_integer_,
  arima.bp = NA_integer_, arima.bd = NA_integer_,
  arima.bq = NA_integer_, arima.coefEnabled = NA, arima.coef = NA,
  arima.coefType = NA, fcst.horizon = NA_integer_)

regarima_def_tramoseats(series, spec = c("TRfull", "TR0", "TR1", "TR2",
  "TR3", "TR4", "TR5"))

regarima_def_x13(series, spec = c("RG5c", "RG0", "RG1", "RG2c", "RG3",
  "RG4c"))

regarima_spec_def_x13(spec = c("RG5c", "RG0", "RG1", "RG2c", "RG3",
  "RG4c"), estimate.from = NA_character_, estimate.to = NA_character_,
  estimate.first = NA_integer_, estimate.last = NA_integer_,
  estimate.exclFirst = NA_integer_, estimate.exclLast = NA_integer_,
  estimate.tol = NA_integer_, transform.function = c(NA, "Auto",
  "None", "Log"), transform.adjust = c(NA, "None", "LeapYear",
  "LengthOfPeriod"), transform.aicdiff = NA_integer_,
  usrdef.outliersEnabled = NA, usrdef.outliersType = NA,
  usrdef.outliersDate = NA, usrdef.outliersCoef = NA,
  usrdef.varEnabled = NA, usrdef.var = NA, usrdef.varType = NA,
  usrdef.varCoef = NA, tradingdays.option = c(NA, "TradingDays",
  "WorkingDays", "UserDefined", "None"), tradingdays.autoadjust = NA,
  tradingdays.leapyear = c(NA, "LeapYear", "LengthOfPeriod", "None"),
  tradingdays.stocktd = NA_integer_, tradingdays.test = c(NA, "Remove",
  "Add", "None"), easter.enabled = NA, easter.julian = NA,
  easter.duration = NA_integer_, easter.test = c(NA, "Add", "Remove",
  "None"), outlier.enabled = NA, outlier.from = NA_character_,
  outlier.to = NA_character_, outlier.first = NA_integer_,
  outlier.last = NA_integer_, outlier.exclFirst = NA_integer_,
  outlier.exclLast = NA_integer_, outlier.ao = NA, outlier.tc = NA,
  outlier.ls = NA, outlier.so = NA, outlier.usedefcv = NA,
  outlier.cv = NA_integer_, outlier.method = c(NA, "AddOne", "AddAll"),
  outlier.tcrate = NA_integer_, automdl.enabled = NA,
  automdl.acceptdefault = NA, automdl.cancel = NA_integer_,
  automdl.ub1 = NA_integer_, automdl.ub2 = NA_integer_,
  automdl.mixed = NA, automdl.balanced = NA,
  automdl.armalimit = NA_integer_, automdl.reducecv = NA_integer_,
  automdl.ljungboxlimit = NA_integer_, automdl.ubfinal = NA_integer_,
  arima.mu = NA, arima.p = NA_integer_, arima.d = NA_integer_,
  arima.q = NA_integer_, arima.bp = NA_integer_,
  arima.bd = NA_integer_, arima.bq = NA_integer_,
  arima.coefEnabled = NA, arima.coef = NA, arima.coefType = NA,
  fcst.horizon = NA_integer_)
}
\arguments{
\item{spec}{model specification}

\item{estimate.from}{character in format "YYYY-MM-DD" indicating the start of the time span (e.g. "1900-01-01"). Can be combined with \code{estimate.to}.}

\item{estimate.to}{character in format "YYYY-MM-DD" indicating the end of the time span (e.g. "2020-12-31"). Can be combined with \code{estimate.from}.}

\item{estimate.first}{numeric specifying the number of periods considered at the beginning of the series.}

\item{estimate.last}{numeric specifying the number of periods considered at the end of the series.}

\item{estimate.exclFirst}{numeric specifying the number of periods excluded at the beginning of the series. Can be combined with \code{estimate.exclLast}.}

\item{estimate.exclLast}{numeric specifying the number of periods excluded at the end of the series. Can be combined with \code{estimate.exclFirst}.}

\item{estimate.tol}{numeric, convergence tolerance. The absolute changes in the log-likelihood function are compared to this value to check for the convergence of the estimation iterations.}

\item{transform.function}{transformation of the input series: \code{"None"} - no transformation of the series; \code{"Log"} - takes the log of the series; \code{"Auto"} - the program tests for the log-level specification.}

\item{transform.adjust}{pre-adjustment of the input series for length of period or leap year effects: \code{"None"} - no adjustment; \code{"LeapYear"} - leap year effect; \code{"LengthOfPeriod"} - length of period. Modifications of this variable are taken into account only when \code{transform.function} is set to \code{"Log"}.}

\item{transform.aicdiff}{numeric defining the difference in AICC needed to accept no transformation when the automatic transformation selection is chosen (considered only when \code{transform.function} is set to \code{"Auto"}).

Control variables for the pre-specified outliers. The pre-specified outliers are used in the model only if they are enabled (\code{usrdef.outliersEnabled=TRUE}) and the outliers' type (\code{usrdef.outliersType}) and date (\code{usrdef.outliersDate}) are provided.}

\item{usrdef.outliersEnabled}{logicals. If \code{TRUE} the program uses the pre-specified outliers.}

\item{usrdef.outliersType}{vector defining the outliers' type. Possible types are: \code{("AO")} - additive, \code{("LS")} - level shift, \code{("TC")} - transitory change, \code{("SO")} -  seasonal outlier. E.g.: \code{ usrdef.outliersType =c("AO","AO","LS")}.}

\item{usrdef.outliersDate}{vector defining the outliers' date. The dates should be characters in format "YYYY-MM-DD". E.g.: \code{usrdef.outliersDate=c("2009-10-01","2005-02-01","2003-04-01")}.}

\item{usrdef.outliersCoef}{vector providing fixed coefficients for the outliers. The coefficients can't be fixed if  \code{ transform.function} is set to \code{"Auto"} - the series transformation need to be pre-defined. E.g.: \code{ usrdef.outliersCoef=c(200,170,20)}.

Control variables for the user-defined variables:}

\item{usrdef.varEnabled}{logicals. If \code{TRUE} the program uses the user-defined variables.}

\item{usrdef.var}{time series (\code{ts}) or matrix of time series (\code{mts}) with the user-defined variables.}

\item{usrdef.varType}{vector of character(s) defining the user-defined variables component type. Possible types are: \code{"Undefined", "Series", "Trend", "Seasonal", "SeasonallyAdjusted", "Irregular", "Calendar"}. The type \code{"Calendar"} has to be used with \code{tradingdays.option = "UserDefined"} to use user-defined calendar regressors. If not specified, the program will assign the \code{"Undefined"} type.}

\item{usrdef.varCoef}{vector providing fixed coefficients for the user-defined variables. The coefficients can't be fixed if  \code{ transform.function} is set to \code{"Auto"} - the series transformation need to be pre-defined.}

\item{tradingdays.option}{defines the type of the trading days regression variables: \code{"TradingDays"} -  six day-of-the-week regression variables; \code{"WorkingDays"} - one working/non-working day contrast variable; \code{"None"} - no correction for trading days and working days effects; \code{"UserDefined"} - user-defined trading days regressors (regressors have to be defined by the \code{usrdef.var} argument with \code{usrdef.varType} set to \code{"Calendar"} and \code{usrdef.varEnabled = TRUE}). \code{"None"} has also to be chosen for the "day-of-week effects" correction (\code{tradingdays.stocktd} to be modified accordingly).}

\item{tradingdays.autoadjust}{logicals. If \code{TRUE} the program corrects automatically for the leap year effect. Modifications of this variable are taken into account only when \code{transform.function} is set to \code{"Auto"}.}

\item{tradingdays.leapyear}{option for including the leap-year effect in the model: \code{"LeapYear"} - leap year effect; \code{"LengthOfPeriod"} - length of period, \code{"None"} - no effect included. The leap-year effect can be pre-specified in the model only if the input series was not pre-adjusted (\code{transform.adjust} set to \code{"None"}) and the automatic correction for the leap-year effect was not selected (\code{tradingdays.autoadjust} set to \code{FALSE}).}

\item{tradingdays.stocktd}{numeric indicating the day of the month when inventories and other stock are reported (to denote the last day of the month set the variable to 31). Modifications of this variable are taken into account only when \code{tradingdays.option} is set to \code{"None"}.}

\item{tradingdays.test}{defines the pre-tests for the significance of the trading day regression variables based on the AICC statistics: \code{"Add"} - the trading day variables are not included in the initial regression model but can be added to the RegARIMA model after the test; \code{"Remove"} - the trading day variables belong to the initial regression model but can be removed from the RegARIMA model after the test; \code{"None"} - the trading day variables are not pre-tested and are included in the model.}

\item{easter.enabled}{logicals. If \code{TRUE} the program considers the Easter effect in the model.}

\item{easter.julian}{logicals. If \code{TRUE} the program uses the Julian Easter (expressed in Gregorian calendar).}

\item{easter.duration}{numeric indicating the duration of the Easter effect (length in days, between 1 and 20).}

\item{easter.test}{defines the pre-tests for the significance of the Easter effect based on the t-statistic (Easter effect is considered as significant if the t-statistic is greater than 1.96): \code{"Add"} - the Easter effect variable is not included in the initial regression model but can be added to the RegARIMA model after the test; \code{"Remove"} - the Easter effect variable belong to the initial regression model but can be removed from the RegARIMA model after the test; \code{"None"} - the Easter effect variable is not pre-tested and is included in the model.}

\item{outlier.enabled}{logicals. If \code{TRUE} the automatic detection of outliers is enabled in the defined time span.

The time span of the series to be searched for outliers (default from 1900-01-01 to 2020-12-31) is controlled by the following six variables: \code{outlier.from, outlier.to, outlier.first, outlier.last, outlier.exclFirst} and \code{outlier.exclLast}; where \code{outlier.from} and \code{outlier.to} have priority over remaining span control variables, \code{outlier.last} and \code{outlier.first} have priority over \code{outlier.exclFirst} and \code{outlier.exclLast}, and \code{outlier.last} has priority over \code{outlier.first}.}

\item{outlier.from}{character in format "YYYY-MM-DD" indicating the start of the time span (e.g. "1900-01-01"). Can be combined with \code{outlier.to}.}

\item{outlier.to}{character in format "YYYY-MM-DD" indicating the end of the time span (e.g. "2020-12-31"). Can be combined with \code{outlier.from}.}

\item{outlier.first}{numeric specifying the number of periods considered at the beginning of the series.}

\item{outlier.last}{numeric specifying the number of periods considered at the end of the series.}

\item{outlier.exclFirst}{numeric specifying the number of periods excluded at the beginning of the series. Can be combined with \code{outlier.exclLast}.}

\item{outlier.exclLast}{numeric specifying the number of periods excluded at the end of the series. Can be combined with \code{outlier.exclFirst}.}

\item{outlier.ao}{logicals. If \code{TRUE} the automatic detection of additive outliers is enabled (\code{outlier.enabled} must be also set to \code{TRUE}).}

\item{outlier.tc}{logicals. If \code{TRUE} the automatic detection of transitory changes is enabled (\code{outlier.enabled} must be also set to \code{TRUE}).}

\item{outlier.ls}{logicals. If \code{TRUE} the automatic detection of level shifts is enabled (\code{outlier.enabled} must be also set to \code{TRUE}).}

\item{outlier.so}{logicals. If \code{TRUE} the automatic detection of seasonal outliers is enabled (\code{outlier.enabled} must be also set to \code{TRUE}).}

\item{outlier.usedefcv}{logicals. If \code{TRUE} the critical value for the outliers' detection procedure is automatically determined by the number of observations in the outlier detection time span. If \code{FALSE} the procedure uses the inputted critical value (\code{outlier.cv}).}

\item{outlier.cv}{numeric. Inputted critical value for the outliers' detection procedure. The modification of this variable is taken into account only when \code{outlier.usedefcv} is set to \code{FALSE}.}

\item{outlier.method}{determines how the program successively adds detected outliers to the model. At present only the \code{AddOne} method is supported.}

\item{outlier.tcrate}{numeric. The rate of decay for the transitory change outlier.}

\item{automdl.enabled}{logicals. If \code{TRUE} the automatic modelling of the ARIMA model is enabled. If \code{FALSE} the parameters of the ARIMA model can be specified.

Control variables for the automatic modelling of the ARIMA model (\code{automdl.enabled} is set to \code{TRUE}):}

\item{automdl.acceptdefault}{logicals. If \code{TRUE} the default model (ARIMA(0,1,1)(0,1,1)) may be chosen in the first step of the automatic model identification. If the Ljung-Box Q statistics for the residuals is acceptable, the default model is accepted and no further attempt will be made to identify any other.}

\item{automdl.cancel}{numeric, cancelation limit. If the difference in moduli of an AR and an MA roots (when estimating ARIMA(1,0,1)(1,0,1) models in the second step of the automatic identification of the differencing orders) is smaller than cancelation limit, the two roots are assumed equal and cancel out.}

\item{automdl.ub1}{numeric, first unit root limit. It is the threshold value for the initial unit root test in the automatic differencing procedure. When one of the roots in the estimation of the ARIMA(2,0,0)(1,0,0) plus mean model, performed in the first step of the automatic model identification procedure, is larger than first unit root limit in modulus, it is set equal to unity.}

\item{automdl.ub2}{numeric, second unit root limit. When one of the roots in the estimation of the ARIMA(1,0,1)(1,0,1) plus mean model, which is performed in the second step of the automatic model identification procedure, is larger than second unit root limit in modulus, it is checked if there is a common factor in the corresponding AR and MA polynomials of the ARMA model that can be cancelled (see \code{automdl.cancel}). If there is no cancellation, the AR root is set equal to unity (i.e. the differencing order changes).}

\item{automdl.mixed}{logicals. The variable controls whether ARIMA models with non-seasonal AR and MA terms or seasonal AR and MA terms will be considered in the automatic model identification procedure. If \code{FALSE} a model with AR and MA terms in both the seasonal and non-seasonal parts of the model can be acceptable, provided there are not AR and MA terms in either the seasonal or non-seasonal.}

\item{automdl.balanced}{logicals. If \code{TRUE}, the automatic model identification procedure will have a preference for balanced models (i.e. models for which the order of the combined AR and differencing operator is equal to the order of the combined MA operator).}

\item{automdl.armalimit}{numeric, arma limit. It is the threshold value for t-statistics of ARMA coefficients and constant term used for the final test of model parsimony. If the highest order ARMA coefficient has a t-value less than this value in magnitude, the order of the model is reduced. Also if the constant term has a t-value less than arma limit in magnitude, it is removed from the set of regressors.}

\item{automdl.reducecv}{numeric, ReduceCV.  The percentage by which the outlier's critical value will be reduced when an identified model is found to have a Ljung-Box statistic with an unacceptable confidence coefficient. The parameter should be between 0 and 1, and will only be active when automatic outlier identification is enabled. The reduced critical value will be set to (1-ReduceCV)xCV, where CV is the original critical value.}

\item{automdl.ljungboxlimit}{numeric, Ljung Box limit. Acceptance criterion for the confidence intervals of the Ljung-Box Q statistic. If the LjungBox Q statistics for the residuals of a final model is greater than Ljung Box limit, the model is rejected, the outlier critical value is reduced, and model and outlier identification (if specified) is redone with a reduced value.}

\item{automdl.ubfinal}{numeric, final unit root limit. The threshold value for the final unit root test. If the magnitude of an AR root for the final model is less than the final unit root limit, a unit root is assumed, the order of the AR polynomial is reduced by one, and the appropriate order of the differencing (non-seasonal, seasonal) is increased. The parameter value should be greater than one.

Control variables for the non-automatic modelling of the ARIMA model (\code{automdl.enabled} is set to \code{FALSE}):}

\item{arima.mu}{logicals. If \code{TRUE}, the mean is considered as part of the ARIMA model.}

\item{arima.p}{numeric. The order of the non-seasonal autoregressive (AR) polynomial.}

\item{arima.d}{numeric. Regular differencing order.}

\item{arima.q}{numeric. The order of the non-seasonal moving average (MA) polynomial.}

\item{arima.bp}{numeric. The order of the seasonal autoregressive (AR) polynomial.}

\item{arima.bd}{numeric. Seasonal differencing order.}

\item{arima.bq}{numeric. The order of the seasonal moving average (MA) polynomial.

Control variables for the user-defined ARMA coefficients. Coefficients can be defined for the regular and seasonal autoregressive (AR) polynomials and moving average (MA) polynomials. The model considers the coefficients only if the procedure for their estimation (\code{arima.coefType}) is provided, and the number of provided coefficients matches the sum of (regular and seasonal) AR and MA orders (\code{p,q,bp,bq}).}

\item{arima.coefEnabled}{logicals. If \code{TRUE} the program uses the user-defined ARMA coefficients.}

\item{arima.coef}{vector providing the coefficients for the regular and seasonal AR and MA polynominals. The length of the vector must equal the sum of the regular and seasonal AR and MA orders. The coefficients shall be provided in the order: regular AR (\emph{Phi} - \code{p} elements), regular MA  (\emph{Theta} - \code{q} elements), seasonal AR (\emph{BPhi} - \code{bp} elements) and seasonal MA (\emph{BTheta} - \code{bq} elements). E.g.: \code{arima.coef=c(0.6,0.7)} with \code{arima.p=1, arima.q=0,arima.bp=1} and \code{arima.bq=0}.}

\item{arima.coefType}{vector defining ARMA coefficients estimation procedure. Possible procedures are: \code{"Undefined"} - no use of user-defined input (i.e. coefficients are estimated), \code{"Fixed"} - fixes the coefficients at the value provided by the user, \code{"Initial"} - the value defined by the user is used as initial condition. For orders for which the coefficients shall not be defined, the \code{arima.coef} can be set to \code{NA} or \code{0} or the \code{arima.coefType} can be set to \code{"Undefined"}.
E.g.: \code{arima.coef = c(-0.8,-0.6,NA)}, \code{arima.coefType = c("Fixed","Fixed","Undefined")}.}

\item{fcst.horizon}{numeric, forecasts horizon. Length of the forecasts generated by the RegARIMA model in periods (positive values) or years (negative values). By default the program generates two years forecasts (\code{fcst.horizon} set to \code{-2}).}

\item{x11.mode}{character, decomposition mode. Determines the mode of the seasonal adjustment decomposition to be performed: \code{"Undefined"} - no assumption concerning the relationship between the time series components is made; \code{"Additive"} - assumes an additive relationship; \code{"Multiplicative"} - assumes a multiplicative relationship; \code{"LogAdditive"} - performs an additive decomposition of the logarithms of the series being adjusted; \code{"PseudoAdditive"} - assumes an pseudo-additive relationship. Could be changed by the program, if needed.}

\item{x11.seasonalComp}{logicals. If \code{TRUE} the program computes a seasonal component. Otherwise, the seasonal component is not estimated and its values are all set to 0 (additive decomposition) or 1 (multiplicative decomposition).}

\item{x11.lsigma}{numeric, lower sigma boundary for the detection of extreme values.}

\item{x11.usigma}{numeric, upper sigma boundary for the detection of extreme values.}

\item{x11.trendAuto}{logicals, automatic Henderson filter. If \code{TRUE} an automatic selection of the Henderson filter's length for the trend estimation is enabled.}

\item{x11.trendma}{numeric, length of the Henderson filter. The user-defined length of the Henderson filter. The option is available when the automatic Henderson filter selection is disabled (\code{x11.trendAuto=FALSE}). Should be an odd number in the range (1, 101].}

\item{x11.seasonalma}{vector of character(s) specifying which seasonal moving average (i.e. seasonal filter) will be used to estimate the seasonal factors for the entire series. The vector can be of length: 1 - same seasonal filters for all periods (e.g.: \code{seasonalma=c("Msr")}); or period's number - a seasonal filer is defined for each period (e.g. for quarterly series: \code{seasonalma=c("S3X3","Msr","S3X3","Msr")}). Possible filters are: \code{"Msr", "Stable", "X11Default", "S3X1", "S3X3", "S3X5", "S3X9", "S3X15"}. \code{"Msr"} - the program chooses the final seasonal filter automatically.}

\item{x11.fcasts}{numeric, RegARIMA forecast. Length of the forecasts generated by the RegARIMA model in periods (positive values) or years (negative values).}

\item{x11.bcasts}{numeric, backcast. Length of the backcasts used in X11. Negative figures are translated in years of backcasts.}

\item{x11.excludeFcasts}{logicals, exclude forecats and backcasts. If \code{TRUE} forecasts and backcasts from the RegARIMA model are not used in the generation of extreme values in the seasonal adjustment routines.}

\item{series}{a univariate time series}

\item{userdefined}{vector with characters for additional output variables (see \code{\link{user_defined_variables}}).}

\item{estimate.eml}{logicals, exact maximum likelihood estimation. If \code{TRUE} the program performs an exact maximum likelihood estimation. If \code{FASLE} the Unconditional Least Squares method is used.}

\item{estimate.urfinal}{numeric, final unit root limit. The threshold value for the final unit root test for identification of differencing orders. If the magnitude of an AR root for the final model is less than this number, a unit root is assumed, the order of the AR polynomial is reduced by one, and the appropriate order of the differencing (non-seasonal, seasonal) is increased.}

\item{transform.fct}{numeric controlling the bias in the log/level pre-test: \code{ transform.fct }> 1 favours levels, \code{transform.fct}< 1 favours logs. Considered only when \code{transform.function} is set to \code{"Auto"}.

Control variables for the pre-specified outliers. The pre-specified outliers are used in the model only if they are enabled (\code{usrdef.outliersEnabled=TRUE}) and the outliers' type (\code{usrdef.outliersType}) and date (\code{usrdef.outliersDate}) are provided.}

\item{tradingdays.mauto}{defines whether the calendar effects should be added to the model manually (\code{"Unused"}) or automatically. In the automatic selection, the choice of the number of calendar variables can be based on the F-Test (\code{"FTest"}) or the Wald Test (\code{"WaldTest"}); the model with higher F value is chosen, provided that it is higher than \code{tradingdays.pftd}).}

\item{tradingdays.pftd}{numeric. P-value applied in the test specified by the automatic parameter (\code{tradingdays.mauto}) to assess the significance of the pre-tested calendar effects variables and whether they should be included in the RegArima model.

Control variables for the manual selection of calendar effects variables (\code{tradingdays.mauto} is set to \code{"Unused"}):}

\item{easter.type}{specifies the presence and the length of the Easter effect: \code{"Unused"} - Easter effect is not considered; \code{"Standard"} - influences the period of \code{n} days strictly before Easter Sunday; \code{"IncludeEaster"} - influences the entire period (\code{n}) up to and including Easter Sunday; \code{"IncludeEasterMonday"} - influences the entire period (\code{n}) up to and including Easter Monday.}

\item{outlier.eml}{logicals, exact likelihood estimation method.Controls the method applied for a parameter estimation in the intermediate steps of the automatic detection and correction of outliers.  If \code{TRUE} an exact likelihood estimation method is used, when \code{FALSE} the fast Hannan-Rissanen method is used.}

\item{automdl.compare}{logicals. If {TRUE} the program compares the model identified by the automatic procedure to the default model (ARIMA(0,1,1)(0,1,1)) and the model with the best fit is selected. Criteria considered are residual diagnostics, the model structure and the number of outliers.

Control variables for the non-automatic modelling of the ARIMA model (\code{automdl.enabled} is set to \code{FALSE}):}

\item{seats.approx}{character, approximation mode. When the ARIMA model estimated by TRAMO does not accept an admissible decomposition, SEATS: \code{"None"} - performs an approximation; \code{"Legacy"} - replaces the model with a decomposable one; \code{"Noisy"} - estimates a new model by adding a white noise to the non-admissible model estimated by TRAMO.}

\item{seats.trendBoundary}{numeric, trend boundary. The boundary from which an AR root is integrated in the trend component. If the modulus of the inverse real root is greater than Trend boundary, the AR root is integrated in the trend component. Below this value the root is integrated in the transitory component.}

\item{seats.seasdBoundary}{numeric, seasonal boundary. Boundary from which a negative AR root is integrated in the seasonal component.}

\item{seats.seasdBoundary1}{numeric, seasonal boundary (unique). Boundary from which a negative AR root is integrated in the seasonal component when the root is the unique seasonal root.}

\item{seats.seasTol}{numeric, seasonal tolerance. The tolerance (measured in degrees) to allocate the AR non-real roots to the seasonal component (if the modulus of the inverse complex AR root is greater than Trend boundary and the frequency of this root differs from one of the seasonal frequencies by less than Seasonal tolerance) or the transitory component (otherwise).}

\item{seats.maBoundary}{numeric, MA unit root boundary. When the modulus of an estimated MA root falls in the range (xl, 1), it is set to xl.}

\item{seats.method}{character, estimation method of the unobserved components. The choice can be made from: \code{"Burman"} (default, may result in a significant underestimation of the standard deviations of the components as it may become numerically unstable when some roots of the MA polynomial are near 1); \code{"KalmanSmoother"} (it is not disturbed by the (quasi-) unit roots in MA); \code{"McElroyMatrix"} (has the same stability issues as the Burman's algorithm).}
}
\description{
Use \code{\link{x13_spec}} instead of \code{x13_spec_def}.

Use \code{\link{x13}} instead of \code{x13_def}.

Use \code{\link{tramoseats_spec}} instead of \code{tramoseats_spec_def}.

Use \code{\link{tramoseats}} instead of \code{tramoseats_def}.

Use \code{\link{regarima_spec_tramoseats}} instead of \code{regarima_spec_def_tramoseats}.

Use \code{\link{regarima_tramoseats}} instead of \code{regarima_def_tramoseats}.

Use \code{\link{regarima_x13}} instead of \code{regarima_def_x13}.

Use \code{\link{regarima_spec_x13}} instead of \code{regarima_spec_def_x13}.
}
