/*
 * Decompiled with CFR 0.152.
 */
package demetra.workspace.file;

import demetra.workspace.file.FileSupport;
import demetra.workspace.io.JaxbUtil;
import demetra.workspace.util.Paths;
import demetra.xml.information.XmlInformationSet;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.InformationSetSerializable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

public final class InformationSetSupport
implements FileSupport {
    private final String repository;
    private final Supplier<? extends InformationSetSerializable> factory;
    private final Class<? extends InformationSetSerializable> type;
    private static final JAXBContext XML_INFORMATION_SET_CONTEXT = JaxbUtil.createContext(XmlInformationSet.class);

    @Nonnull
    public static FileSupport of(@Nonnull Supplier<? extends InformationSetSerializable> factory, @Nonnull String repository) {
        return new InformationSetSupport(factory, repository);
    }

    private InformationSetSupport(Supplier<? extends InformationSetSerializable> factory, String repository) {
        this.repository = Objects.requireNonNull(repository);
        this.factory = Objects.requireNonNull(factory);
        this.type = factory.get().getClass();
    }

    @Override
    public Path resolveFile(Path root, String fileName) {
        return root.resolve(this.repository).resolve(InformationSetSupport.xmlFileName(fileName));
    }

    @Override
    public Object read(Path root, String fileName) throws IOException {
        try {
            return InformationSetSupport.readItem(this.resolveFile(root, fileName), this.factory);
        }
        catch (JAXBException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void write(Path root, String fileName, Object value) throws IOException {
        try {
            InformationSetSupport.writeItem(this.resolveFile(root, fileName), this.type, value);
        }
        catch (JAXBException ex) {
            throw new IOException(ex);
        }
    }

    static Object readItem(Path file, Supplier<? extends InformationSetSerializable> factory) throws IOException, JAXBException {
        return InformationSetSupport.xmlToItem(factory, InformationSetSupport.unmarshalItem(file));
    }

    static void writeItem(Path file, Class<? extends InformationSetSerializable> type, Object value) throws IOException, JAXBException {
        InformationSetSupport.marshalItem(file, InformationSetSupport.itemToXml(type.cast(value)));
    }

    private static String xmlFileName(String fileName) {
        return Paths.changeExtension(fileName, "xml");
    }

    private static InformationSetSerializable xmlToItem(Supplier<? extends InformationSetSerializable> factory, XmlInformationSet xml) throws IOException {
        InformationSetSerializable result = factory.get();
        if (!result.read(xml.create())) {
            throw new IOException("Cannot read information set");
        }
        return result;
    }

    private static XmlInformationSet itemToXml(InformationSetSerializable value) throws IOException {
        InformationSet info = value.write(false);
        if (info == null) {
            throw new IOException("Cannot write information set");
        }
        XmlInformationSet result = new XmlInformationSet();
        result.copy(info);
        return result;
    }

    private static XmlInformationSet unmarshalItem(Path file) throws IOException, JAXBException {
        return (XmlInformationSet)JaxbUtil.unmarshal(file, XML_INFORMATION_SET_CONTEXT);
    }

    private static void marshalItem(Path file, XmlInformationSet jaxbElement) throws IOException, JAXBException {
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        JaxbUtil.marshal(file, XML_INFORMATION_SET_CONTEXT, jaxbElement, true);
    }
}

