/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.eco;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.eco.Ols;
import ec.tstoolkit.eco.RegModel;
import ec.tstoolkit.maths.matrices.LowerTriangularMatrix;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;

public class Gls {
    private RegModel model_;
    private RegModel lmodel_;
    private Matrix var_;
    private Matrix l_;
    private boolean scaling_;
    private ConcentratedLikelihood ll_;

    public boolean isScaling() {
        return this.scaling_;
    }

    public void setScaling(boolean scaling) {
        this.scaling_ = scaling;
    }

    public ConcentratedLikelihood getLikelihood() {
        return this.ll_;
    }

    public RegModel getModel() {
        return this.model_;
    }

    public Matrix getVariance() {
        return this.var_;
    }

    public DataBlock getResiduals() {
        return this.lmodel_.calcRes(new DataBlock(this.ll_.getB()));
    }

    public boolean process(RegModel model, Matrix var) {
        Ols ols;
        this.model_ = model;
        this.var_ = var;
        if (this.var_.getRowsCount() != model.getObsCount()) {
            return false;
        }
        this.l_ = this.var_.clone();
        SymmetricMatrix.lcholesky(this.l_);
        this.lmodel_ = new RegModel();
        Matrix x = model.variables();
        DataBlock y = model.getY().deepClone();
        int n = y.getLength();
        int nx = 0;
        if (x != null) {
            nx = x.getColumnsCount();
        }
        double[] factors = null;
        double yfactor = 1.0;
        if (this.scaling_) {
            double yn = y.nrm2();
            if (yn != 0.0) {
                yfactor = (double)n / yn;
                y.mul(yfactor);
            }
            if (nx > 0) {
                DataBlockIterator cols = x.columns();
                DataBlock col = cols.getData();
                factors = new double[nx];
                do {
                    double xn;
                    if ((xn = col.nrm2()) != 0.0) {
                        double w;
                        factors[cols.getPosition()] = w = (double)n / xn;
                        col.mul(w);
                        continue;
                    }
                    factors[cols.getPosition()] = 1.0;
                } while (cols.next());
            }
        }
        LowerTriangularMatrix.rsolve(this.l_, y);
        this.lmodel_.setY(y);
        if (nx > 0) {
            DataBlockIterator cols = x.columns();
            DataBlock col = cols.getData();
            do {
                LowerTriangularMatrix.rsolve(this.l_, col);
                this.lmodel_.addX(col.deepClone());
            } while (cols.next());
        }
        if (!(ols = new Ols()).process(this.lmodel_)) {
            return false;
        }
        ConcentratedLikelihood ll = ols.getLikelihood();
        this.ll_ = new ConcentratedLikelihood();
        this.ll_.set(ll.getSsqErr(), 2.0 * this.l_.diagonal().sumLog().value, ll.getN());
        if (nx > 0) {
            this.ll_.setB(ll.getB(), ll.getBVar(), nx);
        }
        if (this.scaling_) {
            this.ll_.rescale(yfactor, factors);
        }
        return true;
    }
}

