/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.realfunctions.bfgs;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.maths.realfunctions.FunctionException;
import ec.tstoolkit.maths.realfunctions.IFunction;
import ec.tstoolkit.maths.realfunctions.IFunctionInstance;
import ec.tstoolkit.maths.realfunctions.IFunctionMinimizer;
import ec.tstoolkit.maths.realfunctions.NumericalDerivatives;
import ec.tstoolkit.maths.realfunctions.ParamValidation;
import ec.tstoolkit.maths.realfunctions.bfgs.DefaultLineFunction;
import ec.tstoolkit.maths.realfunctions.bfgs.ILineSearch;
import ec.tstoolkit.maths.realfunctions.bfgs.QuadraticLineSearch;

public class Bfgs
implements IFunctionMinimizer {
    private double[] m_x;
    private double[] m_y;
    private double[] m_s;
    private double[] m_g;
    private double[] m_xprev;
    private double[] m_gprev;
    private double[] m_d;
    private IFunction m_fn;
    private IFunctionInstance m_ftry;
    private Matrix m_B;
    private ILineSearch m_lsearch = new QuadraticLineSearch();
    private double m_eps = 1.0E-9;
    private double m_geps = 1.0E-7;
    private double m_alpha;
    private double m_f;
    private double m_fprev;
    private double m_falpha = 0.5;
    private int m_iter;
    private int m_maxiter = 100;
    private int m_bdirty;
    private boolean m_bUpdated;
    private boolean m_gUpdated;
    private boolean m_bStrong = true;
    private boolean m_bConverged;
    private static final int m_bminiter = 5;

    private void calcD() {
        DataBlock d = new DataBlock(this.m_d);
        DataBlock g = new DataBlock(this.m_gprev);
        d.product(this.m_B.rows(), g);
        d.chs();
    }

    private void calcGrad(double[] g) {
        double[] grad = this.m_fn.getDerivatives(this.m_ftry).getGradient();
        System.arraycopy(grad, 0, g, 0, g.length);
    }

    private void calcSGrad(double[] g) {
        NumericalDerivatives D = new NumericalDerivatives(this.m_fn, this.m_ftry, true);
        double[] grad = D.getGradient();
        System.arraycopy(grad, 0, g, 0, g.length);
    }

    private boolean canStop(int test) {
        if (test == 1 && this.m_bdirty < 2) {
            return false;
        }
        if (test == 1) {
            return this.m_f <= this.m_fprev && (this.m_fprev - this.m_f) / Math.abs(this.m_fprev) < this.m_eps;
        }
        if (test == 2) {
            double gnorm = new DataBlock(this.m_g).nrm2();
            return gnorm / Math.abs(this.m_fprev) < this.m_geps;
        }
        return false;
    }

    @Override
    public IFunctionMinimizer exemplar() {
        Bfgs bfgs = new Bfgs();
        bfgs.m_lsearch = this.m_lsearch.exemplar();
        bfgs.m_eps = this.m_eps;
        bfgs.m_geps = this.m_geps;
        bfgs.m_alpha = this.m_alpha;
        bfgs.m_falpha = this.m_falpha;
        bfgs.m_maxiter = this.m_maxiter;
        bfgs.m_bStrong = this.m_bStrong;
        return bfgs;
    }

    public Matrix getB() {
        if (this.m_ftry == null) {
            return null;
        }
        if (!this.m_bUpdated) {
            if (!this.m_gUpdated) {
                this.calcGrad(this.m_g);
                this.m_gUpdated = true;
            }
            if (this.m_bdirty < 5 || !this.update()) {
                Matrix h = new NumericalDerivatives(this.m_fn, this.m_ftry, true).getHessian();
                this.m_B = SymmetricMatrix.inverse(h);
            }
            this.m_bUpdated = true;
        }
        return this.m_B;
    }

    @Override
    public double getConvergenceCriterion() {
        return this.m_eps;
    }

    @Override
    public Matrix getCurvature() {
        Matrix b = this.getB();
        if (b == null) {
            return null;
        }
        return SymmetricMatrix.inverse(b);
    }

    @Override
    public double[] getGradient() {
        if (this.m_ftry == null) {
            return null;
        }
        if (!this.m_gUpdated) {
            this.calcGrad(this.m_g);
            this.m_gUpdated = true;
        }
        return this.m_g;
    }

    @Override
    public int getIterCount() {
        return this.m_iter;
    }

    public ILineSearch getLineSearch() {
        return this.m_lsearch;
    }

    @Override
    public int getMaxIter() {
        return this.m_maxiter;
    }

    @Override
    public IFunctionInstance getResult() {
        return this.m_ftry;
    }

    @Override
    public double getObjective() {
        return this.m_ftry == null ? Double.NaN : this.m_ftry.getValue();
    }

    private void initialize(IFunction fn, IFunctionInstance pstart) {
        this.m_fn = fn;
        this.m_iter = 0;
        int n = this.m_fn.getDomain().getDim();
        this.m_g = new double[n];
        this.m_gprev = new double[n];
        this.m_x = new double[n];
        this.m_xprev = new double[n];
        this.m_d = new double[n];
        this.m_s = new double[n];
        this.m_y = new double[n];
        this.m_B = new Matrix(n, n);
        this.start(pstart);
    }

    public boolean isUsingStrongStopConditions() {
        return this.m_bStrong;
    }

    private boolean iterate() {
        if (this.canStop(2)) {
            this.m_bConverged = true;
            return false;
        }
        int n = this.m_x.length;
        System.arraycopy(this.m_x, 0, this.m_xprev, 0, this.m_x.length);
        System.arraycopy(this.m_g, 0, this.m_gprev, 0, this.m_g.length);
        this.m_fprev = this.m_f;
        this.m_bUpdated = false;
        this.m_gUpdated = false;
        if (!this.lsearch()) {
            return false;
        }
        if (this.m_bdirty > 0) {
            if (!this.m_bStrong) {
                if (this.canStop(1)) {
                    this.m_bConverged = true;
                    return false;
                }
                this.calcGrad(this.m_g);
                this.m_gUpdated = true;
                if (this.canStop(2)) {
                    this.m_bConverged = true;
                    return false;
                }
            } else {
                this.calcGrad(this.m_g);
                this.m_gUpdated = true;
                if (this.canStop(1) && this.canStop(2)) {
                    return false;
                }
            }
            this.update();
        }
        return true;
    }

    private boolean lsearch() {
        try {
            this.calcD();
            DefaultLineFunction fn = new DefaultLineFunction(this.m_fn, this.m_ftry, this.m_d, this.m_gprev);
            if (fn.getDerivative() >= 0.0) {
                if (this.m_bdirty == 0) {
                    return false;
                }
                this.start(null);
                return true;
            }
            if (!this.m_lsearch.optimize(fn, this.m_alpha)) {
                if (this.m_bdirty == 0) {
                    return false;
                }
                this.start(null);
                return true;
            }
            ++this.m_bdirty;
            IFunctionInstance ftry = fn.getResult();
            DataBlock newval = new DataBlock(ftry.getParameters());
            ParamValidation v = this.m_fn.getDomain().validate(newval);
            if (v == ParamValidation.Invalid) {
                throw new FunctionException("Boundaries error");
            }
            if (v == ParamValidation.Changed) {
                this.start(this.m_fn.evaluate(newval));
                return true;
            }
            this.m_ftry = ftry;
            this.m_f = ftry.getValue();
            newval.copyTo(this.m_x, 0);
            return true;
        }
        catch (RuntimeException err) {
            return false;
        }
    }

    @Override
    public boolean minimize(IFunction function, IFunctionInstance start) {
        this.initialize(function, start);
        while (this.iterate() && this.m_iter < this.m_maxiter) {
            ++this.m_iter;
        }
        return true;
    }

    public boolean hasConverged() {
        return this.m_bConverged;
    }

    public boolean minimize(IFunction function, IReadDataBlock pstart) {
        return this.minimize(function, function.evaluate(pstart));
    }

    @Override
    public void setConvergenceCriterion(double value) {
        this.m_eps = value;
    }

    public void setLineSearch(ILineSearch value) {
        this.m_lsearch = value;
    }

    @Override
    public void setMaxIter(int value) {
        this.m_maxiter = value;
    }

    private void start(IFunctionInstance start) {
        int n = this.m_x.length;
        if (start != null) {
            this.m_ftry = start;
            IReadDataBlock p = this.m_ftry.getParameters();
            p.copyTo(this.m_x, 0);
            this.m_alpha = 1.0;
            this.m_falpha = 1.0 / Math.sqrt(n);
            this.m_f = this.m_ftry.getValue();
            this.calcGrad(this.m_g);
        }
        this.m_B.subMatrix().set(0.0);
        this.m_B.subMatrix().diagonal().set(1.0);
        for (int i = 0; i < n; ++i) {
            this.m_d[i] = -this.m_g[i];
        }
        this.m_bConverged = false;
        this.m_bdirty = 0;
    }

    private boolean update() {
        int n = this.m_s.length;
        for (int i = 0; i < n; ++i) {
            this.m_s[i] = this.m_x[i] - this.m_xprev[i];
            this.m_y[i] = this.m_g[i] - this.m_gprev[i];
        }
        DataBlock p = new DataBlock(this.m_s);
        DataBlock q = new DataBlock(this.m_y);
        double r = p.dot(q);
        if (r <= 0.0 || r <= 1.0E-12 * p.nrm2() * q.nrm2()) {
            return false;
        }
        double[] bq = new double[n];
        DataBlockIterator brows = this.m_B.rows();
        DataBlock brow = brows.getData();
        do {
            bq[brows.getPosition()] = brow.dot(q);
        } while (brows.next());
        double b1 = 1.0 + SymmetricMatrix.quadraticForm(this.m_B, this.m_y) / r;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                this.m_B.add(i, j, (b1 * this.m_s[i] * this.m_s[j] - this.m_s[i] * bq[j] - this.m_s[j] * bq[i]) / r);
            }
        }
        return true;
    }

    public void useStrongStopConditions(boolean value) {
        this.m_bStrong = value;
    }
}

