/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.demetra;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.polynomials.UnitRoots;
import ec.tstoolkit.modelling.arima.IDifferencingModule;
import ec.tstoolkit.modelling.arima.IPreprocessingModule;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.ProcessingResult;
import ec.tstoolkit.modelling.arima.demetra.DemetraModule;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.timeseries.regression.AbstractOutlierVariable;

public class DifferencingModule
extends DemetraModule
implements IDifferencingModule,
IPreprocessingModule {
    public static final int MAXD = 2;
    public static final int MAXBD = 1;
    public static final double EPS = 1.0E-5;
    private int d;
    private int bd;
    private int freq;
    private double tmean;
    private double k = 1.2;
    private double tstat = 1.96;
    private int maxd = 2;
    private int maxbd = 1;
    private boolean regularFirst = false;
    private boolean mad = false;

    private void clear() {
        this.freq = 0;
        this.d = 0;
        this.bd = 0;
    }

    @Override
    public int getBD() {
        return this.bd;
    }

    @Override
    public boolean isMeanCorrection() {
        return Math.abs(this.tmean) > this.tstat;
    }

    @Override
    public int getD() {
        return this.d;
    }

    public BackFilter getDifferencingFilter() {
        Polynomial D = UnitRoots.D(1, this.d);
        Polynomial BD = UnitRoots.D(this.freq, this.bd);
        return BackFilter.of(D.times(BD).getCoefficients());
    }

    private double std(IReadDataBlock z) {
        if (!this.mad) {
            return Math.sqrt(z.ssqc(z.average()) / (double)z.getLength());
        }
        return AbstractOutlierVariable.mad(z, true);
    }

    @Override
    public ProcessingResult process(ModellingContext context) {
        try {
            DataBlock res;
            if (context.estimation != null) {
                int xcount = context.estimation.getRegArima().getXCount();
                int xout = context.description.getOutliers().size();
                res = context.estimation.getCorrectedData(xcount - xout, xcount);
            } else {
                res = new DataBlock(context.description.transformedOriginal());
            }
            SarimaSpecification nspec = context.description.getSpecification();
            this.freq = context.description.getFrequency();
            this.process(res, this.freq, nspec.getD(), nspec.getBD());
            boolean changed = false;
            if (nspec.getD() != this.d || nspec.getBD() != this.bd) {
                changed = true;
                SarimaSpecification cspec = new SarimaSpecification(this.freq);
                cspec.setD(this.d);
                cspec.setBD(this.bd);
                context.description.setSpecification(cspec);
                context.estimation = null;
            }
            if (this.isMeanCorrection() != context.description.isEstimatedMean()) {
                changed = true;
                context.description.setMean(this.isMeanCorrection());
                context.estimation = null;
            }
            return changed ? ProcessingResult.Changed : ProcessingResult.Unchanged;
        }
        catch (RuntimeException err) {
            context.description.setAirline(context.hasseas);
            context.estimation = null;
            return ProcessingResult.Failed;
        }
    }

    @Override
    public void process(IReadDataBlock res, int freq, int curd, int curbd) {
        boolean bok;
        int i;
        this.clear();
        this.d = curd;
        this.bd = curbd;
        DataBlock z = new DataBlock(res);
        for (i = 0; i < curd; ++i) {
            z.difference();
            z.shrink(1, 0);
        }
        for (i = 0; i < curbd; ++i) {
            z.difference(1.0, freq);
            z.shrink(freq, 0);
        }
        double refe = this.std(z);
        boolean ok = this.d < this.maxd;
        boolean bl = bok = this.bd < this.maxbd;
        do {
            double e;
            DataBlock tmp;
            if (this.regularFirst && this.d < this.maxd && ok) {
                tmp = z.deepClone();
                tmp.difference();
                tmp.shrink(1, 0);
                e = this.std(tmp);
                if (e < refe * this.k) {
                    z = tmp;
                    refe = e;
                    ++this.d;
                    ok = this.d < this.maxd;
                    bok = this.bd < this.maxbd;
                } else {
                    ok = false;
                }
            }
            if (this.bd < this.maxbd && bok) {
                tmp = z.deepClone();
                tmp.difference(1.0, freq);
                tmp.shrink(freq, 0);
                e = this.std(tmp);
                if (e < refe * this.k) {
                    refe = e;
                    z = tmp;
                    ++this.bd;
                    bok = this.bd < this.maxbd;
                    ok = this.d < this.maxd;
                } else {
                    bok = false;
                }
            }
            if (this.regularFirst || this.d >= this.maxd || !ok) continue;
            tmp = z.deepClone();
            tmp.difference();
            tmp.shrink(1, 0);
            e = this.std(tmp);
            if (e < refe * this.k) {
                z = tmp;
                refe = e;
                ++this.d;
                ok = this.d < this.maxd;
                bok = this.bd < this.maxbd;
                continue;
            }
            ok = false;
        } while (ok || bok);
        this.testMean(z);
    }

    private void testMean(DataBlock z) {
        double s = z.sum();
        double s2 = z.ssq();
        int n = z.getLength();
        this.tmean = s / Math.sqrt((s2 * (double)n - s * s) / (double)n);
    }

    public double getTmean() {
        return this.tmean;
    }

    public double getK() {
        return this.k;
    }

    public void setK(double k) {
        this.k = k;
    }

    public double getTstat() {
        return this.tstat;
    }

    public void setTstat(double tstat) {
        this.tstat = tstat;
    }

    @Override
    public void setLimits(int maxd, int maxbd) {
        this.maxd = maxd;
        this.maxbd = maxbd;
    }

    public boolean isRegularFirst() {
        return this.regularFirst;
    }

    public void setRegularFirst(boolean regularFirst) {
        this.regularFirst = regularFirst;
    }

    public boolean isMad() {
        return this.mad;
    }

    public void setMad(boolean mad) {
        this.mad = mad;
    }
}

