/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.satoolkit.diagnostics.AutoRegressiveSpectrumTest;
import ec.satoolkit.diagnostics.FriedmanTest;
import ec.satoolkit.diagnostics.PeriodogramTest;
import ec.satoolkit.diagnostics.QSTest;
import ec.satoolkit.diagnostics.TukeySpectrumPeaksTest;
import ec.tstoolkit.data.BlackmanTukeySpectrum;
import ec.tstoolkit.data.WindowType;
import ec.tstoolkit.modelling.DifferencingResults;
import ec.tstoolkit.modelling.arima.tramo.SpectralPeaks;
import ec.tstoolkit.stats.StatisticalTest;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsFrequency;

public class SeasonalityTests {
    public static final int MSHORT = 80;
    public static final int SHORT = 60;
    public static final int SPEC_LENGTH = 120;
    private DifferencingResults delta;
    private FriedmanTest nptest;
    private BlackmanTukeySpectrum btSpectrum;
    private TukeySpectrumPeaksTest tpeaks;
    private AutoRegressiveSpectrumTest arpeaks;
    private SpectralPeaks[] peaks;
    private StatisticalTest qs;
    private StatisticalTest periodogram;
    private int score;
    private int nqs_ = 2;

    public static SeasonalityTests residualSeasonalityTest(double[] res, TsFrequency freq) {
        int n;
        FriedmanTest np;
        SeasonalityTests tests = new SeasonalityTests();
        tests.testResiduals(res, freq);
        StatisticalTest qs = tests.getQs();
        if (qs != null && qs.isSignificant()) {
            ++tests.score;
        }
        if ((np = tests.getNonParametricTest()) != null && np.isSignificant()) {
            ++tests.score;
        }
        if (((n = tests.getDifferencing().getDifferenced().getLength()) >= 80 || freq != TsFrequency.Monthly && n >= 60) && SpectralPeaks.hasSeasonalPeaks(tests.getSpectralPeaks())) {
            ++tests.score;
        }
        return tests;
    }

    public static SeasonalityTests seasonalityTest(TsData s, int diff, boolean mean, boolean all) {
        int n;
        FriedmanTest np;
        if (s.getFrequency() == TsFrequency.Yearly) {
            return null;
        }
        SeasonalityTests tests = new SeasonalityTests();
        tests.test(s, diff, mean);
        StatisticalTest qs = tests.getQs();
        if (qs != null && qs.isSignificant()) {
            ++tests.score;
            if (!all) {
                return tests;
            }
        }
        if ((np = tests.getNonParametricTest()) != null && np.isSignificant()) {
            ++tests.score;
            if (!all) {
                return tests;
            }
        }
        if (((n = tests.getDifferencing().getDifferenced().getLength()) >= 80 || s.getFrequency() != TsFrequency.Monthly && n >= 60) && SpectralPeaks.hasSeasonalPeaks(tests.getSpectralPeaks())) {
            ++tests.score;
            if (!all) {
                return tests;
            }
        }
        return tests;
    }

    void test(TsData input, int ndiff, boolean mean) {
        this.delta = DifferencingResults.create(input, ndiff, mean);
        this.clear();
    }

    private void testResiduals(double[] res, TsFrequency freq) {
        TsData tmp = new TsData(freq, 2000, 0, res, false);
        this.delta = DifferencingResults.create(tmp, 0, false);
        this.clear();
    }

    public void setQSCount(int nqs) {
        if (nqs != this.nqs_) {
            this.nqs_ = nqs;
            this.qs = null;
        }
    }

    public int getQSCount() {
        return this.nqs_;
    }

    public DifferencingResults getDifferencing() {
        return this.delta;
    }

    public FriedmanTest getNonParametricTest() {
        if (this.nptest == null) {
            this.nptest = new FriedmanTest(this.delta.getDifferenced());
        }
        return this.nptest;
    }

    public TukeySpectrumPeaksTest getTukeyPeaks() {
        if (this.tpeaks == null) {
            this.tpeaks = new TukeySpectrumPeaksTest();
            if (!this.tpeaks.test(this.delta.getDifferenced())) {
                this.tpeaks = null;
            }
        }
        return this.tpeaks;
    }

    public BlackmanTukeySpectrum getBlackmanTukeySpectrum() {
        if (this.btSpectrum == null) {
            this.btSpectrum = new BlackmanTukeySpectrum();
            this.btSpectrum.setWindowType(WindowType.Tukey);
            this.btSpectrum.setData(this.delta.getDifferenced().internalStorage());
            int ifreq = this.delta.getDifferenced().getFrequency().intValue();
            int n = this.delta.getDifferenced().getLength();
            int wlen = 3 * n / 4 / ifreq;
            if (wlen > 11) {
                wlen = 11;
            }
            this.btSpectrum.setWindowLength(wlen * ifreq);
        }
        return this.btSpectrum;
    }

    public AutoRegressiveSpectrumTest getArPeaks() {
        if (this.arpeaks == null) {
            this.arpeaks = new AutoRegressiveSpectrumTest();
            TsData dlast = this.delta.getDifferenced();
            if (!this.arpeaks.test(dlast)) {
                this.arpeaks = null;
            }
        }
        return this.arpeaks;
    }

    public SpectralPeaks[] getSpectralPeaks() {
        if (this.peaks == null) {
            int ifreq = this.delta.getOriginal().getFrequency().intValue();
            AutoRegressiveSpectrumTest arPeaks = this.getArPeaks();
            TukeySpectrumPeaksTest tPeaks = this.getTukeyPeaks();
            if (arPeaks == null || tPeaks == null) {
                return null;
            }
            int[] a = arPeaks.seasonalPeaks(0.9, 0.99);
            int[] t = tPeaks.seasonalPeaks(0.9, 0.99);
            this.peaks = new SpectralPeaks[ifreq / 2];
            for (int i = 0; i < this.peaks.length; ++i) {
                SpectralPeaks.AR ar = SpectralPeaks.AR.none;
                SpectralPeaks.Tukey tu = SpectralPeaks.Tukey.none;
                if (a != null && a.length > i) {
                    ar = SpectralPeaks.AR.fromInt(a[i]);
                }
                if (t != null && t.length > i) {
                    tu = SpectralPeaks.Tukey.fromInt(t[i]);
                }
                this.peaks[i] = new SpectralPeaks(ar, tu);
            }
        }
        return this.peaks;
    }

    public StatisticalTest getQs() {
        if (this.qs == null) {
            this.qs = QSTest.compute(this.delta.getDifferenced().internalStorage(), this.delta.getDifferenced().getFrequency().intValue(), this.nqs_);
        }
        return this.qs;
    }

    public StatisticalTest getPeriodogramTest() {
        if (this.periodogram == null) {
            this.periodogram = PeriodogramTest.computeSum2(this.delta.getDifferenced(), this.delta.getDifferenced().getFrequency().intValue());
        }
        return this.periodogram;
    }

    public int getScore() {
        return this.score;
    }

    private void clear() {
        this.nptest = null;
        this.arpeaks = null;
        this.tpeaks = null;
        this.qs = null;
        this.periodogram = null;
        this.score = 0;
    }
}

