% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec.R
\name{specification}
\alias{specification}
\alias{s_estimate}
\alias{s_transform}
\alias{s_usrdef}
\alias{s_preOut}
\alias{s_preVar}
\alias{s_td}
\alias{s_easter}
\alias{s_out}
\alias{s_arima}
\alias{s_arimaCoef}
\alias{s_fcst}
\alias{s_span}
\alias{s_x11}
\alias{s_seats}
\title{Access a model specification, a SA or a pre-adjustment model in X13 and TRAMO-SEATS}
\usage{
s_estimate(object = NA)

s_transform(object = NA)

s_usrdef(object = NA)

s_preOut(object = NA)

s_preVar(object = NA)

s_td(object = NA)

s_easter(object = NA)

s_out(object = NA)

s_arima(object = NA)

s_arimaCoef(object = NA)

s_fcst(object = NA)

s_span(object = NA)

s_x11(object = NA)

s_seats(object = NA)
}
\arguments{
\item{object}{an object of one of the following classes: \code{c("SA","X13")},
\code{c("SA","TRAMO_SEATS")}, \code{c("SA_spec","X13")}, \code{c("SA_spec","TRAMO_SEATS")},
\code{c("regarima","X13")}, \code{c("regarima","TRAMO_SEATS")}, \code{c("regarima_spec","X13")},
\code{c("regarima_spec","TRAMO_SEATS")}.}
}
\value{
\itemize{
\item \code{s_estimate} returns a data.frame with the \emph{estimate} variables
\item \code{s_transform} returns a data.frame with the \emph{transform} variables
\item \code{s_usrdef} returns a data.frame with the \emph{user-defined regressors} (outliers and variables) model specification, indicating if those variables are included in the model and if coefficients are pre-specified
\item \code{s_preOut} returns a data.frame with the \emph{pre-specified outliers}
\item \code{s_preVar} returns a list with information on the user-defined variables, including: \code{series} - the time series and \code{description} - data.frame with the variable type and coefficients
\item \code{s_td} returns a data.frame with the \emph{trading.days} variables
\item \code{s_easter} returns a data.frame with the \emph{easter} variable
\item \code{s_out} returns a data.frame with the \emph{outliers} detection variables
\item \code{s_arima} returns a data.frame with the \emph{arima} variables
\item \code{s_arimaCoef} returns a data.frame with the user-specified ARMA coefficients
\item \code{s_fcst} returns a data.frame with the forecast horizon
\item \code{s_span} returns a data.frame with the \emph{span} variables
\item \code{s_x11} returns a data.frame with the \emph{x11} variables
\item \code{s_seats} returns a data.frame with the \emph{seats} variables
}
}
\description{
The following functions enable the access to different parts of the final model specification,
as included in the \code{"SA", "regarima", "SA_spec"} and \code{"regarima_spec"} S3 class objects.
}
\examples{
\donttest{
myseries <- ipi_c_eu[, "FR"]
myreg1 <- regarima_x13(myseries, spec = "RG5c")
myspec1 <- regarima_spec_x13(myreg1,
             estimate.from = "2005-10-01",
             outlier.from = "2010-03-01")

s_estimate(myreg1)
s_estimate(myspec1)

s_transform(myreg1)
s_transform(myspec1)

s_usrdef(myreg1)
s_usrdef(myspec1)

myspec2 <- regarima_spec_x13(myreg1, usrdef.outliersEnabled = TRUE,
             usrdef.outliersType = c("LS", "AO"),
             usrdef.outliersDate = c("2009-10-01", "2005-02-01"))
myreg2 <- regarima(myseries, myspec2)

s_preOut(myreg2)
s_preOut(myspec2)

var1 <- ts(rnorm(length(myseries))*10, start = start(myseries), frequency = 12)
var2 <- ts(rnorm(length(myseries))*100, start = start(myseries), frequency = 12)
var3 <- ts.union(var1, var2)
myspec3 <- regarima_spec_x13(spec = "RG5c",
                             usrdef.varEnabled = TRUE,
                             usrdef.var = var3)
myreg3 <- regarima(myseries, myspec3)

s_preVar(myspec3)
s_preVar(myreg3)

s_td(myreg1)
s_td(myspec1)

s_easter(myreg1)
s_easter(myspec1)

s_out(myreg1)
s_out(myspec1)

s_arima(myreg1)
s_arima(myspec1)

myspec4 <- regarima_spec_x13(myreg1, automdl.enabled = FALSE,
             arima.coefEnabled = TRUE,
             arima.p = 1,arima.q = 1, arima.bp = 1, arima.bq = 1,
             arima.coef = rep(0.2, 4),
             arima.coefType = rep("Initial", 4))
myreg4 <- regarima(myseries, myspec4)

s_arimaCoef(myreg4)
s_arimaCoef(myspec4)

s_fcst(myreg1)
s_fcst(myspec1)

s_span(myreg1)
s_span(myspec1)

myspec5 <- x13_spec(spec = "RSA5c", x11.seasonalComp = FALSE)
mysa5 <- x13(myseries, myspec5)

s_x11(mysa5)
s_x11(myspec5)

myspec6 <- tramoseats_spec(spec = "RSAfull", seats.approx = "Noisy")
mysa6 <- tramoseats(myseries, myspec6)

s_seats(mysa6)
s_seats(mysa6)
}
}
\references{
Info on 'JDemetra+', usage and functions:
\url{https://ec.europa.eu/eurostat/cros/content/documentation_en}
}
