/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.special;

import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.InformationSetSerializable;
import ec.tstoolkit.timeseries.calendars.TradingDaysType;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public class TradingDaysSpec
implements Cloneable,
InformationSetSerializable {
    public static final String TDOPTION = "option";
    public static final String LPOPTION = "leapyear";
    public static final String HOLIDAYS = "holidays";
    public static final String USER = "user";
    public static final String W = "stocktd";
    private String holidays_;
    private String[] users_;
    private TradingDaysType td_ = TradingDaysType.None;
    private boolean lp_;
    private int w_ = 0;

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item(prefix, TDOPTION), String.class);
        dic.put(InformationSet.item(prefix, LPOPTION), String.class);
        dic.put(InformationSet.item(prefix, USER), String[].class);
        dic.put(InformationSet.item(prefix, HOLIDAYS), String.class);
        dic.put(InformationSet.item(prefix, W), Integer.class);
    }

    public void reset() {
        this.holidays_ = null;
        this.users_ = null;
        this.td_ = TradingDaysType.None;
        this.lp_ = false;
        this.w_ = 0;
    }

    public TradingDaysType getTradingDaysType() {
        return this.td_;
    }

    public boolean isUsed() {
        return this.td_ != TradingDaysType.None || this.users_ != null || this.w_ != 0;
    }

    public void setTradingDaysType(TradingDaysType value) {
        this.td_ = value;
    }

    public boolean isLeapYear() {
        return this.lp_;
    }

    public void setLeapYear(boolean value) {
        this.lp_ = value;
    }

    public void setStockTradingDays(int w) {
        this.w_ = w;
    }

    public boolean isStockTradingDays() {
        return this.w_ > 0;
    }

    public int getStockTradingDays() {
        return this.w_;
    }

    public boolean isValid() {
        if (this.isStockTradingDays()) {
            return true;
        }
        if (this.td_ == TradingDaysType.None) {
            return !this.lp_;
        }
        return true;
    }

    public String getHolidays() {
        return this.holidays_;
    }

    public void setHolidays(String value) {
        this.holidays_ = value;
        if (this.holidays_ != null && this.holidays_.length() == 0) {
            this.holidays_ = null;
        }
        if (this.holidays_ != null) {
            this.users_ = null;
        }
    }

    public String[] getUserVariables() {
        return this.users_;
    }

    public void setUserVariables(String[] value) {
        this.users_ = value;
        if (this.users_ != null) {
            this.holidays_ = null;
            this.td_ = TradingDaysType.None;
            this.lp_ = false;
        }
    }

    public TradingDaysSpec clone() {
        try {
            TradingDaysSpec spec = (TradingDaysSpec)super.clone();
            if (this.users_ != null) {
                spec.users_ = (String[])this.users_.clone();
            }
            return spec;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof TradingDaysSpec && this.equals((TradingDaysSpec)obj);
    }

    private boolean equals(TradingDaysSpec other) {
        return Arrays.deepEquals(this.users_, other.users_) && Objects.equals(this.holidays_, other.holidays_) && this.w_ == other.w_ && this.td_ == other.td_ && this.lp_ == other.lp_;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode((Object)this.td_);
        hash = 97 * hash + (this.lp_ ? 1 : 0);
        return hash;
    }

    public void disable() {
        this.holidays_ = null;
        this.users_ = null;
        this.td_ = TradingDaysType.None;
        this.lp_ = false;
        this.w_ = 0;
    }

    @Override
    public InformationSet write(boolean verbose) {
        if (!verbose && !this.isUsed()) {
            return null;
        }
        InformationSet info = new InformationSet();
        if (verbose || this.td_ != TradingDaysType.None) {
            info.add(TDOPTION, this.td_.name());
        }
        if (verbose || this.lp_) {
            info.add(LPOPTION, Boolean.valueOf(this.lp_));
        }
        if (this.holidays_ != null) {
            info.add(HOLIDAYS, this.holidays_);
        }
        if (this.users_ != null) {
            info.add(USER, this.users_);
        }
        if (verbose || this.w_ != 0) {
            info.add(W, Integer.valueOf(this.w_));
        }
        return info;
    }

    @Override
    public boolean read(InformationSet info) {
        try {
            Boolean lp;
            this.reset();
            String td = info.get(TDOPTION, String.class);
            if (td != null) {
                this.td_ = TradingDaysType.valueOf(td);
            }
            if ((lp = info.get(LPOPTION, Boolean.class)) != null) {
                this.lp_ = lp;
            }
            this.holidays_ = info.get(HOLIDAYS, String.class);
            this.users_ = info.get(USER, String[].class);
            Integer w = info.get(W, Integer.class);
            if (w != null) {
                this.w_ = w;
            }
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }
}

