/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.polynomials;

import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.polynomials.IRootsSolver;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.polynomials.PolynomialException;

public class RationalFunction {
    private double[] m_c;
    private final Polynomial m_pn;
    private final Polynomial m_pd;
    public static final double EPSILON = 1.0E-12;
    private static final int g_atom = 32;

    public RationalFunction() {
        this.m_pn = Polynomial.ZERO;
        this.m_pd = Polynomial.ONE;
    }

    public RationalFunction(Polynomial pn, Polynomial pd) {
        this.m_pn = pn;
        this.m_pd = pd;
    }

    public double[] coefficients(int n) {
        this.prepare(n - 1);
        double[] rslt = new double[n];
        int nmin = n > this.m_c.length ? this.m_c.length : n;
        for (int i = 0; i < nmin; ++i) {
            rslt[i] = this.m_c[i];
        }
        return rslt;
    }

    public RationalFunction divide(RationalFunction r2) {
        return new RationalFunction(this.m_pn.times(r2.m_pd), this.m_pd.times(r2.m_pn));
    }

    public RationalFunction drop(int n) {
        int qc;
        int i;
        int p;
        Polynomial cn = this.m_pn;
        Polynomial cd = this.m_pd;
        int q = p = cd.getDegree() + 1;
        if (cn.getDegree() + 1 - n > q) {
            q = cn.getDegree() + 1 - n;
        }
        if (q == 0) {
            return new RationalFunction();
        }
        double[] phi = new double[q];
        double[] ntmp = new double[q];
        for (i = 0; i < q; ++i) {
            phi[i] = this.get(i + n);
        }
        ntmp[0] = phi[0] * cd.get(0);
        for (i = 1; i < q; ++i) {
            double s = 0.0;
            int imax = i < q ? i : q - 1;
            for (int j = 0; j <= imax; ++j) {
                int k = i - j;
                if (k >= p) continue;
                s += cd.get(k) * phi[j];
            }
            if (Math.abs(s) < 1.0E-12) {
                s = 0.0;
            }
            ntmp[i] = s;
        }
        for (qc = q; qc > 0 && ntmp[qc - 1] == 0.0; --qc) {
        }
        if (qc == 0) {
            return new RationalFunction();
        }
        if (qc != q) {
            double[] ntmp2 = new double[qc];
            for (int i2 = 0; i2 < qc; ++i2) {
                ntmp2[i2] = ntmp[i2];
            }
            ntmp = ntmp2;
        }
        return new RationalFunction(Polynomial.of(ntmp), cd);
    }

    public Complex evaluateAt(Complex c) {
        Complex nx = this.m_pn.evaluateAt(c);
        Complex dx = this.m_pd.evaluateAt(c);
        if (dx.minus(Complex.cart(0.0)).abs() <= 1.0E-12) {
            throw new PolynomialException("rf_err_pole");
        }
        return nx.div(dx);
    }

    public double evaluateAt(double x) {
        double nx = this.m_pn.evaluateAt(x);
        double dx = this.m_pd.evaluateAt(x);
        if (Math.abs(dx - 0.0) <= 1.0E-12) {
            throw new PolynomialException("rf_err_pole");
        }
        return nx / dx;
    }

    public double get(int k) {
        this.prepare(k);
        return k >= this.m_c.length ? 0.0 : this.m_c[k];
    }

    public Polynomial getDenominator() {
        return this.m_pd;
    }

    public Polynomial getNumerator() {
        return this.m_pn;
    }

    public boolean isFinite() {
        return this.m_pd.getDegree() == 0;
    }

    public RationalFunction minus(RationalFunction r2) {
        Polynomial pn = this.m_pn.times(r2.m_pd).minus(this.m_pd.times(r2.m_pn));
        Polynomial pd = this.m_pd.times(r2.m_pd);
        return new RationalFunction(pn, pd);
    }

    public RationalFunction plus(RationalFunction r2) {
        Polynomial pn = this.m_pn.times(r2.m_pd).plus(this.m_pd.times(r2.m_pn));
        Polynomial pd = this.m_pd.times(r2.m_pd);
        return new RationalFunction(pn, pd);
    }

    public Complex[] poles() {
        return this.m_pd.roots();
    }

    public Complex[] poles(IRootsSolver searcher) {
        return this.m_pd.roots(searcher);
    }

    public void prepare(int degree) {
        int w;
        if (this.m_c != null && this.m_c.length > degree) {
            return;
        }
        Polynomial pd = this.m_pd;
        Polynomial pn = this.m_pn;
        int k0 = 1;
        int p = pd.getDegree();
        int q = pn.getDegree();
        double d = pd.get(0);
        if (p == 0) {
            this.m_c = pn.getCoefficients();
            if (d != 1.0) {
                int i = 0;
                while (i < this.m_c.length) {
                    int n = i++;
                    this.m_c[n] = this.m_c[n] / d;
                }
            }
            return;
        }
        int r = p < q ? q : p;
        degree = degree < r ? r : ((degree - 1) / 32 + 1) * 32;
        if (this.m_c == null) {
            double s;
            int k;
            this.m_c = new double[degree + 1];
            this.m_c[0] = pn.get(0) / d;
            for (k = k0; k <= p; ++k) {
                s = 0.0;
                for (w = 1; w <= k; ++w) {
                    s += pd.get(w) * this.m_c[k - w];
                }
                this.m_c[k] = k <= q ? (pn.get(k) - s) / d : -s / d;
            }
            if (q > p) {
                for (k = p + 1; k <= q; ++k) {
                    s = 0.0;
                    for (w = 1; w <= p; ++w) {
                        s += pd.get(w) * this.m_c[k - w];
                    }
                    this.m_c[k] = (pn.get(k) - s) / pd.get(0);
                }
            }
            k0 = r + 1;
        } else {
            double[] tmp = new double[degree + 1];
            for (double tmp[u] : this.m_c) {
            }
            this.m_c = tmp;
        }
        for (int k = k0; k <= degree; ++k) {
            double s = 0.0;
            for (w = 1; w <= p; ++w) {
                s += pd.get(w) * this.m_c[k - w];
            }
            this.m_c[k] = -s / d;
        }
    }

    public Complex[] roots() {
        return this.m_pn.roots();
    }

    public Complex[] roots(IRootsSolver searcher) {
        return this.m_pn.roots(searcher);
    }

    public RationalFunction times(RationalFunction r2) {
        return new RationalFunction(this.m_pn.times(r2.m_pn), this.m_pd.times(r2.m_pd));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("[");
        sb.append(this.m_pn.toString());
        sb.append("]/[");
        sb.append(this.m_pd.toString());
        sb.append("]");
        return sb.toString();
    }
}

