/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.structural;

import ec.tstoolkit.Parameter;
import ec.tstoolkit.data.IDataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.data.ReadDataBlock;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.maths.realfunctions.ParamValidation;
import ec.tstoolkit.structural.BasicStructuralModel;
import ec.tstoolkit.structural.Component;
import ec.tstoolkit.structural.ComponentUse;
import ec.tstoolkit.structural.ModelSpecification;

public class BsmMapper
implements IParametricMapping<BasicStructuralModel> {
    static final double STEP = 1.0E-6;
    static final double STEP2 = 1.0E-4;
    private static double RMIN = 0.0;
    private static double RMAX = 0.999;
    private static double RDEF = 0.5;
    private static double PMIN = 0.25;
    private static double PMAX = 2.5;
    private static double PDEF = 1.0;
    private Component cFixed = Component.Undefined;
    public final Transformation transformation;
    public final ModelSpecification spec;
    public final int freq;

    public BsmMapper(ModelSpecification spec, int freq) {
        this.transformation = Transformation.Square;
        this.spec = spec;
        this.freq = freq;
    }

    public BsmMapper(ModelSpecification spec, int freq, Transformation tr) {
        this.transformation = tr;
        this.spec = spec;
        this.freq = freq;
    }

    public int getVarsCount() {
        int n = 0;
        if (this._hasLevel()) {
            ++n;
        }
        if (this._hasSlope()) {
            ++n;
        }
        if (this._hasSeas()) {
            ++n;
        }
        if (this._hasCycle()) {
            ++n;
        }
        if (this._hasNoise()) {
            ++n;
        }
        return n;
    }

    public boolean hasCycleDumpingFactor() {
        return this.spec.cUse != ComponentUse.Unused && (this.spec.getCyclicalDumpingFactor() == null || !this.spec.getCyclicalDumpingFactor().isFixed());
    }

    public boolean hasCycleLength() {
        return this.spec.cUse != ComponentUse.Unused && (this.spec.getCyclicalPeriod() == null || !this.spec.getCyclicalPeriod().isFixed());
    }

    boolean _hasLevel() {
        return this.spec.lUse == ComponentUse.Free && this.cFixed != Component.Level;
    }

    int _pCycle() {
        if (this.spec.cUse == ComponentUse.Unused) {
            return 0;
        }
        int n = 0;
        Parameter p = this.spec.getCyclicalDumpingFactor();
        if (p == null || !p.isFixed()) {
            ++n;
        }
        if ((p = this.spec.getCyclicalPeriod()) == null || !p.isFixed()) {
            ++n;
        }
        return n;
    }

    boolean _hasCycle() {
        return this.spec.cUse == ComponentUse.Free && this.cFixed != Component.Cycle;
    }

    boolean _hasNoise() {
        return this.spec.nUse == ComponentUse.Free && this.cFixed != Component.Noise;
    }

    boolean _hasSeas() {
        return this.spec.getSeasUse() == ComponentUse.Free && this.cFixed != Component.Seasonal;
    }

    boolean _hasSlope() {
        return this.spec.sUse == ComponentUse.Free && this.cFixed != Component.Slope;
    }

    @Override
    public boolean checkBoundaries(IReadDataBlock p) {
        int i;
        int pc = this._pCycle();
        int nvar = p.getLength() - pc;
        if (this.transformation == Transformation.None) {
            for (i = 0; i < nvar; ++i) {
                if (!(p.get(i) <= 0.0)) continue;
                return false;
            }
        } else if (this.transformation == Transformation.Square) {
            for (i = 0; i < nvar; ++i) {
                if (!(p.get(i) < -0.1) && !(p.get(i) > 10.0)) continue;
                return false;
            }
        }
        if (pc > 0) {
            double period;
            double rho;
            if (this.hasCycleDumpingFactor() && ((rho = p.get(nvar++)) < RMIN || rho > RMAX)) {
                return false;
            }
            if (this.hasCycleLength() && ((period = p.get(nvar)) < PMIN || period > PMAX)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public double epsilon(IReadDataBlock p, int idx) {
        int pc = this._pCycle();
        int nvar = p.getLength() - pc;
        if (idx < nvar) {
            double x = p.get(idx);
            if (x < 0.5) {
                return 1.0E-6;
            }
            return -1.0E-6;
        }
        if (idx == nvar && this.hasCycleDumpingFactor()) {
            double x = p.get(idx);
            if (x < 0.5) {
                return 1.0E-6;
            }
            return -1.0E-6;
        }
        double x = p.get(idx);
        if (x < 1.0) {
            return 1.0E-4;
        }
        return -1.0E-4;
    }

    public Component getComponent(int idx) {
        int cur = idx;
        if (this._hasLevel()) {
            if (cur == 0) {
                return Component.Level;
            }
            --cur;
        }
        if (this._hasSlope()) {
            if (cur == 0) {
                return Component.Slope;
            }
            --cur;
        }
        if (this._hasSeas()) {
            if (cur == 0) {
                return Component.Seasonal;
            }
            --cur;
        }
        if (this._hasNoise()) {
            if (cur == 0) {
                return Component.Noise;
            }
            --cur;
        }
        if (this._hasCycle() && cur == 0) {
            return Component.Cycle;
        }
        return Component.Undefined;
    }

    @Override
    public int getDim() {
        int n = 0;
        if (this._hasLevel()) {
            ++n;
        }
        if (this._hasSlope()) {
            ++n;
        }
        if (this._hasSeas()) {
            ++n;
        }
        if (this._hasNoise()) {
            ++n;
        }
        if (this._hasCycle()) {
            ++n;
        }
        return n + this._pCycle();
    }

    public Component getFixedComponent() {
        return this.cFixed;
    }

    private double inparam(double d) {
        switch (this.transformation) {
            case None: {
                return d;
            }
            case Square: {
                return d * d;
            }
        }
        return Math.exp(2.0 * d);
    }

    @Override
    public double lbound(int idx) {
        return this.transformation == Transformation.None ? 0.0 : Double.NEGATIVE_INFINITY;
    }

    @Override
    public IReadDataBlock map(BasicStructuralModel t) {
        double[] p = new double[this.getDim()];
        int idx = 0;
        if (this._hasLevel()) {
            p[idx++] = this.outparam(t.lVar);
        }
        if (this._hasSlope()) {
            p[idx++] = this.outparam(t.sVar);
        }
        if (this._hasSeas()) {
            p[idx++] = this.outparam(t.seasVar);
        }
        if (this._hasNoise()) {
            p[idx++] = this.outparam(t.nVar);
        }
        if (this._hasCycle()) {
            p[idx++] = this.outparam(t.cVar);
        }
        if (this.spec.cUse != ComponentUse.Unused) {
            Parameter pm = this.spec.getCyclicalDumpingFactor();
            if (pm == null || !pm.isFixed()) {
                p[idx++] = t.getCyclicalDumpingFactor();
            }
            if ((pm = this.spec.getCyclicalPeriod()) == null || !pm.isFixed()) {
                p[idx++] = t.getCyclicalPeriod() / (double)(6 * this.freq);
            }
        }
        return new ReadDataBlock(p);
    }

    @Override
    public BasicStructuralModel map(IReadDataBlock p) {
        BasicStructuralModel t = new BasicStructuralModel(this.spec, this.freq);
        int idx = 0;
        if (this._hasLevel()) {
            t.lVar = this.inparam(p.get(idx++));
        }
        if (this._hasSlope()) {
            t.sVar = this.inparam(p.get(idx++));
        }
        if (this._hasSeas()) {
            t.seasVar = this.inparam(p.get(idx++));
        }
        if (this._hasNoise()) {
            t.nVar = this.inparam(p.get(idx++));
        }
        if (this._hasCycle()) {
            t.cVar = this.inparam(p.get(idx++));
        }
        if (this.spec.cUse != ComponentUse.Unused) {
            Parameter pm = this.spec.getCyclicalDumpingFactor();
            double cdump = pm == null || !pm.isFixed() ? p.get(idx++) : pm.getValue();
            pm = this.spec.getCyclicalPeriod();
            double clen = pm == null || !pm.isFixed() ? (double)(6 * this.freq) * p.get(idx) : (double)this.freq * pm.getValue();
            t.setCycle(cdump, clen);
        }
        if (this.cFixed != Component.Undefined) {
            t.setVariance(this.cFixed, 1.0);
        }
        return t;
    }

    private double outparam(double d) {
        switch (this.transformation) {
            case None: {
                return d;
            }
            case Square: {
                return d <= 0.0 ? 0.0 : Math.sqrt(d);
            }
        }
        return 0.5 * Math.log(d);
    }

    public void setFixedComponent(Component value) {
        this.cFixed = value;
    }

    @Override
    public double ubound(int idx) {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public ParamValidation validate(IDataBlock ioparams) {
        int i;
        ParamValidation status = ParamValidation.Valid;
        if (ioparams.getLength() == 0) {
            return ParamValidation.Valid;
        }
        int pc = this._pCycle();
        int nvar = ioparams.getLength() - pc;
        if (this.transformation == Transformation.Square) {
            for (i = 0; i < nvar; ++i) {
                if (ioparams.get(i) > 10.0) {
                    ioparams.set(i, 10.0);
                    status = ParamValidation.Changed;
                    continue;
                }
                if (!(ioparams.get(i) < -0.1)) continue;
                ioparams.set(i, Math.min(10.0, -ioparams.get(i)));
                status = ParamValidation.Changed;
            }
        } else if (this.transformation == Transformation.None) {
            for (i = 0; i < nvar; ++i) {
                if (!(ioparams.get(i) < 1.0E-9)) continue;
                ioparams.set(i, 1.0E-9);
                status = ParamValidation.Changed;
            }
        }
        if (pc > 0) {
            if (this.hasCycleDumpingFactor()) {
                double rho = ioparams.get(nvar);
                if (rho < RMIN) {
                    ioparams.set(nvar, 0.1);
                    status = ParamValidation.Changed;
                }
                if (rho > RMAX) {
                    ioparams.set(nvar, 0.9);
                    status = ParamValidation.Changed;
                }
                ++nvar;
            }
            if (this.hasCycleLength()) {
                double p = ioparams.get(nvar);
                if (p < PMIN) {
                    ioparams.set(nvar, PMIN);
                    status = ParamValidation.Changed;
                }
                if (p > PMAX) {
                    ioparams.set(nvar, PMAX);
                    status = ParamValidation.Changed;
                }
            }
        }
        return status;
    }

    @Override
    public String getDescription(int idx) {
        int n = this.getVarsCount();
        if (idx < n) {
            return this.getComponent(idx).name() + " var.";
        }
        if (idx == n && this.hasCycleDumpingFactor()) {
            return "Cycle dumping factor";
        }
        return "Cycle length";
    }

    public static enum Transformation {
        None,
        Exp,
        Square;

    }
}

