/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.calendars;

import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.timeseries.calendars.ChainedGregorianCalendarProvider;
import ec.tstoolkit.timeseries.calendars.CompositeGregorianCalendarProvider;
import ec.tstoolkit.timeseries.calendars.DefaultGregorianCalendarProvider;
import ec.tstoolkit.timeseries.calendars.IGregorianCalendarProvider;
import ec.tstoolkit.timeseries.calendars.NationalCalendarProvider;
import ec.tstoolkit.utilities.DefinitionMap;
import ec.tstoolkit.utilities.NameManager;
import ec.tstoolkit.utilities.WeightedItem;
import java.util.HashMap;
import java.util.Map;

public class GregorianCalendarManager
extends NameManager<IGregorianCalendarProvider> {
    public static final String DEF = "Default";
    public static final String CAL = "Calendar_";
    private static final DefaultGregorianCalendarProvider def_ = new DefaultGregorianCalendarProvider();

    public GregorianCalendarManager() {
        super(IGregorianCalendarProvider.class, CAL, null);
        this.set(DEF, def_);
        this.resetDirty();
        this.lock(DEF);
    }

    public static IGregorianCalendarProvider getDefault(String name) {
        if (name.equals(DEF)) {
            return def_;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.getCount() <= 1;
    }

    public static DefinitionMap defaultDefinitionMap(String code, HashMap<IGregorianCalendarProvider, String> dic) {
        return ProcessingContext.getActiveContext().getGregorianCalendars().buildDefinitionMap(code, dic);
    }

    public DefinitionMap buildDefinitionMap(String code, HashMap<IGregorianCalendarProvider, String> dic) {
        DefinitionMap map = new DefinitionMap(code);
        String[] calendars = this.getNames();
        for (String s : calendars) {
            dic.put((IGregorianCalendarProvider)this.get(s), s);
        }
        for (Map.Entry entry : dic.entrySet()) {
            if (entry.getKey() instanceof NationalCalendarProvider) {
                map.add((String)entry.getValue(), null);
                continue;
            }
            if (entry.getKey() instanceof ChainedGregorianCalendarProvider) {
                ChainedGregorianCalendarProvider cc = (ChainedGregorianCalendarProvider)entry.getKey();
                map.add((String)entry.getValue(), new String[]{cc.first, cc.second});
                continue;
            }
            if (!(entry.getKey() instanceof CompositeGregorianCalendarProvider)) continue;
            CompositeGregorianCalendarProvider wc = (CompositeGregorianCalendarProvider)entry.getKey();
            String[] w = new String[wc.getCount()];
            int i = 0;
            for (WeightedItem wi : wc.items()) {
                w[i++] = (String)wi.item;
            }
            map.add((String)entry.getValue(), w);
        }
        return map;
    }
}

