/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.estimation;

import ec.tstoolkit.eco.ILikelihood;
import java.util.Formatter;

public class LikelihoodStatistics {
    public int observationsCount;
    public int missingCount;
    public int effectiveObservationsCount;
    public int estimatedParametersCount;
    public double logLikelihood;
    public double transformationAdjustment;
    public double adjustedLogLikelihood;
    public double AIC;
    public double AICC;
    public double BIC;
    public double BICC;
    public double BIC2;
    public double HannanQuinn;
    public double SsqErr;

    public static LikelihoodStatistics create(ILikelihood ll, int nobs, int nparams, double adj) {
        LikelihoodStatistics stats = new LikelihoodStatistics();
        stats.effectiveObservationsCount = stats.observationsCount = nobs;
        stats.logLikelihood = ll.getLogLikelihood();
        stats.estimatedParametersCount = nobs - ll.getResiduals().length + nparams + 1;
        if (Double.isNaN(adj)) {
            adj = 0.0;
        }
        stats.transformationAdjustment = adj;
        stats.adjustedLogLikelihood = adj == 0.0 ? stats.logLikelihood : stats.logLikelihood + stats.transformationAdjustment;
        stats.SsqErr = ll.getSsqErr();
        stats.calc();
        return stats;
    }

    public void calc() {
        double n = this.effectiveObservationsCount;
        double np = this.estimatedParametersCount;
        double ll = this.adjustedLogLikelihood;
        double nll = this.logLikelihood;
        this.AIC = -2.0 * (ll - np);
        this.HannanQuinn = -2.0 * (ll - np * Math.log(Math.log(n)));
        this.AICC = -2.0 * (ll - n * np / (n - np - 1.0));
        this.BIC = -2.0 * ll + np * Math.log(n);
        this.BIC2 = (-2.0 * nll + np * Math.log(n)) / n;
        this.BICC = Math.log(this.SsqErr / n) + (np - 1.0) * Math.log(n) / n;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Number of observations :").append(this.observationsCount).append(System.lineSeparator());
        builder.append("Number of missing values :").append(this.missingCount).append(System.lineSeparator());
        builder.append("Effective number of observations :").append(this.effectiveObservationsCount).append(System.lineSeparator());
        builder.append("Number of parameters estimated :").append(this.estimatedParametersCount).append(System.lineSeparator());
        Formatter fmt = new Formatter();
        builder.append("log likelihood :").append(fmt.format("%.4f", this.logLikelihood)).append(System.lineSeparator());
        if (!Double.isNaN(this.transformationAdjustment)) {
            fmt = new Formatter();
            builder.append("Transformation Adjustment :").append(fmt.format("%.4f", this.transformationAdjustment)).append(System.lineSeparator());
            fmt = new Formatter();
            builder.append("Adjusted log likelihood :").append(fmt.format("%.4f", this.adjustedLogLikelihood)).append(System.lineSeparator());
        }
        fmt = new Formatter();
        builder.append("AIC :").append(fmt.format("%.4f", this.AIC)).append(System.lineSeparator());
        fmt = new Formatter();
        builder.append("BIC corrected for length :").append(fmt.format("%.4f", this.BICC));
        return builder.toString();
    }

    public void adjustForMissing(int nmissing) {
        if (this.missingCount > 0 || nmissing == 0) {
            return;
        }
        this.missingCount = nmissing;
        this.observationsCount -= this.missingCount;
        this.effectiveObservationsCount -= this.missingCount;
        this.estimatedParametersCount -= this.missingCount;
    }
}

