/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.structural;

import ec.tstoolkit.data.AbsMeanNormalizer;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.data.ReadDataBlock;
import ec.tstoolkit.eco.DiffuseConcentratedLikelihood;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.realfunctions.IFunction;
import ec.tstoolkit.maths.realfunctions.IFunctionInstance;
import ec.tstoolkit.maths.realfunctions.IFunctionMinimizer;
import ec.tstoolkit.maths.realfunctions.ProxyMinimizer;
import ec.tstoolkit.maths.realfunctions.TransformedFunction;
import ec.tstoolkit.maths.realfunctions.bfgs.Bfgs;
import ec.tstoolkit.maths.realfunctions.levmar.LevenbergMarquardtMethod;
import ec.tstoolkit.maths.realfunctions.minpack.LevenbergMarquardtMinimizer;
import ec.tstoolkit.ssf.FastSsfAlgorithm;
import ec.tstoolkit.ssf.SsfData;
import ec.tstoolkit.ssf.SsfFunction;
import ec.tstoolkit.ssf.SsfFunctionInstance;
import ec.tstoolkit.ssf.SsfModel;
import ec.tstoolkit.structural.BasicStructuralModel;
import ec.tstoolkit.structural.BsmMapper;
import ec.tstoolkit.structural.BsmSpecification;
import ec.tstoolkit.structural.Component;
import ec.tstoolkit.structural.ModelSpecification;

public class BsmMonitor {
    private SubMatrix m_x;
    private double[] m_y;
    private ModelSpecification m_spec = new ModelSpecification();
    private int m_freq = 1;
    private BsmMapper m_mapper;
    private BasicStructuralModel m_bsm;
    private double m_eps = 1.0E-9;
    private boolean m_bconverged = false;
    private boolean m_dregs;
    private IFunctionMinimizer m_min = null;
    private double m_dsmall = 0.01;
    private DiffuseConcentratedLikelihood m_ll;
    private SsfFunction<BasicStructuralModel> fn_;
    private SsfFunctionInstance<BasicStructuralModel> fnmax_;
    private double m_factor;

    private boolean _estimate() {
        IReadDataBlock parameters;
        IFunctionMinimizer fmin;
        this.m_bconverged = false;
        if (this.m_bsm == null) {
            this.m_bsm = this.initialize();
        }
        if (this.m_mapper.getDim() == 0) {
            return true;
        }
        this.fn_ = null;
        this.fnmax_ = null;
        if (this.m_min != null) {
            fmin = this.m_min.exemplar();
        } else {
            fmin = new ProxyMinimizer(new LevenbergMarquardtMethod());
            fmin.setConvergenceCriterion(this.m_eps);
        }
        fmin.setMaxIter(10);
        for (int i = 0; i < 3; ++i) {
            this.fn_ = this.buildFunction(this.m_bsm, null, true);
            parameters = this.m_mapper.map(this.m_bsm);
            fmin.minimize(this.fn_, this.fn_.evaluate(parameters));
            this.m_bconverged = fmin.getIterCount() < fmin.getMaxIter();
            this.fnmax_ = (SsfFunctionInstance)fmin.getResult();
            this.m_bsm = (BasicStructuralModel)this.fnmax_.ssf;
            this.m_ll = this.fnmax_.getLikelihood();
            Component cmp = this.m_bsm.fixMaxVariance(1.0);
            if (cmp == this.m_mapper.getFixedComponent()) break;
            this.m_mapper.setFixedComponent(cmp);
        }
        if (!this.m_bconverged) {
            fmin.setMaxIter(30);
            this.fn_ = this.buildFunction(this.m_bsm, null, true);
            IReadDataBlock parameters2 = this.m_mapper.map(this.m_bsm);
            fmin.minimize(this.fn_, this.fn_.evaluate(parameters2));
            this.m_bconverged = fmin.getIterCount() < fmin.getMaxIter();
            this.fnmax_ = (SsfFunctionInstance)fmin.getResult();
            this.m_bsm = (BasicStructuralModel)this.fnmax_.ssf;
            this.m_ll = this.fnmax_.getLikelihood();
            Component cmp = this.m_bsm.fixMaxVariance(1.0);
            if (cmp != this.m_mapper.getFixedComponent()) {
                this.m_mapper.setFixedComponent(cmp);
            }
        }
        boolean ok = this.m_bconverged;
        if (this.fixsmallvariance(this.m_bsm)) {
            this.updateSpec(this.m_bsm);
            this.fn_ = this.buildFunction(this.m_bsm, null, true);
            parameters = this.m_mapper.map(this.m_bsm);
            this.fnmax_ = (SsfFunctionInstance)this.fn_.evaluate(parameters);
            this.m_ll = this.fnmax_.getLikelihood();
            ok = false;
        }
        if (this.m_factor != 1.0) {
            this.m_ll.rescale(this.m_factor);
        }
        return ok;
    }

    private SsfFunction<BasicStructuralModel> buildFunction(BasicStructuralModel bsm, BsmMapper mapper, boolean ssq) {
        SsfData data = new SsfData(this.m_y, null);
        SsfModel<BasicStructuralModel> model = new SsfModel<BasicStructuralModel>(bsm, data, this.m_x, this.diffuseItems());
        FastSsfAlgorithm alg = new FastSsfAlgorithm();
        alg.useSsq(ssq);
        SsfFunction<BasicStructuralModel> eval = new SsfFunction<BasicStructuralModel>(model, mapper == null ? this.m_mapper : mapper, alg);
        return eval;
    }

    private int[] diffuseItems() {
        int[] idiffuse = null;
        if (this.m_x != null && this.m_dregs) {
            idiffuse = new int[this.m_x.getColumnsCount()];
            for (int i = 0; i < idiffuse.length; ++i) {
                idiffuse[i] = i;
            }
        }
        return idiffuse;
    }

    private boolean estimate() {
        for (int i = 0; i < 4; ++i) {
            if (!this._estimate()) continue;
            return true;
        }
        return true;
    }

    private boolean fixsmallvariance(BasicStructuralModel model) {
        double vmin = this.m_dsmall;
        int imin = -1;
        BsmMapper mapper = new BsmMapper(model.getSpecification(), this.m_freq, BsmMapper.Transformation.None);
        mapper.setFixedComponent(this.m_mapper.getFixedComponent());
        SsfFunction<BasicStructuralModel> fn = this.buildFunction(model.clone(), mapper, true);
        IReadDataBlock p = mapper.map(model);
        SsfFunctionInstance<BasicStructuralModel> instance = new SsfFunctionInstance<BasicStructuralModel>(fn, p);
        double ll = instance.getLikelihood().getLogLikelihood();
        int nvar = mapper.getVarsCount();
        for (int i = 0; i < nvar; ++i) {
            if (!(p.get(i) < 0.01)) continue;
            DataBlock np = new DataBlock(p);
            np.set(i, 0.0);
            instance = new SsfFunctionInstance<BasicStructuralModel>(fn, np);
            double llcur = instance.getLikelihood().getLogLikelihood();
            double v = 2.0 * (ll - llcur);
            if (!(v < vmin)) continue;
            vmin = v;
            imin = i;
        }
        if (imin < 0) {
            return false;
        }
        Component cmp = mapper.getComponent(imin);
        model.setVariance(cmp, 0.0);
        this.m_spec.fixComponent(cmp);
        return true;
    }

    public DiffuseConcentratedLikelihood getLikelihood() {
        return this.m_ll;
    }

    public double getLRatioForSmallVariance() {
        return this.m_dsmall;
    }

    public double getPrecision() {
        return this.m_eps;
    }

    public BasicStructuralModel getResult() {
        if (this.m_bsm == null && this.m_y != null) {
            this.estimate();
        }
        return this.m_bsm;
    }

    public ModelSpecification getSpecification() {
        return this.m_spec;
    }

    public boolean hasConverged() {
        return this.m_bconverged;
    }

    private BasicStructuralModel initialize() {
        DataBlock np;
        this.m_mapper = new BsmMapper(this.m_spec, this.m_freq);
        BasicStructuralModel start = new BasicStructuralModel(this.m_spec, this.m_freq);
        if (this.m_mapper.getDim() == 1) {
            this.m_mapper.setFixedComponent(this.m_mapper.getComponent(0));
            return start;
        }
        BsmMapper mapper = new BsmMapper(this.m_spec, this.m_freq, BsmMapper.Transformation.None);
        SsfFunction<BasicStructuralModel> fn = this.buildFunction(start, mapper, true);
        SsfFunctionInstance<BasicStructuralModel> instance = new SsfFunctionInstance<BasicStructuralModel>(fn, null);
        double lmax = instance.getLikelihood().getLogLikelihood();
        IReadDataBlock p = fn.mapper.map(fn.model.ssf);
        int imax = -1;
        int nvars = mapper.getVarsCount();
        for (int i = 0; i < nvars; ++i) {
            double nll;
            np = new DataBlock(p);
            np.set(0.5);
            np.set(i, 1.0);
            int ncur = nvars;
            if (mapper.hasCycleDumpingFactor()) {
                np.set(ncur++, 0.9);
            }
            if (mapper.hasCycleLength()) {
                np.set(ncur, 1.0);
            }
            if (!((nll = (instance = new SsfFunctionInstance<BasicStructuralModel>(fn, np)).getLikelihood().getLogLikelihood()) > lmax)) continue;
            lmax = nll;
            imax = i;
        }
        if (imax < 0) {
            if (this.m_spec.hasNoise()) {
                this.m_mapper.setFixedComponent(Component.Noise);
            } else if (this.m_spec.hasLevel()) {
                this.m_mapper.setFixedComponent(Component.Level);
            } else {
                this.m_mapper.setFixedComponent(this.m_mapper.getComponent(0));
            }
            return start;
        }
        Component cmp = mapper.getComponent(imax);
        this.m_mapper.setFixedComponent(cmp);
        np = new DataBlock(p);
        np.set(0.1);
        np.set(imax, 1.0);
        if (mapper.hasCycleDumpingFactor()) {
            np.set(nvars++, 0.9);
        }
        if (mapper.hasCycleLength()) {
            np.set(nvars, 1.0);
        }
        return mapper.map(np);
    }

    public boolean isUsingDiffuseRegressors() {
        return this.m_dregs;
    }

    public boolean process(double[] y, int freq) {
        return this.process(y, null, freq);
    }

    public boolean process(double[] y, SubMatrix x, int freq) {
        AbsMeanNormalizer normalizer = new AbsMeanNormalizer();
        normalizer.process(new ReadDataBlock(y));
        this.m_y = normalizer.getNormalizedData();
        this.m_factor = normalizer.getFactor();
        this.m_x = x;
        this.m_freq = freq;
        boolean rslt = this.estimate();
        return rslt;
    }

    public void setLRatioForSmallVariance(double value) {
        this.m_dsmall = value;
    }

    public void setPrecision(double value) {
        this.m_eps = value;
    }

    public void setSpecification(BsmSpecification spec) {
        this.m_spec = spec.getModelSpecification().clone();
        this.m_eps = spec.getPrecision();
        this.m_dregs = spec.isDiffuseRegressors();
        switch (spec.getOptimizer()) {
            case LevenbergMarquardt: {
                this.m_min = new ProxyMinimizer(new LevenbergMarquardtMethod());
                break;
            }
            case MinPack: {
                this.m_min = new ProxyMinimizer(new LevenbergMarquardtMinimizer());
                break;
            }
            case LBFGS: {
                this.m_min = new Bfgs();
                break;
            }
            default: {
                this.m_min = null;
            }
        }
        this.m_bsm = null;
    }

    public void setSpecification(ModelSpecification spec) {
        this.m_spec = spec.clone();
        this.m_bsm = null;
    }

    private void updateSpec(BasicStructuralModel bsm) {
        this.m_spec = bsm.getSpecification();
        Component fixed = this.m_mapper.getFixedComponent();
        this.m_mapper = new BsmMapper(this.m_spec, this.m_freq, this.m_mapper.transformation);
        this.m_mapper.setFixedComponent(fixed);
    }

    public void useDiffuseRegressors(boolean value) {
        this.m_dregs = value;
    }

    public IFunction likelihoodFunction() {
        BsmMapper mapper = new BsmMapper(this.m_bsm.getSpecification(), this.m_bsm.freq, BsmMapper.Transformation.None);
        SsfFunction<BasicStructuralModel> fn = this.buildFunction(this.m_bsm, mapper, false);
        double a = (double)(this.m_ll.getN() - this.m_ll.getD()) * Math.log(this.m_factor);
        return new TransformedFunction(fn, TransformedFunction.linearTransformation(-a, 1.0));
    }

    public IFunctionInstance maxLikelihoodFunction() {
        BsmMapper mapper = new BsmMapper(this.m_bsm.getSpecification(), this.m_bsm.freq, BsmMapper.Transformation.None);
        IFunction ll = this.likelihoodFunction();
        return ll.evaluate(mapper.map(this.m_bsm));
    }
}

