/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.api;

import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.SdmxException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.table.DefaultTableModel;

public class PortableDataSet {
    private String TIME_LABEL = "TIME_PERIOD";
    private String OBS_LABEL = "OBS_VALUE";
    private String ID_LABEL = "ID";
    private static final String sourceClass = PortableDataSet.class.getSimpleName();
    protected static Logger logger = Configuration.getSdmxLogger();
    private DefaultTableModel model = new DefaultTableModel();

    public PortableDataSet() {
        this.model.addColumn(this.TIME_LABEL);
        this.model.addColumn(this.OBS_LABEL);
    }

    public PortableDataSet(List<PortableTimeSeries> list) throws SdmxException {
        this();
        this.putTimeSeries(list);
    }

    public int getColumnIndex(String string) throws SdmxException {
        int n = this.model.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (!this.model.getColumnName(i).equals(string)) continue;
            return i;
        }
        throw new SdmxException("Error: column " + string + " does not exist.");
    }

    public int getRowCount() {
        return this.model.getRowCount();
    }

    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    public String getColumnName(int n) throws SdmxException {
        if (n < this.getColumnCount()) {
            return this.model.getColumnName(n);
        }
        throw new SdmxException("Error: index exceeds number of actual columns");
    }

    public Object getValueAt(int n, int n2) throws SdmxException {
        if (n < this.getRowCount() && n2 < this.getColumnCount()) {
            return this.model.getValueAt(n, n2);
        }
        throw new SdmxException("Error: index exceeds number of actual rows or columns");
    }

    public String[] getTimeStamps() throws SdmxException {
        int n = this.getRowCount();
        String[] stringArray = new String[n];
        int n2 = this.getColumnIndex(this.TIME_LABEL);
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)this.getValueAt(i, n2);
        }
        return stringArray;
    }

    public Double[] getObservations() throws SdmxException {
        int n = this.getRowCount();
        Double[] doubleArray = new Double[n];
        int n2 = this.getColumnIndex(this.OBS_LABEL);
        for (int i = 0; i < n; ++i) {
            doubleArray[i] = (Double)this.getValueAt(i, n2);
        }
        return doubleArray;
    }

    public String[] getMetadata(String string) {
        int n = this.getRowCount();
        String[] stringArray = new String[n];
        try {
            int n2 = this.getColumnIndex(string);
            for (int i = 0; i < n; ++i) {
                stringArray[i] = (String)this.getValueAt(i, n2);
            }
        }
        catch (SdmxException sdmxException) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public String[] getMetadataNames() throws SdmxException {
        int n = this.getColumnCount();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            String string = this.getColumnName(i);
            if (string.equals(this.OBS_LABEL) || string.equals(this.TIME_LABEL)) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[0]);
    }

    public void putTimeSeries(List<PortableTimeSeries> list) throws SdmxException {
        logger.entering(sourceClass, "putTimeSeries");
        for (PortableTimeSeries portableTimeSeries : list) {
            this.putTimeSeries(portableTimeSeries);
        }
        logger.exiting(sourceClass, "putTimeSeries");
    }

    public void putTimeSeries(PortableTimeSeries portableTimeSeries) throws SdmxException {
        logger.entering(sourceClass, "putTimeSeries");
        int n = this.model.getRowCount();
        List<String> list = portableTimeSeries.getDimensions();
        List<String> list2 = portableTimeSeries.getAttributes();
        List<Double> list3 = portableTimeSeries.getObservations();
        List<String> list4 = portableTimeSeries.getTimeSlots();
        List<String> list5 = portableTimeSeries.getObsLevelAttributesNames();
        String string = portableTimeSeries.getName();
        int n2 = -1;
        if (string != null) {
            try {
                n2 = this.getColumnIndex(this.ID_LABEL);
            }
            catch (SdmxException sdmxException) {
                this.model.addColumn(this.ID_LABEL);
                try {
                    n2 = this.getColumnIndex(this.ID_LABEL);
                }
                catch (SdmxException sdmxException2) {
                    logger.severe(sdmxException2.getMessage());
                    throw new SdmxException("Unexpected error while adding column 'ID'");
                }
            }
        }
        int n3 = list3.size();
        this.model.setRowCount(n + n3);
        for (int i = 0; i < n3; ++i) {
            int n4;
            String string2;
            String string3;
            Object object;
            Double d = list3.get(i);
            if (list4 != null && (object = list4.get(i)) != null) {
                this.model.setValueAt(object, n, 0);
            }
            this.model.setValueAt(d, n, 1);
            if (n2 != -1) {
                this.model.setValueAt(string, n, n2);
            }
            for (String string4 : list5) {
                int n5;
                String string5 = portableTimeSeries.getObsLevelAttributes(string4).get(i);
                try {
                    n5 = this.getColumnIndex(string4);
                }
                catch (SdmxException sdmxException) {
                    this.model.addColumn(string4);
                    try {
                        n5 = this.getColumnIndex(string4);
                    }
                    catch (SdmxException sdmxException2) {
                        logger.severe(sdmxException2.getMessage());
                        throw new SdmxException("Unexpected error while adding column: " + string4);
                    }
                }
                this.model.setValueAt(string5, n, n5);
            }
            object = "=";
            for (String string5 : list) {
                String[] stringArray = string5.split((String)object);
                string3 = stringArray[0];
                string2 = stringArray[1];
                try {
                    n4 = this.getColumnIndex(string3);
                }
                catch (SdmxException sdmxException) {
                    this.model.addColumn(string3);
                    try {
                        n4 = this.getColumnIndex(string3);
                    }
                    catch (SdmxException sdmxException3) {
                        logger.severe(sdmxException3.getMessage());
                        throw new SdmxException("Unexpected error while adding column: " + string3);
                    }
                }
                this.model.setValueAt(string2, n, n4);
            }
            for (String string5 : list2) {
                String[] stringArray = string5.split((String)object);
                string3 = stringArray[0];
                string2 = stringArray[1];
                try {
                    n4 = this.getColumnIndex(string3);
                }
                catch (SdmxException sdmxException) {
                    this.model.addColumn(string3);
                    try {
                        n4 = this.getColumnIndex(string3);
                    }
                    catch (SdmxException sdmxException4) {
                        logger.severe(sdmxException4.getMessage());
                        throw new SdmxException("Unexpected error while adding column: " + string3);
                    }
                }
                this.model.setValueAt(string2, n, n4);
            }
            ++n;
        }
        logger.exiting(sourceClass, "putTimeSeries");
    }

    public String toString() {
        int n;
        int n2 = this.model.getRowCount();
        int n3 = this.model.getColumnCount();
        String string = "";
        for (n = 0; n < n3; ++n) {
            if (n != 0) {
                string = string + ";";
            }
            string = string + this.model.getColumnName(n);
        }
        string = string + "\n";
        for (n = 0; n < n2; ++n) {
            if (n != 0) {
                string = string + "\n";
            }
            for (int i = 0; i < n3; ++i) {
                if (i != 0) {
                    string = string + ";";
                }
                string = string + this.model.getValueAt(n, i);
            }
        }
        return string;
    }
}

