/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client.custom;

import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.api.Message;
import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.client.RestSdmxClient;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxResponseException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxXmlContentException;
import it.bancaditalia.oss.sdmx.parser.v21.CompactDataParser;
import it.bancaditalia.oss.sdmx.parser.v21.DataParsingResult;
import it.bancaditalia.oss.sdmx.util.Configuration;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;

public class EUROSTAT
extends RestSdmxClient {
    private static final String EUROSTAT_PROVIDER = "https://ec.europa.eu/eurostat/api/dissemination/sdmx/2.1";
    private static final String ASYNC_DELIVERY_CODE = String.valueOf(413);
    private int sleepTime = 6000;
    private int retries = Integer.parseInt(Configuration.getLateResponseRetries(10));

    public EUROSTAT() throws URISyntaxException {
        super("Eurostat", new URI(EUROSTAT_PROVIDER), false, false, false);
    }

    @Override
    public List<PortableTimeSeries<Double>> getTimeSeries(Dataflow dataflow, DataFlowStructure dataFlowStructure, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        DataParsingResult dataParsingResult = this.getData(dataflow, dataFlowStructure, string, string2, string3, bl, string4, bl2);
        if (dataParsingResult == null || dataParsingResult.size() == 0) {
            Message message = dataParsingResult.getMessage();
            if (EUROSTAT.isAsyncDelivery(message)) {
                String string5 = message.getUrl();
                CompactDataParser compactDataParser = new CompactDataParser(dataFlowStructure, dataflow, !bl);
                for (int i = 1; i <= this.retries; ++i) {
                    LOGGER.info("Trying late retrieval with URL: " + string5 + ". Attempt n: " + i);
                    try {
                        Thread.sleep(this.sleepTime);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    try {
                        String string6 = "data_" + dataflow.getId() + "_" + string;
                        return this.postProcess(this.runQuery(compactDataParser, new URL(message.getUrl()), null, string6));
                    }
                    catch (SdmxResponseException | MalformedURLException exception) {
                        LOGGER.info("Late retrieval attempt " + i + " failed with exception " + exception.getClass().getSimpleName() + ": " + exception.getMessage());
                        continue;
                    }
                }
            }
        } else {
            return this.postProcess(dataParsingResult);
        }
        throw new SdmxXmlContentException("Late retrieval failed.");
    }

    private static boolean isAsyncDelivery(Message message) {
        return message != null && ASYNC_DELIVERY_CODE.equals(message.getCode()) && message.getUrl() != null;
    }
}

