% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ORHAnalysis.R
\name{ORHAnalysis}
\alias{ORHAnalysis}
\title{Obuchowski-Rockette analysis with Hillis improvements}
\usage{
ORHAnalysis(dataset, fom = "wJAFROC", alpha = 0.05,
  covEstMethod = "Jackknife", nBoots = 200, option = "ALL")
}
\arguments{
\item{dataset}{See \link{DBMHAnalysis}.}

\item{fom}{See \link{DBMHAnalysis}.}

\item{alpha}{See \link{DBMHAnalysis}.}

\item{covEstMethod}{The method used to estimate the covariance matrix; can be \code{Jackknife}, \code{Bootstrap} or \code{DeLong},
the last assumes the Wilcoxon FOM is chosen, otherwise an error will result.}

\item{nBoots}{The number of bootstraps (default is 200), used only if the \code{Bootstrap} method is used to estimate
the covariance matrix.}

\item{option}{See \link{DBMHAnalysis}.}
}
\value{
The return value is a list with following elements:

\item{fomArray}{Figures of merit array. See the return of \link{FigureOfMerit}.}

\item{msT}{Mean square of the figure of merit corresponding to the the treatment effect.}

\item{msTR}{Mean square of the figure of merit corresponding to the the treatment-reader effect.}

\item{varComp}{Obuchowski-Rockette variance component and covariance estimates.}

\item{fRRRC}{See \link{DBMHAnalysis}.}

\item{ddfRRRC}{See \link{DBMHAnalysis}.}

\item{pRRRC}{See \link{DBMHAnalysis}.}

\item{ciDiffTrtRRRC}{See \link{DBMHAnalysis}.}

\item{ciAvgRdrEachTrtRRRC}{See \link{DBMHAnalysis}.}

\item{fFRRC}{See \link{DBMHAnalysis}.}

\item{ddfFRRC}{See \link{DBMHAnalysis}.}

\item{pFRRC}{See \link{DBMHAnalysis}.}

\item{ciDiffTrtFRRC}{See \link{DBMHAnalysis}.}

\item{ciAvgRdrEachTrtFRRC}{See \link{DBMHAnalysis}.}

\item{ciDiffTrtEachRdr}{See \link{DBMHAnalysis}.}

\item{varCovEachRdr}{Obuchowski-Rockette Variance and Cov1 estimates for each reader.}

\item{fRRFC}{See \link{DBMHAnalysis}.}

\item{ddfRRFC}{See \link{DBMHAnalysis}.}

\item{pRRFC}{See \link{DBMHAnalysis}.}

\item{ciDiffTrtRRFC}{See \link{DBMHAnalysis}.}

\item{ciAvgRdrEachTrtRRFC}{See \link{DBMHAnalysis}.}
}
\description{
Performs Obuchowski-Rockette analysis with Hillis improvements for the specified dataset.
}
\examples{
retOR <- ORHAnalysis(rocData, fom = "Wilcoxon")
print(retOR)
}

