% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/FigureOfMerit.R
\name{FigureOfMerit}
\alias{FigureOfMerit}
\title{Calculate figure of merit}
\usage{
FigureOfMerit(dataset, fom = "wJAFROC")
}
\arguments{
\item{dataset}{The dataset to be analyzed, see \link{RJafroc-package}.}

\item{fom}{The figure of merit to be used in the calculation. The default is \code{"wJAFROC"}. See "Details".}
}
\value{
An \code{c(I, J)} array, where the row names are the IDs of the treatments and column names are the IDs of the readers.
}
\description{
Caclulate the figure of merit (an objective measure of observer performance) for each treatment-reader combination.
}
\details{
Allowed figures of merit are: (1) \code{"Wilcoxon"} for ROC data; (2) \code{"JAFROC1"},
\code{"JAFROC"}, \code{"wJAFROC1"}, \code{"wJAFROC"} (the default), \code{"HrAuc"}, \code{"SongA1"}, \code{"SongA2"}\bold{**} ,
\code{"HrSe"}, \code{"HrSp"}, \code{"MaxLLF"}, \code{"MaxNLF"}, \code{"MaxNLFAllCases"}, \code{"ExpTrnsfmSp"},
for free-response data and (3) \code{"ROI"} for ROI data.
The JAFROC FOMs are described in the paper by Chakraborty and Berbaum. The Song FOMs are described in the paper by Song et al.
The \code{"MaxLLF"}, \code{"MaxNLF"} and \code{"MaxNLFAllCases"} FOMs correspond to ordinate, abscissa and abscissa, respectively, of the highest
point on the FROC operating characteristic obtained by counting all the LL marks on diseased, all NL marks on non-diseased cases,
and all NL marks on all cases, respectively). The \code{"ExpTrnsfmSp"} FOM is described in the paper by Popescu.
The \code{"ROI"} FOM is described in the paper by Obuchowski et al.

** \bold{The Song A2 figure of merit is computationally very intensive.}
}
\examples{
FigureOfMerit(dataset = rocData, fom = "Wilcoxon")

FigureOfMerit(dataset = frocData)
}
\references{
Chakraborty, D. P., & Berbaum, K. S. (2004). Observer studies involving detection and localization: modeling, analysis, and validation.
Medical Physics, 31(8), 1-18.

Song T, Bandos AI, Rockette HE, Gur D (2008) On comparing methods for discriminating between actually negative and actually positive subjects
with FROC type data. Medical Physics 35: 1547-1558.

Popescu, L. M. (2011). Nonparametric signal detectability evaluation using an exponential transformation of the FROC curve.
Medical Physics, 38(10), 5690.

Obuchowski, N. A., Lieber, M. L., & Powell, K. A. (2000). Data Analysis for Detection and Localization of Multiple Abnormalities
with Application to Mammography. Academic Radiology, 553-554.
}

