% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExampleCompare3ProperRocFits.R
\name{ExampleCompare3ProperRocFits}
\alias{ExampleCompare3ProperRocFits}
\title{Compare three proper-ROC curve fitting models}
\usage{
ExampleCompare3ProperRocFits(startIndx = 1, endIndx = 14, 
   showPlot = FALSE, saveProprocLrcFile = FALSE, reAnalyze = FALSE)
}
\arguments{
\item{startIndx}{An integer in the range 1 to 14.}

\item{endIndx}{An integer in the range 1 to 14, greater than or equal 
to \code{startIndx}.}

\item{showPlot}{If \code{TRUE} the three plots are shown along with 95 
percent confidence intervals on the lowest and uppermost operating 
points. The default is \code{FALSE}.}

\item{saveProprocLrcFile}{If \code{TRUE} the binned datasets are saved 
for subsequent analysis using other ROC software, e.g., Windows 
DBM-MRMC. The default is \code{FALSE}.}

\item{reAnalyze}{If \code{TRUE} the data is reanalyzed. The default 
is \code{FALSE} in which case the previously saved results are used.}
}
\value{
The returned value \code{allResults} is a \code{list} containing all
   results from the three parameteric model fits. See details.
}
\description{
Applies the radiological search model (RSM) and the 
   contaminated binormal model (CBM) ROC-curve fitting methods to 14 
   datasets and compares the fits to proper ROC (PROPROC) 
   fits obtained using Windows software downloaded from the Univ. of 
   Iowa ROC website ca. June 2017.
}
\details{
allResults is a list-array with length equal to 
   (\code{endIndx} - \code{startIndx} + 1), where each element of the list-array 
   consists of 10 elements, see above. For example, \code{allResults[[1]]} 
   corresponds to 
   the dataset corresponding to \code{startIndx}. \code{allResults[[2]]} 
   corresponds to the dataset corresponding to \code{startIndx+1}, etc.
A specific member, e.g., \code{allResults[[1]]}, has the following structure:   
\itemize{
\item{\code{retRsm}}{ The RSM parameters following the output structure of \link{FitRsmRoc}}
\item{\code{retCbm}}{ The CBM parameters following the output structure of \link{FitCbmRoc}}
\item{\code{lesDistr}}{ The lesion distribution matrix}
\item{\code{c1}}{ The \code{c}-parameter of PROPROC}
\item{\code{da}}{ The \code{d_sub_a} parameter of PROPROC}
\item{\code{aucProp}}{ The \code{PROPROC} AUC}
\item{\code{I}}{ The number of modalities}
\item{\code{J}}{ The number of readers}
\item{\code{K1}}{ The number of non-diseased cases}
\item{\code{K2}}{ The number of diseased cases}
}


The PROPROC parameters were obtained by running Windows software OR 
   DBM-MRMC 2.50 (Sept. 04, 2014, Build 4) with \strong{PROPROC} and 
   \strong{area} selected. The \code{RSM} and \code{CBM} fits are implemented
   in this package. The corresponding returned objects contain all relevant 
   parameters. Chapter 18 of the author's book has further details. 
   If \code{saveProprocLrcFile} 
   is \code{TRUE}, the \code{.lrc} files will be written to the \code{File-Panes}
   directory, \strong{overwriting} any existing files with the same names.

##  Notes on updating the results
##  First run PROPROC on all datasets
##  1. ret14 <- ExampleCompare3ProperRocFits(saveProprocLrcFile = TRUE) 
##     this generates 14 .lrc files in rjafroc
##  2. Move these files to VmWareShared folder
##  3. Start VmWare and Windows 8
##  4. Start OR DBM MRMC, select .lrc file, set PROPROC AUC and run all
##  5. Repeat for each datset
##  6. Move 2 files (ending with .lroc and proproc area pooled.csv) from 
##     VmWareShared to rjafroc/inst/MRMCRuns to appropriate subdirectories.
##  7. Remove spaces in names of all "proproc area pooled.csv" files  
##  8. ret14 <- ExampleCompare3ProperRocFits(reAnalyze = TRUE) 
##     this generates new results files in rjafroc/inst/ANALYZED/RSM6
##
}
\examples{
\dontrun{
ExampleCompare3ProperRocFits(1,1)$allResults
}



}
\references{
Chakraborty DP (2017) \emph{Observer Performance Methods for Diagnostic Imaging - Foundations, 
Modeling, and Applications with R-Based Examples}, CRC Press, Boca Raton, FL. 
\url{https://www.crcpress.com/Observer-Performance-Methods-for-Diagnostic-Imaging-Foundations-Modeling/Chakraborty/p/book/9781482214840}

Metz CE, Pan X 1999 Proper Binormal ROC Curves: Theory and Maximum-Likelihood Estimation. 
J Math Psychol. \bold{43},(1):1--33.

Dorfman DD, Berbaum KS, 2000 A contaminated binormal model for ROC data: Part II. A formal model 
Acad Radiol \bold{7}, 427--437.
}
