/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3;

import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessControlException;
import org.apache.commons.logging.LogFactory;

public class RelURI {
    private static String globalBase = null;

    public static String resolve(String relStr, String baseStr) {
        Fixup b = new Fixup(baseStr);
        Fixup r = new Fixup(relStr);
        String s = RelURI._resolve(r.getSafe(), b.getSafe());
        s = b.reverse(s);
        s = r.reverse(s);
        return s;
    }

    private static String _resolve(String relStr, String baseStr) {
        URI abs;
        URI rel = null;
        try {
            rel = new URI(relStr);
        }
        catch (URISyntaxException ex) {
            throw new JenaURIException("Illegal URI: " + relStr);
        }
        if (rel.isAbsolute()) {
            String s = rel.getScheme();
            if (rel.getScheme().equals("file")) {
                return RelURI.resolveFileURL(relStr);
            }
            if (rel.getPath() != null && rel.getPath().startsWith("/")) {
                return relStr;
            }
        }
        if (baseStr == null) {
            try {
                URI u = new URI(relStr);
                if (!u.isAbsolute()) {
                    throw new JenaURIException("Null base for relative URI resolution");
                }
                return relStr;
            }
            catch (URISyntaxException ex) {
                throw new JenaURIException("Illegal URI (base was null and URI is not absolute) " + relStr);
            }
        }
        if (baseStr.length() == 0) {
            throw new JenaURIException("Empty base for relative URI resolution");
        }
        if (baseStr.indexOf(35) >= 0) {
            int i = baseStr.indexOf(35);
            baseStr = baseStr.substring(0, i);
        }
        if (baseStr.endsWith(":")) {
            return RelURI.resolve(baseStr + relStr);
        }
        if (relStr.equals("")) {
            return baseStr;
        }
        URI base = null;
        try {
            base = new URI(baseStr);
        }
        catch (URISyntaxException ex) {
            throw new JenaURIException("Illegal URI (base): " + baseStr);
        }
        if (!base.isAbsolute()) {
            throw new RelativeURIException("Relative URI for base: " + baseStr);
        }
        if (base.isOpaque()) {
            if (base.getScheme().equals("file") && relStr.startsWith("#")) {
                return baseStr + relStr;
            }
            throw new RelativeURIException("Can't resolve a relative URI against an opaque URI: rel=" + relStr + " : base=" + baseStr);
        }
        if (base.getPath().length() == 0 && !relStr.startsWith("/")) {
            try {
                base = new URI(baseStr + "/");
            }
            catch (URISyntaxException ex) {
                LogFactory.getLog((Class)RelURI.class).fatal((Object)("Base now illegal fixing up path-less base URI (" + baseStr + ")"));
                throw new JenaURIException("Illegal URI (base) ptII: " + baseStr);
            }
        }
        if ((abs = RelURI.resolve(rel, base)) == null) {
            return null;
        }
        String s = abs.toString();
        if (s.startsWith("file:")) {
            s = RelURI.resolveFileURL(s);
        }
        return s;
    }

    private static URI resolve(URI rel, URI base) {
        URI abs = base.resolve(rel);
        if (!abs.isAbsolute()) {
            return null;
        }
        return abs;
    }

    public static String resolve(String relURI) {
        if (globalBase == null) {
            globalBase = RelURI.chooseBaseURI();
        }
        return RelURI.resolve(relURI, globalBase);
    }

    public static void setBaseURI(String uriBase) {
        if (uriBase != null && uriBase.startsWith("file:/") && !uriBase.startsWith("file:///")) {
            LogFactory.getLog((Class)RelURI.class).warn((Object)"setBaseURI: File URIs should look like 'file:///path' (or at least file://host/path)");
        }
        globalBase = uriBase;
    }

    public static String getBaseURI() {
        return globalBase;
    }

    public static String chooseBaseURI() {
        return RelURI.chooseBaseURI(null);
    }

    public static String chooseBaseURI(String baseURI) {
        String scheme;
        if (baseURI == null) {
            baseURI = "file:.";
        }
        if ((scheme = FileUtils.getScheme(baseURI)) == null) {
            scheme = "file";
            baseURI = "file:" + baseURI;
        }
        if (scheme.equals("file") && !baseURI.startsWith("file:///")) {
            try {
                String tmp = baseURI.substring("file:".length());
                File f = new File(tmp);
                String s = f.getCanonicalPath();
                s = s.replace('\\', '/');
                if (s.indexOf(32) >= 0) {
                    s = s.replaceAll(" ", "%20");
                }
                baseURI = s.startsWith("/") ? "file://" + s : "file:///" + s;
                if (f.isDirectory() && !baseURI.endsWith("/")) {
                    baseURI = baseURI + "/";
                }
            }
            catch (IOException ex) {
                LogFactory.getLog((Class)RelURI.class).warn((Object)"IOException in chooseBase - ignored");
                return null;
            }
            catch (AccessControlException ex) {
                LogFactory.getLog((Class)RelURI.class).warn((Object)"Security exception in chooseBase - ignored");
                return null;
            }
        }
        return baseURI;
    }

    public static String resolveFileURL(String filename) {
        String s = filename;
        try {
            if (s.indexOf(92) > -1) {
                s = s.replace('\\', '/');
            }
            if (s.startsWith("file:///")) {
                return s;
            }
            if (s.startsWith("file://")) {
                return s;
            }
            if (s.startsWith("file:/")) {
                s = filename.substring("file:/".length());
                return "file:///" + s;
            }
            if (s.startsWith("file:")) {
                s = filename.substring("file:".length());
            }
            File f = new File(s);
            s = s.endsWith("/") ? f.getAbsolutePath() + "/" : f.getCanonicalPath();
            s = s.replace('\\', '/');
            s = s.startsWith("/") ? "file://" + s : "file:///" + s;
            return s;
        }
        catch (IOException ex) {
            return null;
        }
    }

    static class Fixup {
        String originalPrefix = null;
        String safePrefix = null;
        String safeForm = null;

        Fixup(String str) {
            this.safeForm = str;
            if (str != null && str.indexOf(32) >= 0) {
                int i = str.lastIndexOf(32);
                this.originalPrefix = str.substring(0, i + 1);
                this.safeForm = str.replace(' ', '_');
                this.safePrefix = this.safeForm.substring(0, i + 1);
            }
        }

        String getSafe() {
            return this.safeForm;
        }

        String reverse(String s) {
            if (this.originalPrefix != null && s.startsWith(this.safePrefix)) {
                s = this.originalPrefix + s.substring(this.safePrefix.length());
            }
            return s;
        }
    }

    public static class RelativeURIException
    extends JenaURIException {
        public RelativeURIException(String msg) {
            super(msg);
        }
    }

    public static class JenaURIException
    extends JenaException {
        public JenaURIException(String msg) {
            super(msg);
        }
    }
}

