/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.supervised.attribute.PLSFilter;

public class PLSClassifier
extends Classifier {
    private static final long serialVersionUID = 4819775160590973256L;
    protected PLSFilter m_Filter = new PLSFilter();
    protected PLSFilter m_ActualFilter = null;

    public String globalInfo() {
        return "A wrapper classifier for the PLSFilter, utilizing the PLSFilter's ability to perform predictions.";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tThe PLS filter to use. Full classname of filter to include, \tfollowed by scheme options.\n\t(default: weka.filters.supervised.attribute.PLSFilter)", "filter", 1, "-filter <filter specification>"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        if (this.getFilter() instanceof OptionHandler) {
            vector.addElement(new Option("", "", 0, "\nOptions specific to filter " + this.getFilter().getClass().getName() + " ('-filter'):"));
            enumeration = ((OptionHandler)((Object)this.getFilter())).listOptions();
            while (enumeration.hasMoreElements()) {
                vector.addElement((Option)enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-filter");
        if (this.getFilter() instanceof OptionHandler) {
            vector.add(this.getFilter().getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)this.getFilter())).getOptions()));
        } else {
            vector.add(this.getFilter().getClass().getName());
        }
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        return vector.toArray(new String[vector.size()]);
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption("filter", stringArray);
        String[] stringArray2 = Utils.splitOptions(string);
        if (stringArray2.length != 0) {
            string = stringArray2[0];
            stringArray2[0] = "";
            this.setFilter((Filter)Utils.forName(Filter.class, string, stringArray2));
        }
    }

    public String filterTipText() {
        return "The PLS filter to be used (only used for setup).";
    }

    public void setFilter(Filter filter) throws Exception {
        if (!(filter instanceof PLSFilter)) {
            throw new Exception("Filter has to be PLSFilter!");
        }
        this.m_Filter = (PLSFilter)filter;
    }

    public Filter getFilter() {
        return this.m_Filter;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = this.getFilter().getCapabilities();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.setMinimumNumberInstances(1);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.m_ActualFilter = (PLSFilter)Filter.makeCopy(this.m_Filter);
        this.m_ActualFilter.setPerformPrediction(false);
        this.m_ActualFilter.setInputFormat(instances);
        Filter.useFilter(instances, this.m_ActualFilter);
        this.m_ActualFilter.setPerformPrediction(true);
    }

    public double classifyInstance(Instance instance) throws Exception {
        this.m_ActualFilter.input(instance);
        this.m_ActualFilter.batchFinished();
        Instance instance2 = this.m_ActualFilter.output();
        double d = instance2.classValue();
        return d;
    }

    public String toString() {
        String string = this.getClass().getName() + "\n" + this.getClass().getName().replaceAll(".", "=") + "\n\n";
        string = string + "# Components..........: " + this.m_Filter.getNumComponents() + "\n";
        string = string + "Algorithm.............: " + this.m_Filter.getAlgorithm().getSelectedTag().getReadable() + "\n";
        string = string + "Replace missing values: " + (this.m_Filter.getReplaceMissing() ? "yes" : "no") + "\n";
        string = string + "Preprocessing.........: " + this.m_Filter.getPreprocessing().getSelectedTag().getReadable() + "\n";
        return string;
    }

    public static void main(String[] stringArray) {
        PLSClassifier.runClassifier(new PLSClassifier(), stringArray);
    }
}

