/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.ObjectOutputStream;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.CSVLoader;
import weka.core.converters.ConverterUtils;
import weka.core.converters.Loader;
import weka.core.converters.SerializedInstancesLoader;
import weka.core.converters.URLSourcedLoader;
import weka.datagenerators.DataGenerator;
import weka.experiment.InstanceQuery;
import weka.filters.Filter;
import weka.filters.SupervisedFilter;
import weka.filters.unsupervised.attribute.Remove;
import weka.gui.AttributeSelectionPanel;
import weka.gui.AttributeSummaryPanel;
import weka.gui.AttributeVisualizationPanel;
import weka.gui.ConverterFileChooser;
import weka.gui.GenericObjectEditor;
import weka.gui.InstancesSummaryPanel;
import weka.gui.LogPanel;
import weka.gui.Logger;
import weka.gui.PropertyDialog;
import weka.gui.PropertyPanel;
import weka.gui.SysErrLog;
import weka.gui.TaskLogger;
import weka.gui.ViewerDialog;
import weka.gui.beans.AttributeSummarizer;
import weka.gui.explorer.DataGeneratorPanel;
import weka.gui.explorer.Explorer;
import weka.gui.explorer.ExplorerDefaults;
import weka.gui.sql.SqlViewerDialog;

public class PreprocessPanel
extends JPanel
implements Explorer.CapabilitiesFilterChangeListener {
    protected InstancesSummaryPanel m_InstSummaryPanel = new InstancesSummaryPanel();
    protected JButton m_OpenFileBut = new JButton("Open file...");
    protected JButton m_OpenURLBut = new JButton("Open URL...");
    protected JButton m_OpenDBBut = new JButton("Open DB...");
    protected JButton m_GenerateBut = new JButton("Generate...");
    protected JButton m_UndoBut = new JButton("Undo");
    protected JButton m_EditBut = new JButton("Edit...");
    protected JButton m_SaveBut = new JButton("Save...");
    protected AttributeSelectionPanel m_AttPanel = new AttributeSelectionPanel();
    JButton m_RemoveButton = new JButton("Remove");
    protected AttributeSummaryPanel m_AttSummaryPanel = new AttributeSummaryPanel();
    protected GenericObjectEditor m_FilterEditor = new GenericObjectEditor();
    protected PropertyPanel m_FilterPanel = new PropertyPanel(this.m_FilterEditor);
    protected JButton m_ApplyFilterBut = new JButton("Apply");
    protected ConverterFileChooser m_FileChooser = new ConverterFileChooser(new File(System.getProperty("user.dir")));
    protected String m_LastURL = "http://";
    protected String m_SQLQ = new String("SELECT * FROM ?");
    protected Instances m_Instances;
    protected DataGenerator m_DataGenerator = null;
    protected AttributeVisualizationPanel m_AttVisualizePanel = new AttributeVisualizationPanel();
    protected File[] m_tempUndoFiles = new File[20];
    protected int m_tempUndoIndex = 0;
    protected PropertyChangeSupport m_Support = new PropertyChangeSupport(this);
    protected Thread m_IOThread;
    protected Logger m_Log = new SysErrLog();
    protected Explorer m_Explorer = null;

    public PreprocessPanel() {
        this.m_FilterEditor.setClassType(Filter.class);
        if (ExplorerDefaults.getFilter() != null) {
            this.m_FilterEditor.setValue(ExplorerDefaults.getFilter());
        }
        this.m_OpenFileBut.setToolTipText("Open a set of instances from a file");
        this.m_OpenURLBut.setToolTipText("Open a set of instances from a URL");
        this.m_OpenDBBut.setToolTipText("Open a set of instances from a database");
        this.m_GenerateBut.setToolTipText("Generates artificial data");
        this.m_UndoBut.setToolTipText("Undo the last change to the dataset");
        this.m_EditBut.setToolTipText("Open the current dataset in a Viewer for editing");
        this.m_SaveBut.setToolTipText("Save the working relation to a file");
        this.m_ApplyFilterBut.setToolTipText("Apply the current filter to the data");
        this.m_FileChooser.setFileSelectionMode(0);
        this.m_OpenURLBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreprocessPanel.this.setInstancesFromURLQ();
            }
        });
        this.m_OpenDBBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SqlViewerDialog sqlViewerDialog = new SqlViewerDialog(null);
                sqlViewerDialog.setVisible(true);
                if (sqlViewerDialog.getReturnValue() == 0) {
                    PreprocessPanel.this.setInstancesFromDBQ(sqlViewerDialog.getURL(), sqlViewerDialog.getUser(), sqlViewerDialog.getPassword(), sqlViewerDialog.getQuery());
                }
            }
        });
        this.m_OpenFileBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreprocessPanel.this.setInstancesFromFileQ();
            }
        });
        this.m_GenerateBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreprocessPanel.this.generateInstances();
            }
        });
        this.m_UndoBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreprocessPanel.this.undo();
            }
        });
        this.m_EditBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreprocessPanel.this.edit();
            }
        });
        this.m_SaveBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreprocessPanel.this.saveWorkingInstancesToFileQ();
            }
        });
        this.m_ApplyFilterBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreprocessPanel.this.applyFilter((Filter)PreprocessPanel.this.m_FilterEditor.getValue());
            }
        });
        this.m_AttPanel.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    for (int i = listSelectionEvent.getFirstIndex(); i <= listSelectionEvent.getLastIndex(); ++i) {
                        if (!listSelectionModel.isSelectedIndex(i)) continue;
                        PreprocessPanel.this.m_AttSummaryPanel.setAttribute(i);
                        PreprocessPanel.this.m_AttVisualizePanel.setAttribute(i);
                        break;
                    }
                }
            }
        });
        this.m_InstSummaryPanel.setBorder(BorderFactory.createTitledBorder("Current relation"));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Attributes"));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.m_AttPanel, "Center");
        this.m_RemoveButton.setEnabled(false);
        this.m_RemoveButton.setToolTipText("Remove selected attributes.");
        this.m_RemoveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Remove remove = new Remove();
                    int[] nArray = PreprocessPanel.this.m_AttPanel.getSelectedAttributes();
                    if (nArray.length == 0) {
                        return;
                    }
                    if (nArray.length == PreprocessPanel.this.m_Instances.numAttributes()) {
                        JOptionPane.showMessageDialog(PreprocessPanel.this, "Can't remove all attributes from data!\n", "Remove Attributes", 0);
                        PreprocessPanel.this.m_Log.logMessage("Can't remove all attributes from data!");
                        PreprocessPanel.this.m_Log.statusMessage("Problem removing attributes");
                        return;
                    }
                    remove.setAttributeIndicesArray(nArray);
                    PreprocessPanel.this.applyFilter(remove);
                }
                catch (Exception exception) {
                    if (PreprocessPanel.this.m_Log instanceof TaskLogger) {
                        ((TaskLogger)((Object)PreprocessPanel.this.m_Log)).taskFinished();
                    }
                    JOptionPane.showMessageDialog(PreprocessPanel.this, "Problem filtering instances:\n" + exception.getMessage(), "Remove Attributes", 0);
                    PreprocessPanel.this.m_Log.logMessage("Problem removing attributes: " + exception.getMessage());
                    PreprocessPanel.this.m_Log.statusMessage("Problem removing attributes");
                }
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.m_RemoveButton, "Center");
        jPanel.add((Component)jPanel2, "South");
        this.m_AttSummaryPanel.setBorder(BorderFactory.createTitledBorder("Selected attribute"));
        this.m_UndoBut.setEnabled(false);
        this.m_EditBut.setEnabled(false);
        this.m_SaveBut.setEnabled(false);
        this.m_ApplyFilterBut.setEnabled(false);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel3.setLayout(new GridLayout(1, 6, 5, 5));
        jPanel3.add(this.m_OpenFileBut);
        jPanel3.add(this.m_OpenURLBut);
        jPanel3.add(this.m_OpenDBBut);
        jPanel3.add(this.m_GenerateBut);
        jPanel3.add(this.m_UndoBut);
        jPanel3.add(this.m_EditBut);
        jPanel3.add(this.m_SaveBut);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)jPanel, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createTitledBorder("Filter"));
        jPanel5.setLayout(new BorderLayout());
        jPanel5.add((Component)this.m_FilterPanel, "Center");
        jPanel5.add((Component)this.m_ApplyFilterBut, "East");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayout(2, 1));
        jPanel6.add(this.m_AttSummaryPanel);
        JComboBox jComboBox = this.m_AttVisualizePanel.getColorBox();
        jComboBox.setToolTipText("The chosen attribute will also be used as the class attribute when a filter is applied.");
        final JButton jButton = new JButton("Visualize All");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PreprocessPanel.this.m_Instances != null) {
                    try {
                        AttributeSummarizer attributeSummarizer = new AttributeSummarizer();
                        attributeSummarizer.setColoringIndex(PreprocessPanel.this.m_AttVisualizePanel.getColoringIndex());
                        attributeSummarizer.setInstances(PreprocessPanel.this.m_Instances);
                        final JFrame jFrame = new JFrame();
                        jFrame.getContentPane().setLayout(new BorderLayout());
                        jFrame.getContentPane().add((Component)attributeSummarizer, "Center");
                        jFrame.addWindowListener(new WindowAdapter(){

                            public void windowClosing(WindowEvent windowEvent) {
                                jButton.setEnabled(true);
                                jFrame.dispose();
                            }
                        });
                        jFrame.setSize(830, 600);
                        jFrame.setVisible(true);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout());
        jPanel7.add((Component)this.m_AttVisualizePanel, "Center");
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout());
        jPanel8.add((Component)jComboBox, "Center");
        jPanel8.add((Component)jButton, "East");
        jPanel7.add((Component)jPanel8, "North");
        jPanel6.add(jPanel7);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BorderLayout());
        jPanel9.add((Component)this.m_InstSummaryPanel, "North");
        jPanel9.add((Component)jPanel4, "Center");
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new BorderLayout());
        jPanel10.add((Component)jPanel6, "Center");
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new GridLayout(1, 2));
        jPanel11.add(jPanel9);
        jPanel11.add(jPanel10);
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new BorderLayout());
        jPanel12.add((Component)jPanel5, "North");
        jPanel12.add((Component)jPanel11, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel3, "North");
        this.add((Component)jPanel12, "Center");
    }

    public void setLog(Logger logger) {
        this.m_Log = logger;
    }

    public void setInstances(Instances instances) {
        this.m_Instances = instances;
        try {
            Runnable runnable = new Runnable(){

                public void run() {
                    PreprocessPanel.this.m_InstSummaryPanel.setInstances(PreprocessPanel.this.m_Instances);
                    PreprocessPanel.this.m_AttPanel.setInstances(PreprocessPanel.this.m_Instances);
                    PreprocessPanel.this.m_RemoveButton.setEnabled(true);
                    PreprocessPanel.this.m_AttSummaryPanel.setInstances(PreprocessPanel.this.m_Instances);
                    PreprocessPanel.this.m_AttVisualizePanel.setInstances(PreprocessPanel.this.m_Instances);
                    PreprocessPanel.this.m_AttPanel.getSelectionModel().setSelectionInterval(0, 0);
                    PreprocessPanel.this.m_AttSummaryPanel.setAttribute(0);
                    PreprocessPanel.this.m_AttVisualizePanel.setAttribute(0);
                    PreprocessPanel.this.m_ApplyFilterBut.setEnabled(true);
                    PreprocessPanel.this.m_Log.logMessage("Base relation is now " + PreprocessPanel.this.m_Instances.relationName() + " (" + PreprocessPanel.this.m_Instances.numInstances() + " instances)");
                    PreprocessPanel.this.m_SaveBut.setEnabled(true);
                    PreprocessPanel.this.m_EditBut.setEnabled(true);
                    PreprocessPanel.this.m_Log.statusMessage("OK");
                    PreprocessPanel.this.m_Support.firePropertyChange("", null, null);
                    try {
                        if (ExplorerDefaults.getInitGenericObjectEditorFilter()) {
                            PreprocessPanel.this.getExplorer().notifyCapabilitiesFilterListener(Capabilities.forInstances(PreprocessPanel.this.m_Instances));
                        } else {
                            PreprocessPanel.this.getExplorer().notifyCapabilitiesFilterListener(Capabilities.forInstances(new Instances(PreprocessPanel.this.m_Instances, 0)));
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        PreprocessPanel.this.m_Log.logMessage(exception.toString());
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this, "Problem setting base instances:\n" + exception, "Instances", 0);
        }
    }

    public Instances getInstances() {
        return this.m_Instances;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_Support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_Support.removePropertyChangeListener(propertyChangeListener);
    }

    protected void applyFilter(final Filter filter) {
        if (this.m_IOThread == null) {
            this.m_IOThread = new Thread(){

                public void run() {
                    try {
                        if (filter != null) {
                            if (PreprocessPanel.this.m_Log instanceof TaskLogger) {
                                ((TaskLogger)((Object)PreprocessPanel.this.m_Log)).taskStarted();
                            }
                            PreprocessPanel.this.m_Log.statusMessage("Passing dataset through filter " + filter.getClass().getName());
                            String string = filter.getClass().getName();
                            if (filter instanceof OptionHandler) {
                                string = string + " " + Utils.joinOptions(((OptionHandler)((Object)filter)).getOptions());
                            }
                            PreprocessPanel.this.m_Log.logMessage("Command: " + string);
                            int n = PreprocessPanel.this.m_AttVisualizePanel.getColoringIndex();
                            if (n < 0 && filter instanceof SupervisedFilter) {
                                throw new IllegalArgumentException("Class (colour) needs to be set for supervised filter.");
                            }
                            Instances instances = new Instances(PreprocessPanel.this.m_Instances);
                            instances.setClassIndex(n);
                            filter.setInputFormat(instances);
                            Instances instances2 = Filter.useFilter(instances, filter);
                            if (instances2 == null || instances2.numAttributes() < 1) {
                                throw new Exception("Dataset is empty.");
                            }
                            PreprocessPanel.this.m_Log.statusMessage("Saving undo information");
                            PreprocessPanel.this.addUndoPoint();
                            PreprocessPanel.this.m_AttVisualizePanel.setColoringIndex(instances.classIndex());
                            if (PreprocessPanel.this.m_Instances.classIndex() < 0) {
                                instances2.setClassIndex(-1);
                            }
                            PreprocessPanel.this.m_Instances = instances2;
                            PreprocessPanel.this.setInstances(PreprocessPanel.this.m_Instances);
                            if (PreprocessPanel.this.m_Log instanceof TaskLogger) {
                                ((TaskLogger)((Object)PreprocessPanel.this.m_Log)).taskFinished();
                            }
                        }
                    }
                    catch (Exception exception) {
                        if (PreprocessPanel.this.m_Log instanceof TaskLogger) {
                            ((TaskLogger)((Object)PreprocessPanel.this.m_Log)).taskFinished();
                        }
                        JOptionPane.showMessageDialog(PreprocessPanel.this, "Problem filtering instances:\n" + exception.getMessage(), "Apply Filter", 0);
                        PreprocessPanel.this.m_Log.logMessage("Problem filtering instances: " + exception.getMessage());
                        PreprocessPanel.this.m_Log.statusMessage("Problem filtering instances");
                    }
                    PreprocessPanel.this.m_IOThread = null;
                }
            };
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        } else {
            JOptionPane.showMessageDialog(this, "Can't apply filter at this time,\ncurrently busy with other IO", "Apply Filter", 2);
        }
    }

    public void saveWorkingInstancesToFileQ() {
        if (this.m_IOThread == null) {
            Object object;
            this.m_FileChooser.setCapabilitiesFilter(this.m_FilterEditor.getCapabilitiesFilter());
            this.m_FileChooser.setAcceptAllFileFilterUsed(false);
            int n = this.m_FileChooser.showSaveDialog(this);
            if (n == 0) {
                object = new Instances(this.m_Instances);
                ((Instances)object).setClassIndex(this.m_AttVisualizePanel.getColoringIndex());
                this.saveInstancesToFile(this.m_FileChooser.getSaver(), (Instances)object);
            }
            object = this.m_FileChooser.getFileFilter();
            this.m_FileChooser.setAcceptAllFileFilterUsed(true);
            this.m_FileChooser.setFileFilter((FileFilter)object);
        } else {
            JOptionPane.showMessageDialog(this, "Can't save at this time,\ncurrently busy with other IO", "Save Instances", 2);
        }
    }

    public void saveInstancesToFile(final AbstractFileSaver abstractFileSaver, final Instances instances) {
        if (this.m_IOThread == null) {
            this.m_IOThread = new Thread(){

                public void run() {
                    try {
                        PreprocessPanel.this.m_Log.statusMessage("Saving to file...");
                        abstractFileSaver.setInstances(instances);
                        abstractFileSaver.writeBatch();
                        PreprocessPanel.this.m_Log.statusMessage("OK");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        PreprocessPanel.this.m_Log.logMessage(exception.getMessage());
                    }
                    PreprocessPanel.this.m_IOThread = null;
                }
            };
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        } else {
            JOptionPane.showMessageDialog(this, "Can't save at this time,\ncurrently busy with other IO", "Saving instances", 2);
        }
    }

    public void setInstancesFromFileQ() {
        if (this.m_IOThread == null) {
            int n = this.m_FileChooser.showOpenDialog(this);
            if (n == 0) {
                try {
                    this.addUndoPoint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.m_FileChooser.getLoader() == null) {
                    JOptionPane.showMessageDialog(this, "Cannot determine file loader automatically, please choose one.", "Load Instances", 0);
                    this.converterQuery(this.m_FileChooser.getSelectedFile());
                } else {
                    this.setInstancesFromFile(this.m_FileChooser.getLoader());
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, "Can't load at this time,\ncurrently busy with other IO", "Load Instances", 2);
        }
    }

    public void setInstancesFromDBQ(String string, String string2, String string3, String string4) {
        if (this.m_IOThread == null) {
            try {
                InstanceQuery instanceQuery = new InstanceQuery();
                instanceQuery.setDatabaseURL(string);
                instanceQuery.setUsername(string2);
                instanceQuery.setPassword(string3);
                instanceQuery.setQuery(string4);
                if (instanceQuery.isConnected()) {
                    instanceQuery.disconnectFromDatabase();
                }
                instanceQuery.connectToDatabase();
                try {
                    this.addUndoPoint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.setInstancesFromDB(instanceQuery);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Problem connecting to database:\n" + exception.getMessage(), "Load Instances", 0);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Can't load at this time,\ncurrently busy with other IO", "Load Instances", 2);
        }
    }

    public void setInstancesFromURLQ() {
        block6: {
            if (this.m_IOThread == null) {
                try {
                    String string = (String)JOptionPane.showInputDialog(this, "Enter the source URL", "Load Instances", 3, null, null, this.m_LastURL);
                    if (string == null) break block6;
                    this.m_LastURL = string;
                    URL uRL = new URL(string);
                    try {
                        this.addUndoPoint();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.setInstancesFromURL(uRL);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(this, "Problem with URL:\n" + exception.getMessage(), "Load Instances", 0);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Can't load at this time,\ncurrently busy with other IO", "Load Instances", 2);
            }
        }
    }

    public void generateInstances() {
        if (this.m_IOThread == null) {
            this.m_IOThread = new Thread(){

                public void run() {
                    try {
                        final DataGeneratorPanel dataGeneratorPanel = new DataGeneratorPanel();
                        final JDialog jDialog = new JDialog();
                        JButton jButton = new JButton("Generate");
                        final JCheckBox jCheckBox = new JCheckBox("Show generated data as text, incl. comments");
                        jCheckBox.setMnemonic('S');
                        dataGeneratorPanel.setLog(PreprocessPanel.this.m_Log);
                        dataGeneratorPanel.setGenerator(PreprocessPanel.this.m_DataGenerator);
                        dataGeneratorPanel.setPreferredSize(new Dimension(300, (int)dataGeneratorPanel.getPreferredSize().getHeight()));
                        jButton.setMnemonic('G');
                        jButton.setToolTipText("Generates the dataset according the settings.");
                        jButton.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                boolean bl;
                                dataGeneratorPanel.execute();
                                boolean bl2 = bl = dataGeneratorPanel.getInstances() != null;
                                if (bl) {
                                    PreprocessPanel.this.setInstances(dataGeneratorPanel.getInstances());
                                }
                                jDialog.dispose();
                                PreprocessPanel.this.m_DataGenerator = dataGeneratorPanel.getGenerator();
                                if (bl && jCheckBox.isSelected()) {
                                    PreprocessPanel.this.showGeneratedInstances(dataGeneratorPanel.getOutput());
                                }
                            }
                        });
                        jDialog.setTitle("DataGenerator");
                        jDialog.getContentPane().add((Component)dataGeneratorPanel, "Center");
                        jDialog.getContentPane().add((Component)jButton, "East");
                        jDialog.getContentPane().add((Component)jCheckBox, "South");
                        jDialog.pack();
                        jDialog.setVisible(true);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        PreprocessPanel.this.m_Log.logMessage(exception.getMessage());
                    }
                    PreprocessPanel.this.m_IOThread = null;
                }
            };
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        } else {
            JOptionPane.showMessageDialog(this, "Can't generate data at this time,\ncurrently busy with other IO", "Generate Data", 2);
        }
    }

    protected void showGeneratedInstances(String string) {
        final JDialog jDialog = new JDialog();
        JButton jButton = new JButton("Save");
        JButton jButton2 = new JButton("Close");
        final JTextArea jTextArea = new JTextArea(string);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        jTextArea.setEditable(false);
        jTextArea.setFont(new Font("Monospaced", 0, jTextArea.getFont().getSize()));
        jButton.setMnemonic('S');
        jButton.setToolTipText("Saves the output to a file");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                int n = jFileChooser.showSaveDialog(jDialog);
                if (n == 0) {
                    try {
                        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(jFileChooser.getSelectedFile()));
                        bufferedWriter.write(jTextArea.getText());
                        bufferedWriter.flush();
                        bufferedWriter.close();
                        JOptionPane.showMessageDialog(jDialog, "Output successfully saved to file '" + jFileChooser.getSelectedFile() + "'!", "Information", 1);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    jDialog.dispose();
                }
            }
        });
        jButton2.setMnemonic('C');
        jButton2.setToolTipText("Closes the dialog");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jDialog.setTitle("Generated Instances (incl. comments)");
        jDialog.getContentPane().add((Component)new JScrollPane(jTextArea), "Center");
        jDialog.getContentPane().add((Component)jPanel, "South");
        jDialog.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (double)jDialog.getWidth() > dimension.getWidth() * 0.8 ? (int)(dimension.getWidth() * 0.8) : jDialog.getWidth();
        int n2 = (double)jDialog.getHeight() > dimension.getHeight() * 0.8 ? (int)(dimension.getHeight() * 0.8) : jDialog.getHeight();
        jDialog.setSize(n, n2);
        jDialog.setVisible(true);
    }

    private void converterQuery(final File file) {
        final GenericObjectEditor genericObjectEditor = new GenericObjectEditor(true);
        try {
            genericObjectEditor.setClassType(Loader.class);
            genericObjectEditor.setValue(new CSVLoader());
            ((GenericObjectEditor.GOEPanel)genericObjectEditor.getCustomEditor()).addOkListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PreprocessPanel.this.tryConverter((Loader)genericObjectEditor.getValue(), file);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        PropertyDialog propertyDialog = new PropertyDialog(genericObjectEditor, 100, 100);
    }

    private void tryConverter(final Loader loader, final File file) {
        if (this.m_IOThread == null) {
            this.m_IOThread = new Thread(){

                public void run() {
                    try {
                        loader.setSource(file);
                        Instances instances = loader.getDataSet();
                        PreprocessPanel.this.setInstances(instances);
                    }
                    catch (Exception exception) {
                        PreprocessPanel.this.m_Log.statusMessage(loader.getClass().getName() + " failed to load " + file.getName());
                        JOptionPane.showMessageDialog(PreprocessPanel.this, loader.getClass().getName() + " failed to load '" + file.getName() + "'.\n" + "Reason:\n" + exception.getMessage(), "Convert File", 0);
                        PreprocessPanel.this.m_IOThread = null;
                        PreprocessPanel.this.converterQuery(file);
                    }
                    PreprocessPanel.this.m_IOThread = null;
                }
            };
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        }
    }

    public void setInstancesFromFile(final AbstractFileLoader abstractFileLoader) {
        if (this.m_IOThread == null) {
            this.m_IOThread = new Thread(){

                public void run() {
                    block2: {
                        try {
                            PreprocessPanel.this.m_Log.statusMessage("Reading from file...");
                            Instances instances = abstractFileLoader.getDataSet();
                            PreprocessPanel.this.setInstances(instances);
                        }
                        catch (Exception exception) {
                            PreprocessPanel.this.m_Log.statusMessage("File '" + abstractFileLoader.retrieveFile() + "' not recognised as an '" + abstractFileLoader.getFileDescription() + "' file.");
                            PreprocessPanel.this.m_IOThread = null;
                            if (JOptionPane.showOptionDialog(PreprocessPanel.this, "File '" + abstractFileLoader.retrieveFile() + "' not recognised as an '" + abstractFileLoader.getFileDescription() + "' file.\n" + "Reason:\n" + exception.getMessage(), "Load Instances", 0, 0, null, new String[]{"OK", "Use Converter"}, null) != 1) break block2;
                            PreprocessPanel.this.converterQuery(abstractFileLoader.retrieveFile());
                        }
                    }
                    PreprocessPanel.this.m_IOThread = null;
                }
            };
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        } else {
            JOptionPane.showMessageDialog(this, "Can't load at this time,\ncurrently busy with other IO", "Load Instances", 2);
        }
    }

    public void setInstancesFromDB(final InstanceQuery instanceQuery) {
        if (this.m_IOThread == null) {
            this.m_IOThread = new Thread(){

                public void run() {
                    try {
                        PreprocessPanel.this.m_Log.statusMessage("Reading from database...");
                        final Instances instances = instanceQuery.retrieveInstances();
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                PreprocessPanel.this.setInstances(new Instances(instances));
                            }
                        });
                        instanceQuery.disconnectFromDatabase();
                    }
                    catch (Exception exception) {
                        PreprocessPanel.this.m_Log.statusMessage("Problem executing DB query " + PreprocessPanel.this.m_SQLQ);
                        JOptionPane.showMessageDialog(PreprocessPanel.this, "Couldn't read from database:\n" + exception.getMessage(), "Load Instances", 0);
                    }
                    PreprocessPanel.this.m_IOThread = null;
                }
            };
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        } else {
            JOptionPane.showMessageDialog(this, "Can't load at this time,\ncurrently busy with other IO", "Load Instances", 2);
        }
    }

    public void setInstancesFromURL(final URL uRL) {
        if (this.m_IOThread == null) {
            this.m_IOThread = new Thread(){

                public void run() {
                    try {
                        PreprocessPanel.this.m_Log.statusMessage("Reading from URL...");
                        AbstractFileLoader abstractFileLoader = ConverterUtils.getURLLoaderForFile(uRL.toString());
                        if (abstractFileLoader == null) {
                            throw new Exception("No suitable URLSourcedLoader found for URL!\n" + uRL);
                        }
                        ((URLSourcedLoader)((Object)abstractFileLoader)).setURL(uRL.toString());
                        PreprocessPanel.this.setInstances(abstractFileLoader.getDataSet());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        PreprocessPanel.this.m_Log.statusMessage("Problem reading " + uRL);
                        JOptionPane.showMessageDialog(PreprocessPanel.this, "Couldn't read from URL:\n" + uRL + "\n" + exception.getMessage(), "Load Instances", 0);
                    }
                    PreprocessPanel.this.m_IOThread = null;
                }
            };
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        } else {
            JOptionPane.showMessageDialog(this, "Can't load at this time,\ncurrently busy with other IO", "Load Instances", 2);
        }
    }

    public void addUndoPoint() throws Exception {
        if (this.m_Instances != null) {
            File file = File.createTempFile("weka", SerializedInstancesLoader.FILE_EXTENSION);
            file.deleteOnExit();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            objectOutputStream.writeObject(this.m_Instances);
            objectOutputStream.flush();
            objectOutputStream.close();
            if (this.m_tempUndoFiles[this.m_tempUndoIndex] != null) {
                this.m_tempUndoFiles[this.m_tempUndoIndex].delete();
            }
            this.m_tempUndoFiles[this.m_tempUndoIndex] = file;
            if (++this.m_tempUndoIndex >= this.m_tempUndoFiles.length) {
                this.m_tempUndoIndex = 0;
            }
            this.m_UndoBut.setEnabled(true);
        }
    }

    public void undo() {
        int n;
        if (--this.m_tempUndoIndex < 0) {
            this.m_tempUndoIndex = this.m_tempUndoFiles.length - 1;
        }
        if (this.m_tempUndoFiles[this.m_tempUndoIndex] != null) {
            AbstractFileLoader abstractFileLoader = ConverterUtils.getLoaderForFile(this.m_tempUndoFiles[this.m_tempUndoIndex]);
            try {
                abstractFileLoader.setFile(this.m_tempUndoFiles[this.m_tempUndoIndex]);
                this.setInstancesFromFile(abstractFileLoader);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.m_Log.logMessage(exception.toString());
                JOptionPane.showMessageDialog(this, "Cannot perform undo operation!\n" + exception.toString(), "Undo", 0);
            }
            this.m_tempUndoFiles[this.m_tempUndoIndex] = null;
        }
        if ((n = this.m_tempUndoIndex - 1) < 0) {
            n = this.m_tempUndoFiles.length - 1;
        }
        this.m_UndoBut.setEnabled(this.m_tempUndoFiles[n] != null);
    }

    public void edit() {
        int n = this.m_AttVisualizePanel.getColoringIndex();
        Instances instances = new Instances(this.m_Instances);
        instances.setClassIndex(n);
        ViewerDialog viewerDialog = new ViewerDialog(null);
        int n2 = viewerDialog.showDialog(instances);
        if (n2 == 0) {
            try {
                this.addUndoPoint();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Instances instances2 = viewerDialog.getInstances();
            if (this.m_Instances.classIndex() < 0) {
                instances2.setClassIndex(-1);
            }
            this.setInstances(instances2);
        }
    }

    public void setExplorer(Explorer explorer) {
        this.m_Explorer = explorer;
    }

    public Explorer getExplorer() {
        return this.m_Explorer;
    }

    protected void updateCapabilitiesFilter(Capabilities capabilities) {
        if (capabilities == null) {
            this.m_FilterEditor.setCapabilitiesFilter(new Capabilities(null));
            return;
        }
        capabilities.disable(Capabilities.Capability.NO_CLASS);
        capabilities.disableAllClasses();
        this.m_FilterEditor.setCapabilitiesFilter(capabilities);
    }

    public void capabilitiesFilterChanged(Explorer.CapabilitiesFilterChangeEvent capabilitiesFilterChangeEvent) {
        this.updateCapabilitiesFilter((Capabilities)capabilitiesFilterChangeEvent.getFilter().clone());
    }

    public static void main(String[] stringArray) {
        try {
            final JFrame jFrame = new JFrame("Weka Explorer: Preprocess");
            jFrame.getContentPane().setLayout(new BorderLayout());
            PreprocessPanel preprocessPanel = new PreprocessPanel();
            jFrame.getContentPane().add((Component)preprocessPanel, "Center");
            LogPanel logPanel = new LogPanel();
            preprocessPanel.setLog(logPanel);
            jFrame.getContentPane().add((Component)logPanel, "South");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setSize(800, 600);
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    static {
        GenericObjectEditor.registerEditors();
    }
}

