% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrometheeS4.R
\name{RPrometheeV}
\alias{RPrometheeV}
\alias{RPrometheeV,RPrometheeArguments-method}
\title{RPrometheeV}
\usage{
RPrometheeV(RPrometheeArguments, method = "PrometheeII")
}
\arguments{
\item{RPrometheeArguments}{An object with all RPromethee arguments. In
PROMETHEE V, the object must have the arguments \code{constraintDir} and
\code{bounds}, in order to create the subset of alternatives. See
\code{\link{RPrometheeConstructor}} for more information.}

\item{method}{a character object used to choose how the RPrometheeV is going
to be calculated. The method can be \code{"PrometheeII"} or
\code{"PrometheeIV"}. The standard is \code{"RPrometheeII"}.}
}
\value{
\itemize{
  \item{Phi} {The resulting net Phi from the alternatives for all
  criterias.}
  \item{Solution} {The solution resulting from linear programming problem.}
  \item{alternatives} {The alternatives names.}
  \item{criterias} {The criterias names.}
  \item{datMat} {The data used corresponding to criterias and alternatives.}
 }
}
\description{
PROMETHEE V deals with a subset of alternatives considerating a set of
  restrictions. First, the PROMETHEE II is calculated to get a complete
  pre-order. Then, binary linear programming is used to select a subset that
  maximizes the net outranking flow, according to restrictions. The first
  step can be calculated using PROMETHEE II or PROMETHEE IV, this is defined
  by the user through the argument \code{method}. The second step is done
  using the package \code{\link{lp}}.
}
\examples{
## Create objects for each argument
data <- matrix(c(5.2, -3.5,
                 4.3, -1.2,
                 6.7, -2.0,
                 5.4, -5.0,
                 4.8,  0.0,
                 2.8, -3.4), byrow = TRUE, ncol = 2)

parms <- matrix(c(1.0, 5.0), byrow = TRUE, ncol = 1, nrow = 2)
vecWeights <- c(0.3, 0.7)
vecMaximiz <- c(FALSE, TRUE)
prefFunction <- c(0, 0)
constraintDir <- rep("<=", ncol(data))
bounds <- c(7,-1)
normalize <- FALSE
alternatives <- c("Alt 1", "Alt 2", "Alt 3")

## Create RPrometheeArguments object
PromObj <- RPrometheeConstructor(datMat = data, vecWeights = vecWeights,
vecMaximiz = vecMaximiz, prefFunction = prefFunction, parms = parms,
normalize = normalize, alternatives = alternatives, bounds = bounds,
constraintDir = constraintDir)

## Run RPrometheeV using standard method ("RPrometheeII")
result <- RPrometheeV(PromObj)

## Run RPrometheeV using "RPrometheeIV
result <- RPrometheeV(PromObj, method = "RPrometheeIV")

## Updating alternatives name using UpdateRPrometheeAlternatives
newAlternatives <- c("A", "B", "C", "D", "E", "F")
result <- UpdateRPrometheeAlternatives(result, newAlternatives)

## Updating any argument using UpdateRPrometheeArguments
newBounds <- c(5, -2)
PromObj <- UpdateRPrometheeArguments(PromObj, "bounds", newBounds)
(result <- RPrometheeV(PromObj))
}
\references{
\itemize{

      \item
      M. Behzadian et al. \cr
      \emph{PROMETHEE: A comprehensive literature review on methodologies and
       applications}\cr
       European Journal of Operational Research v. 200, p.198-215, 2010.\cr
      \url{https://www.sciencedirect.com/science/article/abs/pii/S0377221709000071}
      \item
      J. P. Brans, Ph. Vincke\cr
      \emph{A Preference Ranking Organisation Method: (The PROMETHEE Method
      for Multiple Criteria Decision-Making)}\cr
      Management science, v. 31, n. 6, p. 647-656, 1985.\cr
      \url{https://pdfs.semanticscholar.org/edd6/f5ae9c1bfb2fdd5c9a5d66e56bdb22770460.pdf}

      \item
      J. P. Brans, B. Mareschal \cr
      \emph{Promethee V: MCDM Problems With Segmentation Constraints}\cr
      INFOR: Information Systems and Operational Research, v. 30, p. 85-96,
      1992.\cr
      \url{https://www.tandfonline.com/doi/abs/10.1080/03155986.1992.11732186}

      \item
      J. P. Brans, B. Mareschal \cr
      \emph{PROMETHEE methods. In: Figueria J, Greco S, Ehrgott M (eds)
      Multiple criteria decision analysis: state of the art surveys.}\cr
      Springer Science, Business Media Inc., Boston pp 163???195.\cr
      \url{http://www.springer.com/la/book/9780387230818}
   }
}
\seealso{
Other RPromethee methods: \code{\link{PrometheeIIIPlot}},
  \code{\link{PrometheeIIPlot}},
  \code{\link{PrometheeIPlot}},
  \code{\link{PrometheeIVPlot}},
  \code{\link{RPrometheeConstructor}},
  \code{\link{RPrometheeIII}}, \code{\link{RPrometheeII}},
  \code{\link{RPrometheeIVKernel}},
  \code{\link{RPrometheeIV}}, \code{\link{RPrometheeI}},
  \code{\link{SensitivityAnalysis}},
  \code{\link{UpdateRPrometheeAlternatives}},
  \code{\link{UpdateRPrometheeArguments}},
  \code{\link{WalkingWeightsPlot}},
  \code{\link{plot,RPrometheeI-method}}
}
\author{
Pedro Henrique Melo Albuquerque, \email{pedroa@unb.br}

Gustavo Monteiro Pereira, \email{monteirogustavop@gmail.com}
}
\keyword{decision-analysis}
\keyword{decision-method}
\keyword{mcda}
\keyword{promethee}
