% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Recommenders.R
\name{summary.MOA_recommender}
\alias{summary.MOA_recommender}
\title{Summary statistics of a MOA recommender}
\usage{
\method{summary}{MOA_recommender}(object, ...)
}
\arguments{
\item{object}{an object of class  \code{MOA_recommender}}

\item{...}{other arguments, currently not used yet}
}
\value{
the form of the return value depends on the type of MOA model
}
\description{
Summary statistics of a MOA recommender
}
\examples{
require(recommenderlab)
data(MovieLense)
x <- getData.frame(MovieLense)
x$itemid <- as.integer(as.factor(x$item))
x$userid <- as.integer(as.factor(x$user))
x$rating <- as.numeric(x$rating)
x <- head(x, 2000)

movielensestream <- datastream_dataframe(data=x)
movielensestream$get_points(3)

ctrl <- MOAoptions(model = "BRISMFPredictor", features = 10)
brism <- BRISMFPredictor(control=ctrl)
mymodel <- trainMOA(model = brism, rating ~ userid + itemid, 
 data = movielensestream, chunksize = 1000, trace=TRUE)

overview <- summary(mymodel$model)
str(overview)
predict(mymodel, head(x, 10), type = "response")
}
