% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMVL.R
\name{mvl_remap}
\alias{mvl_remap}
\title{Enlarge memory map to include recently loaded data.}
\usage{
mvl_remap(MVLHANDLE, append = TRUE)
}
\arguments{
\item{MVLHANDLE}{handle to opened MVL file as generated by \code{mvl_open()} or \code{mvl_remap()}}

\item{append}{specify FALSE when you do not intend to write the file.}
}
\value{
handle to MVL file, with updated directory.
}
\description{
This function operates on MVL files opened for writing. When writing new data to the MVL file that data is appended at the end and past the end of previously mapped data. 
Calling \code{mvl_remap()} updates the memory mapping to include all the data written before mvl_remap() was called.
The MVL file directory is also updated to include recently added entries.  Old handles can still be used, but will not include updated directory information.
MVL_OBJECT's previously obtained from this handle continue to be valid.
}
\details{
\code{mvl_remap} returns a handle with updated directory.
}
\examples{
\dontrun{
Mtmp<-mvl_open("tmp_a.mvl", append=TRUE, create=TRUE)
mvl_write_object(Mtmp, runif(100), "vec1")
Mtmp<-mvl_remap(Mtmp)
print(Mtmp["vec1"])
}
}
\seealso{
\code{\link{mvl_open}}, \code{\link{mvl_close}}
}
