/*
 * Decompiled with CFR 0.152.
 */
package org.bson.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassMap<T>
implements Map<Class, T> {
    private Map<Class, T> _internalMap = new HashMap<Class, T>();
    private Map<Class, T> _cache = new HashMap<Class, T>();
    private static Map<Class, List<Class>> _ancestryCache = new HashMap<Class, List<Class>>();

    protected Map<Class, T> getInternalMap() {
        return this._internalMap;
    }

    private void setInternalMap(Map m) {
        this._internalMap = m;
    }

    protected Map<Class, T> getCache() {
        return this._cache;
    }

    private void setCache(Map m) {
        this._cache = m;
    }

    @Override
    public synchronized int size() {
        return this.getCache().size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.getCache().isEmpty();
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    protected synchronized boolean cacheContainsKey(Object key) {
        return this.getCache().containsKey(key);
    }

    @Override
    public synchronized boolean containsValue(Object object) {
        return this.getCache().containsValue(object);
    }

    @Override
    public synchronized T get(Object key) {
        Class c = (Class)key;
        Map<Class, T> cache = this.getCache();
        if (cache.containsKey(c)) {
            return cache.get(c);
        }
        T result2 = this.computeValue(c);
        cache.put(c, result2);
        return result2;
    }

    @Override
    public synchronized T put(Class key, T value) {
        T result2 = this.getInternalMap().put(key, value);
        this.initCache();
        return result2;
    }

    @Override
    public synchronized T remove(Object object) {
        T result2 = this.getInternalMap().remove(object);
        this.initCache();
        return result2;
    }

    @Override
    public synchronized void putAll(Map map2) {
        this.getInternalMap().putAll(map2);
        this.initCache();
    }

    @Override
    public synchronized void clear() {
        this.getInternalMap().clear();
        this.initCache();
    }

    @Override
    public synchronized Set<Class> keySet() {
        return this.getCache().keySet();
    }

    @Override
    public synchronized Collection<T> values() {
        return this.getCache().values();
    }

    @Override
    public synchronized Set<Map.Entry<Class, T>> entrySet() {
        return this.getCache().entrySet();
    }

    @Override
    public boolean equals(Object object) {
        try {
            ClassMap that = (ClassMap)object;
            return ((Object)this.getInternalMap()).equals(that.getInternalMap());
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return ((Object)this.getInternalMap()).hashCode();
    }

    private T computeValue(Class key) {
        List<Class> ancestry = ClassMap.getAncestry(key);
        Map<Class, T> map2 = this.getCache();
        for (Class c : ancestry) {
            if (!map2.containsKey(c)) continue;
            T value = map2.get(c);
            return value;
        }
        return null;
    }

    protected void initCache() {
        Map<Class, T> cache = this.getCache();
        cache.clear();
        cache.putAll(this.getInternalMap());
    }

    public String toString() {
        return this.getCache().toString();
    }

    public static List<Class> getAncestry(Class c) {
        ArrayList<Class> result2 = null;
        Map cache = ClassMap.getClassAncestryCache();
        ArrayList<Class> cachedResult = (ArrayList<Class>)cache.get(c);
        if (cachedResult != null) {
            result2 = cachedResult;
        } else {
            result2 = new ArrayList<Class>();
            List<Class> ancestry = ClassMap.computeAncestry(c);
            int size2 = ancestry.size();
            for (int i = 0; i < size2; ++i) {
                result2.add(ancestry.get(size2 - i - 1));
            }
            cache.put(c, result2);
        }
        return result2;
    }

    private static List<Class> computeAncestry(Class c) {
        ArrayList<Class> result2 = new ArrayList<Class>();
        result2.add(Object.class);
        ClassMap.computeAncestry(c, result2);
        return result2;
    }

    private static void computeAncestry(Class c, List result2) {
        if (c == null || c == Object.class) {
            return;
        }
        Class<?>[] interfaces = c.getInterfaces();
        for (int i = interfaces.length - 1; i >= 0; --i) {
            ClassMap.computeAncestry(interfaces[i], result2);
        }
        ClassMap.computeAncestry(c.getSuperclass(), result2);
        if (!result2.contains(c)) {
            result2.add(c);
        }
    }

    private static Map getClassAncestryCache() {
        return _ancestryCache;
    }

    private static void setClassAncestryCache(Map m) {
        _ancestryCache = m;
    }
}

