% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RankNormal.R
\name{BAT}
\alias{BAT}
\title{Basic Association Test}
\usage{
BAT(y, G, X, S)
}
\arguments{
\item{y}{Numeric phenotype vector.}

\item{G}{Snp by obs genotype matrix.}

\item{X}{Obs by feature covariate matrix.}

\item{S}{Obs by feature structure matrix.}
}
\value{
A numeric vector of p-values assessing the null hypothesis of no 
  genotypic effect. P-values are estimated using the Wald statistic, and 
  correspond to the rows of G.
}
\description{
Regression of the untransformed phenotype on genotype, covariates, and 
adjustments for population structure.
}
\examples{
# BAT against normal phenotype
p = RNOmni::BAT(y=RNOmni::Y[,1],G=RNOmni::G[1:10,],X=RNOmni::X,S=RNOmni::S);
}
