% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Omnibus.R
\name{RNOmni}
\alias{RNOmni}
\title{Rank-Normal Omnibus Test}
\usage{
RNOmni(y, G, X = NULL, method = "AvgCorr", k = 3/8, B = 100,
  set.rho = NULL, keep.rho = F, keep.stats = F, parallel = F)
}
\arguments{
\item{y}{Numeric phenotype vector.}

\item{G}{Obs by locus genotype matrix.}

\item{X}{Model matrix of covariates and structure adjustments. Should include
an intercept. Omit to perform marginal tests of association.}

\item{method}{Method used to estimate correlation for the omnibus test, 
either "AvgCorr", "Bootstrap", or "Manual".}

\item{k}{Offset applied during rank-normalization. See 
\code{\link{rankNorm}}.}

\item{B}{If using \code{method=="Bootstrap"}, number of bootstrap samples for
correlation estimation.}

\item{set.rho}{If using \code{method=="Manual"}, the fixed value of rho, 
either a single value or a vector with one element per column in \code{G}.}

\item{keep.rho}{Logical indicating whether to return the correlation 
parameter estimated during omnibus calculation. Defaults to FALSE.}

\item{keep.stats}{Logical indicating whether to return the interim test 
statistics calculated by DINT and IINT. Defaults to FALSE.}

\item{parallel}{Logical indicating whether to run in parallel. Must register 
parallel backend first.}
}
\value{
A numeric matrix of p-values, three for each locus in \code{G}, 
  assessing the null hypothesis of no genetic effect. If \code{keep.stats=T},
  the interim test statistics are retained. If \code{keep.rho=T}, the
  correlation between the p-values provided by DINT and IINT is retained.
}
\description{
Association test that synthesizes the \code{\link{DINT}} and 
\code{\link{IINT}} methods. The first approach directly transforms the 
phenotype, whereas the second approach forms residuals prior to applying the 
rank normal transformation (\code{\link{rankNorm}}). In the omnibus test, the
direct and indirect tests are separately applied. An omnibus statistic is 
calculated based on whichever approach provides more evidence against the 
null hypothesis. Details of the method are discussed in the vignette.
}
\details{
Assigning a p-value to the omnibus statistic requires an estimate of the 
correlation between the test statistics estimated by \code{DINT} and 
\code{IINT} under the null. When many loci are under consideration, a 
computationally efficient approach is to take the correlation of the observed
test statistics across loci (\code{method="AvgCorr"}). Alternatively, when 
there are fewer loci, or locus-specific estimates are desired, the 
correlation may be estimated using bootstrap (\code{method="Bootstrap"}). 
When using the bootstrap approach, consider registering a parallel backend 
and setting \code{parallel=T}. To manually provide an estimate of the 
correlation between the test statistics, set (\code{method="Manual"}) and 
specify (\code{set.rho}).
}
\examples{
\dontrun{
set.seed(100);
# Design matrix
X = cbind(1,rnorm(1e3));
# Genotypes
G = replicate(1e3,rbinom(n=1e3,size=2,prob=0.25));
storage.mode(G) = "numeric";
# Phenotype
y = exp(as.numeric(X\%*\%c(1,1))+rnorm(1e3));
# Average correlation
p = RNOmni(y=y,G=G,X=X,method="AvgCorr");
# Bootstrap correlation
p = RNOmni(y=y,G=G[,1:10],X=X,method="Bootstrap",B=100);
# Manual correlation
p = RNOmni(y=y,G=G,X=X,method="Manual",set.rho=0.5);
}
}
