% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotWindRose.R
\name{plotSCAN.windrose}
\alias{plotSCAN.windrose}
\title{plotSCAN.windrose}
\usage{
plotSCAN.windrose(scan_site, DayBgn, DayEnd, speed_bins = 10, dir_bins = 15,
  units = c("metric", "imperial"))
}
\arguments{
\item{scan_site}{The numeric ID for a valid SCAN site.\cr}

\item{DayBgn}{Specify the beginning date (as YYYY-MM-DD ) for the returned data.\cr}

\item{DayEnd}{Specify the end date (as YYYY-MM-DD ) for the returned data.\cr}

\item{speed_bins}{Optional. The number of bins to return wind speeds in. Defaults to 10.\cr}

\item{dir_bins}{Optional. The number of bins to return wind directions. Defaults to 36 bins (10 degree increments). \cr}

\item{units}{Optional. The format speed data are returned in (either "metric" or "imperial").}
}
\value{
Returns a wind rose for the requested parameters as a ggplot2 object.\cr
}
\description{
A wind rose plotting function for SCAN sites. For a given SCAN site ID, and requested period, a wind rose is output.
}
\examples{
#Returns a wind rose for Nunn #1, for data for the period between Jan 1, 2017 and Feb 1, 2017.
\dontrun{
plotSCAN.windrose(scan_site = 2017, DayBgn = "2017-01-01", DayEnd = "2017-02-01")
}
}
\references{
Downloads <https://wcc.sc.egov.usda.gov/reportGenerator>
}
\seealso{
grabNRCS.data()
}
\author{
Robert Lee \email{rhlee@colorado.edu}
}
\keyword{atmopsheric}
\keyword{atmosphere,}
\keyword{climate,}
\keyword{data,}
\keyword{environment,}
\keyword{environmental}
\keyword{in-situ,}
\keyword{rose\cr}
\keyword{weather,}
\keyword{wind}
\keyword{wind,}
