% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/add_namespaces.R
\name{add_namespaces}
\alias{add_namespaces}
\title{add namespaces}
\usage{
add_namespaces(namespaces, nexml = new("nexml"))
}
\arguments{
\item{namespaces}{a named character vector of namespaces}

\item{nexml}{a nexml object. will create a new one if none is given.}
}
\value{
a nexml object with updated namespaces
}
\description{
add namespaces, avoiding duplication if prefix is already defined
}
\examples{
## Create a new nexml object with a single metadata element:
modified <- meta(property = "prism:modificationDate", content = "2013-10-04")
nex <- add_meta(modified) # Note: 'prism' is defined in nexml_namespaces by default.

## Write multiple metadata elements, including a new namespace:
website <- meta(href = "http://carlboettiger.info",
                rel = "foaf:homepage")              # meta can be link-style metadata
nex <- add_meta(list(modified,  website),
                namespaces = c(foaf = "http://xmlns.com/foaf/0.1/"))

## Append more metadata, and specify a level:
history <- meta(property = "skos:historyNote",
                 content = "Mapped from the bird.orders data in the ape package using RNeXML")
nex <- add_meta(history,
                nexml = nex,
                level = "trees",
                namespaces = c(skos = "http://www.w3.org/2004/02/skos/core#"))
}
\seealso{
\code{\link{meta}} \code{\link{add_meta}}
}

