% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networks.r
\name{document.network.plot}
\alias{document.network.plot}
\title{Visualize (a subcomponent) of the document similarity network}
\usage{
document.network.plot(g, date.attribute = "date",
  source.attribute = "source", subcomp_i = NULL, dtm = NULL,
  sources = NULL, only.outer.date = FALSE,
  date.format = "\%Y-\%m-\%d \%H:\%M", margins = c(5, 8, 1, 13),
  isolate.color = NULL, source.loops = TRUE, ...)
}
\arguments{
\item{g}{A document similarity network, as created with \link[RNewsflow]{newsflow.compare} or \link[RNewsflow]{document.network}}

\item{date.attribute}{The label of the vertex/document date attribute. Default is "date"}

\item{source.attribute}{The label of the vertex/document source attribute. Default is "source"}

\item{subcomp_i}{Optional. If an integer is given, the network is decomposed into subcomponents (i.e. unconnected components) and only the i-th component is visualized.}

\item{dtm}{Optional. If a document-term matrix that contains the documents in g is given, a wordcloud with the most common words of the network is added.}

\item{sources}{Optional. Use a character vector to select only certain sources}

\item{only.outer.date}{If TRUE, only the labels for the first and last date are reported on the x-axis}

\item{date.format}{The date format of the date labels (see \link[base]{format.POSIXct})}

\item{margins}{The margins of the network plot. The four values represent bottom, left, top and right margin.}

\item{isolate.color}{Optional. Set a custom color for isolates}

\item{source.loops}{If set to FALSE, all edges between vertices/documents of the same source are ignored.}

\item{...}{Additional arguments for the network plotting function \link[igraph]{plot.igraph}}
}
\value{
Nothing.
}
\description{
Visualize (a subcomponent) of the document similarity network
}
\examples{
data(docnet)
data(dtm)

docnet_comps = igraph::decompose.graph(docnet) # get subcomponents

# subcomponent 1
document.network.plot(docnet_comps[[1]]) 

# subcomponent 2 with wordcloud
document.network.plot(docnet_comps[[2]], dtm=dtm) 

# subcomponent 3 with additional arguments passed to plot.igraph 
document.network.plot(docnet_comps[[3]], dtm=dtm, vertex.color='red') 
}

