% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networks.r
\name{only_first_match}
\alias{only_first_match}
\title{Transform document network so that each document only matches the earliest dated matching document}
\usage{
only_first_match(g)
}
\arguments{
\item{g}{A document similarity network, as created with \link[RNewsflow]{newsflow_compare} or \link[RNewsflow]{create_document_network}}
}
\value{
A network/graph in the \link[igraph]{igraph} class
}
\description{
Transforms the network so that a document only has an edge to the earliest dated document it matches within the specified time window[^duplicate].
}
\details{
If there are multiple earliest dated documents (that is, having the same publication date) then edges to all earliest dated documents are kept.
}
\examples{
data(docnet)

subcomp1 = igraph::decompose.graph(docnet)[[2]]
subcomp2 = only_first_match(subcomp1)

igraph::get.data.frame(subcomp1)
igraph::get.data.frame(subcomp2)

graphics::par(mfrow=c(2,1))
document_network_plot(subcomp1, main='All matches')
document_network_plot(subcomp2, main='Only first match')
graphics::par(mfrow=c(1,1))
}
