% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nifti.R
\name{readNifti}
\alias{readNifti}
\title{Read a NIfTI-1 format file}
\usage{
readNifti(file, internal = FALSE)
}
\arguments{
\item{file}{A character vector of file names.}

\item{internal}{Logical value. If \code{FALSE} (the default), an array
of class \code{"niftiImage"}, containing the image pixel or voxel values,
will be returned. If \code{TRUE}, the return value will be an object of
class \code{"internalImage"}, which contains only minimal metadata about
the image. Either way, the return value has an attribute which points to a
C data structure containing the full image.}
}
\value{
An array or internal image, with class \code{"niftiImage"}, and
  possibly also \code{"internalImage"}.
}
\description{
This function reads one or more NIfTI-1 files into R, using the standard
NIfTI-1 C library.
}
\note{
If the \code{internal} argument is \code{FALSE} (the default), the
  data type of the image pointer will be set to match one of R's native
  numeric data types, i.e., 32-bit signed integer or 64-bit double-precision
  floating-point. In these circumstances the data type reported by the
  \code{\link{dumpNifti}} function will therefore not, in general, match
  the storage type used in the file. See also the \code{datatype} argument
  to \code{\link{writeNifti}}.
}
\author{
Jon Clayden <code@clayden.org>
}
\references{
The NIfTI-1 standard (\url{http://nifti.nimh.nih.gov/nifti-1}).
}
\seealso{
\code{\link{writeNifti}}
}

