% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqlPrepare.R
\name{sqlPrepare}
\alias{sqlPrepare}
\title{Prepares a query for execution}
\usage{
sqlPrepare(channel, query, errors = TRUE, query_timeout = NULL)
}
\arguments{
\item{channel}{ODBC connection obtained by \link{odbcConnect}}

\item{query}{query string}

\item{errors}{whether to display errors}

\item{query_timeout}{the query timeout value in seconds
(0 means "no timeout", NULL does not change the default value)}
}
\value{
invisible(1) on success, -1 or an error (depending on errors parameter) on error
}
\description{
Prepares a query for execution.
}
\examples{
\dontrun{
  conn = odbcConnect('MyDataSource')
  
  sqlPrepare(conn, "SELECT * FROM myTable WHERE column = ?")
  sqlExecute(conn, NULL, 'myValue')
  sqlFetchMore(conn)
  
  # with a query timeout
  sqlPrepare(conn, "SELECT * FROM myTable WHERE column = ?", query_timeout=60)
  sqlExecute(conn, data='myValue', fetch=TRUE)
}
}

