% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miplib.R
\name{miplib_download}
\alias{miplib_download}
\alias{miplib_download_all}
\alias{miplib_download_benchmark}
\alias{miplib_download}
\alias{miplib_download_metainfo}
\title{Download the 'MIPLIB 2010' Test Problem Set}
\usage{

  miplib_download_all(url = "http://miplib.zib.de/download/miplib2010-complete.tgz",
  folder = system.file("roi_op", package = "ROI.models.miplib"),
  method = NULL, quiet = TRUE)


  miplib_download_benchmark(
  url = "http://miplib.zib.de/download/miplib2010-benchmark.tgz",
  folder = system.file("roi_op", package = "ROI.models.miplib"),
  method = NULL, quiet = TRUE)


  miplib_download_metainfo(url = "http://miplib.zib.de/download/miplib2010_all.solu",
  folder = system.file("roi_op", package = "ROI.models.miplib"))
}
\arguments{
\item{url}{a character giving the url to \code{MIPLIB 2010}.}

\item{folder}{an optional character giving the location where the
\code{MIPLIB 2010} test problem set should be downloaded to.}

\item{method}{a character giving the method to be used for downloading
files, for more information see \code{\link{download.file}}.}

\item{quiet}{a logical giving if status status messages should be suppressed.}
}
\description{
The \code{MIPLIB 2010} test problem set is downloaded and
    transformed from the \code{MPS} format into the \pkg{ROI} format.
    The results are stored as \code{'.rds'} files at the location provided 
    via the parameter \code{folder}.
}
\details{
\itemize{
        \item{\code{miplib_download_all} download all MIPLIB-2010 instances (arround 1.3 GB).}

        \item{\code{miplib_download_benchmark} download the MIPLIB-2010 benchmark instances (arround 94 MB).}

        \item{\code{miplib_download_metinfo} download the available meta information.}
     }
}
\examples{
\dontrun{

## download all MIPLIB-2010 instances (arround 1.3 GB)
miplib_download_all()
## or
miplib_download_all(folder = "data/miplib")

## download MIPLIB-2010 benchmark instances (arround 94 MB)
miplib_download_benchmark()
## or 
miplib_download_benchmark(folder = "data/miplib")

## download meta information
miplib_download_metinfo()
}
}
