% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.lm.rrpp.r
\name{predict.lm.rrpp}
\alias{predict.lm.rrpp}
\title{predict for lm.rrpp model fits}
\usage{
\method{predict}{lm.rrpp}(object, newdata = NULL, block = NULL, confidence = 0.95, ...)
}
\arguments{
\item{object}{Object from \code{\link{lm.rrpp}}.}

\item{newdata}{Data frame of either class \code{\link{data.frame}} 
or \code{\link{rrpp.data.frame}}.  If null,
the data frame from the lm.rrpp fit will be used, effectively calculating 
all fitted values and
their confidence intervals.  If a numeric variable is missing from newdata, 
an attempt to average the values
will be made in prediction; i.e., least squares means for factor levels 
can be found.  All factors used in the
\code{\link{lm.rrpp}} fit should be represented in the newdata data frame, 
with appropriate factor levels.}

\item{block}{An optional factor for blocks within which to restrict resampling
permutations.}

\item{confidence}{The desired confidence interval level for prediction.}

\item{...}{Other arguments (currently none)}
}
\description{
Computes predicted values from an \code{\link{lm.rrpp}} 
model fit, using bootstrapped residuals
to generate confidence intervals.  (Residuals are the residuals of 
the lm.rppp fit, not its null model.  The bootstrap
procedure resamples residual vectors with replacement.)
The bootstrap permutations use the same number of iterations and 
seed as used
in the \code{\link{lm.rrpp}} model fit. A \code{\link{predict.lm.rrpp}} 
object can be plotted using various options.
See \code{\link{plot.predict.lm.rrpp}}.

Note that if data offsets are used (if the offset argument is used 
when fitting a \code{\link{lm.rrpp}} model),
they are ignored for estimating coefficients over iterations.  
Offsets are subtracted from data in \code{\link[stats]{lm}} and 
added to predicted values in \code{\link[stats]{predict.lm}}, 
effectively adjusting the intercept and then un-adjusting
it for predictions.  This causes problems if the newdata have a 
different number of observations than the original
model fit.
}
\examples{
\dontrun{
# See examples for lm.rrpp to see how predict.lm.rrpp works in conjunction
# with other functions

data(Pupfish)

# CS is centroid (fish) size
fit <- lm.rrpp(coords ~ log(CS)  + Sex*Pop, 
SS.type = "I", data = Pupfish, iter = 999) 

# Predictions (holding alternative effects constant)

shapeDF <- expand.grid(Sex = levels(Pupfish$Sex), Pop = levels(Pupfish$Pop))
rownames(shapeDF) <- paste(shapeDF$Sex, shapeDF$Pop, sep = ".")
shapeDF

shapePreds <- predict(fit, shapeDF)
summary(shapePreds)
summary(shapePreds, PC = TRUE)

shapePreds99 <- predict(fit, shapeDF, confidence = 0.99)
summary(shapePreds99, PC = TRUE)

# Plot prediction

plot(shapePreds, PC = TRUE)
plot(shapePreds, PC = TRUE, ellipse = TRUE)
plot(shapePreds99, PC = TRUE)
plot(shapePreds99, PC = TRUE, ellipse = TRUE)
}

}
\author{
Michael Collyer
}
\keyword{utilities}
