% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RRPP.utils.r
\name{plot.measurement.error}
\alias{plot.measurement.error}
\title{Plot Function for RRPP}
\usage{
\method{plot}{measurement.error}(
  x,
  separate.by.groups = TRUE,
  add.connectors = TRUE,
  add.labels = FALSE,
  use.std.vectors = FALSE,
  titles = NULL,
  add.legend = TRUE,
  ...
)
}
\arguments{
\item{x}{Object from \code{\link{measurement.error}}}

\item{separate.by.groups}{A logical value for whether to make separate plots
for each group, if different groups are available.  If FALSE, groups
are still represented by different symbols in the plot, unless overridden
by plot arguments.}

\item{add.connectors}{A logical value for whether to add connectors, like
vectors, between replicate observations of the same subjects.}

\item{add.labels}{A logical value for whether to label subjects.
Labels are either subject name (if available) or number of occurrence
in the data set.}

\item{use.std.vectors}{A logical value for whether to use vectors obtained from
a standardized matrix, which are orthogonal.  This is not strictly necessary.}

\item{titles}{An optional vector or list for augmenting the titles of plots produced.
The length of the vector or list should match the number of plots produced by 
other arguments.}

\item{add.legend}{A logical value for whether to add a legend to plots.  If
separate.by.groups is TRUE, adding a legend to plots will be slightly redundant. If
certain parameters are augmented by user (point characters, colors), add.legend
will be made to be FALSE to prevent misinterpretation of intended plotting scheme.}

\item{...}{Other arguments passed onto plot}
}
\description{
This function produces multivariate signal-to-noise ratio plots for  
\code{\link{measurement.error}} objects.  See the function, 
\code{\link{plot.interSubVar}} for plotting the inter-subject variability
from a \code{\link{measurement.error}} object, after applying the function, 
\code{\link{interSubVar}}.
}
\author{
Michael Collyer
}
\keyword{utilities}
