% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.paths.R
\name{node.paths}
\alias{node.paths}
\title{Tracing nodes along paths}
\usage{
node.paths(tree, vec)
}
\arguments{
\item{tree}{a phylogenetic tree. The tree needs not to be ultrametric and
fully dichotomous.}

\item{vec}{a vector of node numbers}
}
\value{
A list of node paths, each starting from the youngest node (i.e.
 furthest from the tree root) and ending to the oldest along the path.
}
\description{
Given a vector of nodes, the function collates nodes along
 individual lineages from the youngest (i.e. furthest from the tree root) to
 the oldest.
}
\examples{
require(ape)

rtree(100)->tree
sample(seq(Ntip(tree)+1,Ntip(tree)+Nnode(tree)),20)->nods
plot(tree,show.tip.label=FALSE)
nodelabels(node=nods,frame="n",col="red")
node.paths(tree=tree, vec=nods)->np
}
\author{
Silvia Castiglione, Pasquale Raia
}
