/*
 * Decompiled with CFR 0.152.
 */
package org.act.cat;

import org.act.cat.CatFunctions;
import org.act.cat.ItemScores;
import org.act.cat.ScoringMethod;
import org.act.cat.ScoringMethodConfigEap;
import org.act.cat.ThetaEst;
import org.act.util.ProbDistribution;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealMatrix;

public class ScoringMethodEap
implements ScoringMethod {
    private RealMatrix itemPar;
    private ItemScores itemScores;
    private int nQuad;
    private double minQuad;
    private double maxQuad;
    private ProbDistribution priorDistribution;

    public ScoringMethodEap(RealMatrix itemPar, ItemScores itemScores, ScoringMethodConfigEap config) {
        this.itemPar = itemPar;
        this.itemScores = itemScores;
        this.nQuad = config.getNumQuad();
        this.minQuad = config.getMinQuad();
        this.maxQuad = config.getMaxQuad();
        this.priorDistribution = config.getPriorDistribution();
    }

    @Override
    public ThetaEst estimateTheta() {
        int q;
        int parNum = this.itemPar.getRowDimension();
        ArrayRealVector quadPoints = new ArrayRealVector(this.nQuad);
        ArrayRealVector densities = new ArrayRealVector(this.nQuad);
        ArrayRealVector denominatorVec = new ArrayRealVector(this.nQuad);
        double numeratorTheta = 0.0;
        double numeratorSD = 0.0;
        double denominator = 0.0;
        double sumDensities = 0.0;
        for (q = 0; q < this.nQuad; ++q) {
            double qPoint = (double)q * (this.maxQuad - this.minQuad) / ((double)this.nQuad - 1.0) + this.minQuad;
            quadPoints.addToEntry(q, qPoint);
            densities.addToEntry(q, this.priorDistribution.density(quadPoints.getEntry(q)));
            sumDensities += densities.getEntry(q);
        }
        densities = densities.mapDivide(sumDensities);
        for (q = 0; q < this.nQuad; ++q) {
            double likelihood = 1.0;
            for (int i = 0; i < parNum; ++i) {
                double a = this.itemPar.getEntry(i, 0);
                double b = this.itemPar.getEntry(i, 1);
                double c = this.itemPar.getEntry(i, 2);
                double d = this.itemPar.getEntry(i, 3);
                double p = CatFunctions.getProb3PL(a, b, c, d, quadPoints.getEntry(q));
                double pResp = Math.pow(1.0 - p, 1.0 - (double)this.itemScores.getItemScores()[i]) * Math.pow(p, this.itemScores.getItemScores()[i]);
                likelihood *= pResp;
            }
            numeratorTheta += quadPoints.getEntry(q) * likelihood * densities.getEntry(q);
            denominator += likelihood * densities.getEntry(q);
            denominatorVec.addToEntry(q, likelihood * densities.getEntry(q));
        }
        double postMean = numeratorTheta / denominator;
        for (int q2 = 0; q2 < this.nQuad; ++q2) {
            numeratorSD += Math.pow(quadPoints.getEntry(q2) - postMean, 2.0) * denominatorVec.getEntry(q2);
        }
        double postSd = Math.pow(numeratorSD / denominator, 0.5);
        ThetaEst thetaEst = new ThetaEst(postMean, postSd);
        return thetaEst;
    }

    @Override
    public ScoringMethod.SUPPORTED_METHODS scoringMethodType() {
        return ScoringMethod.SUPPORTED_METHODS.EAP;
    }
}

