\name{sym.lm.bi}
\alias{sym.lm.bi}
\title{
Symbolic Linear Regression for two variables
}
\description{
The function build a symbolic regression for two interval or continuos variables.
}
\usage{
sym.lm.bi(sym.var.x, sym.var.y, method = c("mid-points", "tops", "inf-sup", 
                 "billard"))
}
\arguments{
  \item{sym.var.x}{
The firth symbolic variable.
}
  \item{sym.var.y}{
The second symbolic variable.
}
  \item{method}{
The thirth symbolic variable.
}
}

\value{
This function return a regression structure as folllows:

$Intercept
[1] 38.64236

$Beta1
[1] 0.3081313
}
\references{
Billard L. and  Diday E. (2006).
Symbolic data analysis: Conceptual statistics and data mining. Wiley, Chichester.

Rodriguez, O. (2000).
Classification et Modeles Lineaires en Analyse des Donnees Symboliques. Ph.D. Thesis,
Paris IX-Dauphine University.
}
\author{
Oldemar Rodriguez Rojas
}
\examples{
data(example3)
sym.data<-example3
lm.mod<-sym.lm.bi(sym.var(sym.data,1),sym.var(sym.data,4))
sym.scatterplot(sym.var(sym.data,1),sym.var(sym.data,4),col='blue',
                main='Linear Regression')
abline(lm.mod,lwd=3)

lm.mod<-sym.lm.bi(sym.var(sym.data,2),sym.var(sym.data,6))
sym.scatterplot(sym.var(sym.data,2),sym.var(sym.data,6),
col='blue',main='Linear Regression')
abline(lm.mod,lwd=3)

data(lynne1)
lm.mod<-sym.lm.bi(sym.var(lynne1,2),sym.var(lynne1,1))
sym.scatterplot(sym.var(lynne1,2),sym.var(lynne1,1),labels=TRUE, 
col='red',main='Linear Regression')
abline(lm.mod,lwd=3,col='blue')

lm.mod<-sym.lm.bi(sym.var(lynne1,2),sym.var(lynne1,1),method='inf-sup')
sym.scatterplot(sym.var(lynne1,2),sym.var(lynne1,1),labels=TRUE,
col='red',main='Linear Regression')
abline(lm.mod$inf,lwd=3,col='blue')
abline(lm.mod$sup,lwd=3,col='blue')

lm.mod<-sym.lm.bi(sym.var(lynne1,2),sym.var(lynne1,1),method='tops')
sym.scatterplot(sym.var(lynne1,2),sym.var(lynne1,1),labels=TRUE,
col='red',main='Linear Regression')
abline(lm.mod,lwd=3,col='blue')

lm.mod<-sym.lm.bi(sym.var(lynne1,2),sym.var(lynne1,1),method='billard')
sym.scatterplot(sym.var(lynne1,2),sym.var(lynne1,1),labels=TRUE,
col='red',main='Linear Regression')
abline(lm.mod$Intercept,lm.mod$Beta1,lwd=3,col='blue')
}
\keyword{ Symbolic }
\keyword{ Regression }% __ONLY ONE__ keyword per line