% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sym.cor.R
\name{sym.cor}
\alias{sym.cor}
\title{Symbolic Correlation}
\usage{
sym.cor(sym.var.x, sym.var.y, method = c('centers', 'interval', 'billard', 'modal')
, na.rm = FALSE, ...)
}
\arguments{
\item{sym.var.x}{First symbolic variables.}

\item{sym.var.y}{Second symbolic variables.}

\item{method}{The method to be use.}

\item{na.rm}{As in R cor function.}

\item{...}{As in R cor function.}
}
\value{
Return a real number in [-1,1].
}
\description{
This function compute the symbolic correlation
}
\examples{
data(example3)
sym.data<-example3
sym.cor(sym.var(sym.data,1),sym.var(sym.data,4),method='centers')
sym.cor(sym.var(sym.data,2),sym.var(sym.data,6),method='centers')
sym.cor(sym.var(sym.data,2),sym.var(sym.data,6),method='billard')
}
\references{
Billard L. and  Diday E. (2006).
Symbolic data analysis: Conceptual statistics and data mining. Wiley, Chichester.

Rodriguez, O. (2000).
Classification et Modeles Lineaires en Analyse des Donnees Symboliques. Ph.D. Thesis,
Paris IX-Dauphine University.
}
\author{
Oldemar Rodriguez Rojas
}
\keyword{Correlation}
\keyword{Symbolic}
