% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsnns.R
\name{train}
\alias{train}
\alias{train.rsnns}
\title{Internal generic train function for rsnns objects}
\usage{
train(object, ...)

\method{train}{rsnns}(
  object,
  inputsTrain,
  targetsTrain = NULL,
  inputsTest = NULL,
  targetsTest = NULL,
  serializeTrainedObject = TRUE,
  ...
)
}
\arguments{
\item{object}{the \code{\link{rsnns}} object}

\item{...}{additional function parameters (currently not used)}

\item{inputsTrain}{training input}

\item{targetsTrain}{training targets}

\item{inputsTest}{test input}

\item{targetsTest}{test targets}

\item{serializeTrainedObject}{parameter passed to \code{\link{SnnsRObject$train}}}
}
\value{
an \code{\link{rsnns}} object, to which the results of training have been added.
}
\description{
The function calls \code{\link{SnnsRObject$train}} and saves the result in the
current \code{\link{rsnns}} object. This function is used internally by the 
models (e.g. \code{\link{mlp}}) for training. Unless you are not about to implement
a new model on the S3 layer you most probably don't want to use this function.
}
